/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudTagList;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;

@Entity(name="cloudaccount")
public class CloudAccount {
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Tenant tenant;
    @Id
    private String id;
    private String label;
    @Column(columnDefinition="text")
    private String description;
    @Column(columnDefinition="text")
    private String cloudTags;
    @Enumerated(value=EnumType.STRING)
    private AWSAuthenticationMode awsAuthenticationMode;
    @Column(columnDefinition="text")
    private String awsIAMRoleExternalId;
    private String awsIAMRoleARN;
    private String awsAccessKeyId;
    @Column(columnDefinition="text")
    private String awsSecretAccessKey;
    @Enumerated(value=EnumType.STRING)
    private AzureAuthenticationMode azureAuthenticationMode;
    private boolean isEncrypted = false;
    private String azureEnvironment;
    private String azureSubscription;
    private String azureTenantId;
    private String azureManagedIdentityId;
    private String azureClientId;
    @Column(columnDefinition="text")
    private String azureSecret;
    private String azureCertificatePath;
    @Column(columnDefinition="text")
    private String azureCertificatePassword;
    private String azureImageResourceGroup;
    @Enumerated(value=EnumType.STRING)
    private GCPAuthenticationMode gcpAuthenticationMode;
    private String gcpProjectId;
    @Column(columnDefinition="text")
    private String gcpServiceAccountKey;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.isEncrypted = encrypted;
    }

    public AWSAuthenticationMode getAwsAuthenticationMode() {
        return this.awsAuthenticationMode;
    }

    public void setAwsAuthenticationMode(AWSAuthenticationMode awsAuthenticationMode) {
        this.awsAuthenticationMode = awsAuthenticationMode;
    }

    public String getAwsIAMRoleExternalId() {
        return this.awsIAMRoleExternalId;
    }

    public void setAwsIAMRoleExternalId(String awsIAMRoleExternalId) {
        this.awsIAMRoleExternalId = awsIAMRoleExternalId;
    }

    public String getAwsIAMRoleARN() {
        return this.awsIAMRoleARN;
    }

    public void setAwsIAMRoleARN(String awsIAMRoleARN) {
        this.awsIAMRoleARN = awsIAMRoleARN;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public AzureAuthenticationMode getAzureAuthenticationMode() {
        return this.azureAuthenticationMode;
    }

    public void setAzureAuthenticationMode(AzureAuthenticationMode azureAuthenticationMode) {
        this.azureAuthenticationMode = azureAuthenticationMode;
    }

    public String getAzureSubscription() {
        return this.azureSubscription;
    }

    public void setAzureSubscription(String azureSubscription) {
        this.azureSubscription = azureSubscription;
    }

    public String getAzureManagedIdentityId() {
        return this.azureManagedIdentityId;
    }

    public void setAzureManagedIdentityId(String azureManagedIdentityId) {
        this.azureManagedIdentityId = azureManagedIdentityId;
    }

    public String getAzureClientId() {
        return this.azureClientId;
    }

    public void setAzureClientId(String azureClientId) {
        this.azureClientId = azureClientId;
    }

    public String getAzureSecret() {
        return this.azureSecret;
    }

    public void setAzureSecret(String azureSecret) {
        this.azureSecret = azureSecret;
    }

    public String getAzureCertificatePath() {
        return this.azureCertificatePath;
    }

    public void setAzureCertificatePath(String azureCertificatePath) {
        this.azureCertificatePath = azureCertificatePath;
    }

    public String getAzureCertificatePassword() {
        return this.azureCertificatePassword;
    }

    public void setAzureCertificatePassword(String azureCertificatePassword) {
        this.azureCertificatePassword = azureCertificatePassword;
    }

    public String getAzureEnvironment() {
        return this.azureEnvironment;
    }

    public void setAzureEnvironment(String azureEnvironment) {
        this.azureEnvironment = azureEnvironment;
    }

    public String getAzureTenantId() {
        return this.azureTenantId;
    }

    public String getAzureImageResourceGroup() {
        return this.azureImageResourceGroup;
    }

    public void setAzureImageResourceGroup(String azureImageResourceGroup) {
        this.azureImageResourceGroup = azureImageResourceGroup;
    }

    public void setAzureTenantId(String azureTenantId) {
        this.azureTenantId = azureTenantId;
    }

    public GCPAuthenticationMode getGcpAuthenticationMode() {
        return this.gcpAuthenticationMode;
    }

    public void setGcpAuthenticationMode(GCPAuthenticationMode gcpAuthenticationMode) {
        this.gcpAuthenticationMode = gcpAuthenticationMode;
    }

    public String getGcpProjectId() {
        return this.gcpProjectId;
    }

    public void setGcpProjectId(String gcpProjectId) {
        this.gcpProjectId = gcpProjectId;
    }

    public String getGcpServiceAccountKeyOrKeyPath() {
        return this.gcpServiceAccountKey;
    }

    public void setGcpServiceAccountKey(String gcpServiceAccountKey) {
        this.gcpServiceAccountKey = gcpServiceAccountKey;
    }

    public String getCloudTags() {
        return this.cloudTags;
    }

    public void setCloudTags(String cloudTags) {
        this.cloudTags = cloudTags;
    }

    public String getCacheKeyOfAzureFields() {
        StringJoiner key = new StringJoiner("___").add(this.id).add(this.azureClientId).add(this.azureSubscription).add(this.azureTenantId).add(this.azureEnvironment);
        if (StringUtils.isNotEmpty((String)this.azureManagedIdentityId)) {
            key.add(this.azureManagedIdentityId);
        }
        if (StringUtils.isNotEmpty((String)this.azureSecret)) {
            key.add(this.azureSecret);
        }
        return key.toString();
    }

    public CloudTagList getInheritedCloudTags() {
        return CloudTagList.fromJSON(this.tenant.getCloudTags());
    }

    public CloudTagList getCloudApplicableTags() {
        return this.tenant.getCloudApplicableTags().with(CloudTagList.fromJSON(this.getCloudTags())).with("fm:cloudAccountId", this.getId());
    }

    public static enum AWSAuthenticationMode {
        DEFAULT_INSTANCE_CREDENTIALS,
        IAM_ROLE,
        KEYPAIR;

    }

    public static enum AzureAuthenticationMode {
        DEFAULT_INSTANCE_CREDENTIALS,
        MANAGED_IDENTITY,
        OAUTH2_AUTHENTICATION_METHOD_CLIENT_SECRET,
        OAUTH2_AUTHENTICATION_METHOD_CERTIFICATE;

    }

    public static enum GCPAuthenticationMode {
        DEFAULT_INSTANCE_CREDENTIALS,
        JSON_KEY;

    }
}

