/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.util.PasswordUtils;
import com.dataiku.fm.model.db.FMUser;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import javax.annotation.CheckForNull;

@Entity(name="fmpersonalapikey")
public class FMPersonalAPIKey {
    @Id
    private String keyId;
    @ManyToOne(fetch=FetchType.EAGER)
    private FMUser user;
    private String secretHash;
    private Date creationDate;

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public FMUser getUser() {
        return this.user;
    }

    public void setUser(FMUser user) {
        this.user = user;
    }

    public String getSecretHash() {
        return this.secretHash;
    }

    public void setSecretHash(String secretHash) {
        this.secretHash = secretHash;
    }

    @CheckForNull
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean verifySecret(String unencryptedSecret) throws CodedException {
        if (this.secretHash == null) {
            return false;
        }
        return PasswordUtils.verifyPassword((String)unencryptedSecret, (String)this.secretHash);
    }
}

