/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.AzureLoadbalancerTier;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.FMSettings;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

@Entity(name="logicalloadbalancer")
public class LogicalLoadBalancer {
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Tenant tenant;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private VirtualNetwork virtualNetwork;
    @Enumerated(value=EnumType.STRING)
    private AzureLoadbalancerTier tier;
    @Enumerated(value=EnumType.STRING)
    private CertificateMode certificateMode = CertificateMode.NO_CERTIFICATE;
    private String awsCertificateARN;
    private String awsManagedCertificateARN;
    private String azureCertificateSecretId;
    @Enumerated(value=EnumType.STRING)
    private LoadBalancerPublicIPMode publicIpMode;
    private String azurePublicIPID;
    private String name;
    @Column(columnDefinition="text")
    private String description;
    @Column(columnDefinition="text")
    private String cloudTags;
    @OneToMany(mappedBy="logicalLoadBalancer", cascade={CascadeType.ALL})
    private Set<LoadBalancerNodeMapping> loadBalancerNodeMapping = new HashSet<LoadBalancerNodeMapping>();
    @OneToOne(mappedBy="logicalLoadBalancer", fetch=FetchType.LAZY)
    private PhysicalLoadBalancer currentPhysicalLoadBalancer;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public void setVirtualNetwork(VirtualNetwork virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
    }

    public AzureLoadbalancerTier getTier() {
        return this.tier;
    }

    public void setTier(AzureLoadbalancerTier tier) {
        this.tier = tier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public String getCloudTags() {
        return this.cloudTags;
    }

    public void setCloudTags(String cloudTags) {
        this.cloudTags = cloudTags;
    }

    public Set<LoadBalancerNodeMapping> getLoadBalancerNodeMapping() {
        return this.loadBalancerNodeMapping;
    }

    public Map<String, Set<LoadBalancerNodeMapping>> getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN() {
        return this.loadBalancerNodeMapping.stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.ACTIVE).collect(HashMap::new, (map, mapping) -> map.computeIfAbsent(mapping.getSubdomainOrFQDN(), k -> new HashSet()).add(mapping), HashMap::putAll);
    }

    public void setLoadBalancerNodeMapping(Set<LoadBalancerNodeMapping> loadBalancerNodeMapping) {
        this.loadBalancerNodeMapping = loadBalancerNodeMapping;
    }

    public CertificateMode getCertificateMode() {
        return this.certificateMode;
    }

    public void setCertificateMode(CertificateMode certificateMode) {
        this.certificateMode = certificateMode;
    }

    public String getAwsCertificateARN() {
        return this.awsCertificateARN;
    }

    public void setAwsCertificateARN(String awsCertificateARN) {
        this.awsCertificateARN = awsCertificateARN;
    }

    @Nullable
    public String getAwsManagedCertificateARN() {
        return this.awsManagedCertificateARN;
    }

    public void setAwsManagedCertificateARN(String awsManagedCertificateARN) {
        this.awsManagedCertificateARN = awsManagedCertificateARN;
    }

    public String getAzureCertificateSecretId() {
        return this.azureCertificateSecretId;
    }

    public void setAzureCertificateSecretId(String azureCertificateSecretId) {
        this.azureCertificateSecretId = azureCertificateSecretId;
    }

    public LoadBalancerPublicIPMode getPublicIpMode() {
        return this.publicIpMode;
    }

    public void setPublicIpMode(LoadBalancerPublicIPMode publicIpMode) {
        this.publicIpMode = publicIpMode;
    }

    public String getAzurePublicIPID() {
        return this.azurePublicIPID;
    }

    public void setAzurePublicIPID(String azurePublicIPID) {
        this.azurePublicIPID = azurePublicIPID;
    }

    @CheckForNull
    public PhysicalLoadBalancer getCurrentPhysicalLoadBalancer() {
        return this.currentPhysicalLoadBalancer;
    }

    public void setCurrentPhysicalLoadBalancer(PhysicalLoadBalancer currentPhysicalLoadBalancer) {
        this.currentPhysicalLoadBalancer = currentPhysicalLoadBalancer;
    }

    public CloudTagList getInheritedCloudTags(FMSettings settings) {
        return this.virtualNetwork.getInheritedCloudTags(settings).with(CloudTagList.fromJSON(this.virtualNetwork.getCloudTags()));
    }

    public CloudTagList getCloudApplicableTags(FMSettings settings) {
        return this.virtualNetwork.getCloudApplicableTags(settings).with(CloudTagList.fromJSON(this.getCloudTags())).with("fm:loadBalancerId", this.getId());
    }
}

