/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.settings;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import java.io.File;
import java.io.IOException;

public class InstanceImagesSettingsRepository {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.images");
    private final Cloud cloud;

    public static InstanceImagesSettingsRepository of(Cloud cloud) {
        return new InstanceImagesSettingsRepository(cloud);
    }

    private InstanceImagesSettingsRepository(Cloud cloud) {
        this.cloud = cloud;
    }

    public void update(InstanceImagesSettings instanceImagesSettings) throws IOException {
        File targetFile = this.getAutoUpdatedInstanceImagesFile();
        DKUFileUtils.mkdirsParent((File)targetFile);
        File backupFile = null;
        if (targetFile.isFile()) {
            backupFile = new File(targetFile.getParent(), targetFile.getName() + "-backup-" + DKUDateUtils.isoFormatFileFriendlyLocalNow());
            FileUtils.copyFile((File)targetFile, (File)backupFile);
        }
        logger.info((Object)("Saving new instance images at " + String.valueOf(targetFile)));
        DKUFileUtils.writeFileUTF8((File)targetFile, (String)JSON.pretty((Object)instanceImagesSettings));
        if (backupFile != null && FileUtils.contentEquals((File)targetFile, (File)backupFile)) {
            backupFile.delete();
        } else {
            logger.info((Object)("Backed up previous instance images at " + String.valueOf(backupFile)));
        }
    }

    public InstanceImagesSettings getAll() throws IOException {
        File userFile = DKUApp.getUserResourceFile((String[])new String[]{this.cloud.instanceImagesFilename});
        File autoUpdatedFile = this.getAutoUpdatedInstanceImagesFile();
        File kitFile = DKUApp.getResourceFile((String)this.cloud.instanceImagesFilename);
        if (userFile.isFile()) {
            logger.info((Object)("Reading instance images from user-forced location: " + String.valueOf(userFile)));
            return (InstanceImagesSettings)JSON.parseFile((File)userFile, InstanceImagesSettings.class);
        }
        if (autoUpdatedFile.isFile()) {
            logger.info((Object)("Reading instance images from auto-update location: " + String.valueOf(autoUpdatedFile)));
            return (InstanceImagesSettings)JSON.parseFile((File)autoUpdatedFile, InstanceImagesSettings.class);
        }
        logger.info((Object)("Reading instance images from kit: " + String.valueOf(kitFile)));
        return (InstanceImagesSettings)JSON.parseFile((File)kitFile, InstanceImagesSettings.class);
    }

    private File getAutoUpdatedInstanceImagesFile() {
        return DKUApp.getUserResourceFile((String[])new String[]{"auto-updated-images", "fm-" + FMApp.getDSSVersion().product_version, this.cloud.instanceImagesFilename});
    }
}

