/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.fm.model.db.CheckDefinition;
import com.dataiku.fm.model.db.CheckElementType;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.ElementCheck;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.MessagingChannel;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.utils.APIInputValidator;
import jakarta.persistence.EntityManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertingDBService {
    public static final String MSG_TENANT_ID_MISSING = "The tenant ID is missing.";
    private static final String MSG_TENANT_NOT_EXISTING = "The specified tenant does not exist.";
    private static final String MSG_MESSAGING_CHANNEL_DOES_NOT_EXIST = "The specified messaging channel does not exist.";
    @Autowired
    private DatabaseAccessService dbService;

    public DatabaseAccessService.ReadWriteTransaction rwTransaction() {
        return this.dbService.rwTransaction();
    }

    public void close() {
        this.dbService.close();
    }

    public EntityManager getThreadEM() {
        return this.dbService.getThreadEM();
    }

    @Nonnull
    public Tenant getMandatoryTenant(String tenantId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        APIInputValidator.checkNotNull(tenant, MSG_TENANT_NOT_EXISTING, new Object[0]);
        return tenant;
    }

    public MessagingChannel getSingleMessagingChannel(String tenantId, String messagingChannelId) {
        return this.dbService.getSingleResult(MessagingChannel.class, "select mc from messagingchannel mc where mc.tenant.id = ?1 and mc.id = ?2", tenantId, messagingChannelId);
    }

    @Nonnull
    public MessagingChannel getMandatoryMessagingChannel(String tenantId, String messagingChannelId) {
        MessagingChannel messagingChannel = this.getSingleMessagingChannel(tenantId, messagingChannelId);
        if (messagingChannel == null) {
            APIInputValidator.throwInvalidArgumentException(MSG_MESSAGING_CHANNEL_DOES_NOT_EXIST, new Object[0]);
        }
        return messagingChannel;
    }

    public List<MessagingChannel> getAllMessagingChannels(String tenantId) {
        return this.dbService.listResults(MessagingChannel.class, "select mc from messagingchannel mc where mc.tenant.id = ?1", tenantId);
    }

    public CheckReporter getSingleCheckReporter(String tenantId, String checkReporterId) {
        return this.dbService.getSingleResult(CheckReporter.class, "select cr from checkreporter cr where cr.tenant.id = ?1 and cr.id = ?2", tenantId, checkReporterId);
    }

    public List<CheckReporter> getMultipleCheckReporters(String tenantId, List<String> checkReporterIds) {
        return this.dbService.listResults(CheckReporter.class, "select cr from checkreporter cr where cr.tenant.id = ?1 and cr.id in (?2)", tenantId, String.join((CharSequence)",", checkReporterIds));
    }

    public List<CheckReporter> getAllCheckReporters(String tenantId) {
        return this.dbService.listResults(CheckReporter.class, "select cr from checkreporter cr where cr.tenant.id = ?1", tenantId);
    }

    public CheckDefinition getSingleCheckDefinition(String tenantId, String checkDefinitionId) {
        return this.dbService.getSingleResult(CheckDefinition.class, "select cd from checkdefinition cd where cd.tenant.id = ?1 and cd.id = ?2", tenantId, checkDefinitionId);
    }

    public List<CheckDefinition> getAllCheckDefinitions(String tenantId) {
        return this.dbService.listResults(CheckDefinition.class, "select cd from checkdefinition cd where cd.tenant.id = ?1", tenantId);
    }

    public List<ElementCheck> getAllElementChecksForCheckDefinition(String checkDefinitionId) {
        return this.dbService.listResults(ElementCheck.class, "select ec from elementcheck ec where ec.checkDefinition.id = ?1", checkDefinitionId);
    }

    public List<ElementCheck> getAllElementChecksForLogicalInstance(String logicalInstanceId) {
        return this.dbService.listResults(ElementCheck.class, "select ec from elementcheck ec where ec.elementType = ?1 and ec.elementId = ?2", new Object[]{CheckElementType.LOGICAL_INSTANCE, logicalInstanceId});
    }

    public List<ElementCheck> getAllElementChecksByStatus(boolean enabled) {
        return this.dbService.listResults(ElementCheck.class, "select ec from elementcheck ec where ec.enabled = ?1", enabled);
    }

    public void saveElementCheck(ElementCheck elementCheck) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().merge((Object)elementCheck);
            rwt.commit();
        }
    }

    @Nullable
    public LogicalInstance getLogicalInstanceById(String logicalInstanceId) {
        return this.dbService.getSingleResult(LogicalInstance.class, "select li from logicalinstance li where li.id = ?1", logicalInstanceId);
    }

    @Nonnull
    public LogicalInstance getMandatoryLogicalInstanceById(String logicalInstanceId) {
        LogicalInstance logicalInstance = this.getLogicalInstanceById(logicalInstanceId);
        assert (logicalInstance != null);
        return logicalInstance;
    }
}

