/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.fm.model.published.AlertingConfigurationDTO;
import com.dataiku.fm.model.published.ProtoAlertingConfiguration;
import com.dataiku.fm.model.published.ProtoCheckDefinition;
import com.dataiku.fm.model.published.ProtoCheckReporter;
import com.dataiku.fm.server.alerts.AlertingDBService;
import com.dataiku.fm.server.alerts.CheckDefinitionCRUDService;
import com.dataiku.fm.server.alerts.CheckReporterCRUDService;
import com.dataiku.fm.server.alerts.MessagingChannelCRUDService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertingUIService {
    @Autowired
    private CheckDefinitionCRUDService checkDefinitionCRUDService;
    @Autowired
    private MessagingChannelCRUDService messagingChannelCRUDService;
    @Autowired
    private CheckReporterCRUDService checkReporterCRUDService;
    @Autowired
    private AlertingDBService dbService;

    public AlertingConfigurationDTO list(String tenantId) {
        AlertingConfigurationDTO alertingDTO = new AlertingConfigurationDTO();
        alertingDTO.messagingChannels = this.messagingChannelCRUDService.list(tenantId);
        alertingDTO.checkReporters = this.checkReporterCRUDService.list(tenantId);
        alertingDTO.checkDefinitions = this.checkDefinitionCRUDService.list(tenantId);
        return alertingDTO;
    }

    public AlertingConfigurationDTO update(String tenantId, ProtoAlertingConfiguration protoAlerting) {
        AlertingConfigurationDTO alertingDTO = new AlertingConfigurationDTO();
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            alertingDTO.messagingChannels = this.messagingChannelCRUDService.bulkUpsert(tenantId, protoAlerting.messagingChannels, rwt);
            for (ProtoCheckReporter protoCheckReporter : protoAlerting.checkReporters) {
                protoCheckReporter.messagingChannelId = alertingDTO.messagingChannels.get((int)0).id;
            }
            alertingDTO.checkReporters = this.checkReporterCRUDService.bulkUpsert(tenantId, protoAlerting.checkReporters, rwt);
            for (ProtoCheckDefinition protoCheckDefinition : protoAlerting.checkDefinitions) {
                protoCheckDefinition.checkReporterIds = List.of(alertingDTO.checkReporters.get((int)0).id);
            }
            alertingDTO.checkDefinitions = this.checkDefinitionCRUDService.bulkUpsert(tenantId, protoAlerting.checkDefinitions, rwt);
            rwt.commit();
        }
        return alertingDTO;
    }
}

