/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.CheckDefinition;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.MessagingChannel;
import com.dataiku.fm.model.db.MessagingChannelType;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CheckReporterDTO;
import com.dataiku.fm.model.published.ProtoCheckReporter;
import com.dataiku.fm.server.alerts.AlertingDBService;
import com.dataiku.fm.server.alerts.AlertingUtils;
import com.dataiku.fm.server.alerts.CheckReporterService;
import com.dataiku.fm.server.alerts.messagebuilders.MessageBuilder;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.utils.APIInputValidator;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckReporterCRUDService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checkReporterCRUDService");
    private static final String MSG_TENANT_ID_MISSING = "The tenant ID is missing.";
    private static final String MSG_MESSAGING_CHANNEL_TYPE_EMPTY = "The messaging channel type in the specified reporter is missing.";
    private static final String MSG_MESSAGING_CHANNEL_EMPTY = "The messaging channel in the specified reporter is missing.";
    private static final String MSG_MESSAGING_CHANNEL_TYPES_MISMATCH = "The specified messaging channel type of the chosen messaging channel is not compatible with the check reporter messaging channel type. They should be identical.";
    private static final String MSG_CONFIGURATION_INVALID = "The JSON structure of the configuration supplied for the check reporter does not match the messaging channel type.";
    private static final String MSG_CONFIGURATION_NULL = "The check reporter configuration is missing.";
    private static final String MSG_CHECK_REPORTER_ID_EMPTY = "The check reporter ID is missing.";
    private static final String MSG_CHECK_REPORTERS_EMPTY = "The supplied list of check reporters is empty.";
    @Autowired
    private AlertingDBService dbService;
    @Autowired
    private CheckReporterService checkReporterService;

    private CheckReporter create(Tenant tenant, @Nullable MessagingChannel messagingChannel, ProtoCheckReporter protoCheckReporter, DatabaseAccessService.ReadWriteTransaction rwt) {
        CheckReporter checkReporter = this.buildEntity(tenant, messagingChannel, protoCheckReporter);
        String newId = "cr-" + SecretKeyGenerator.generate((int)12);
        checkReporter.setId(newId);
        rwt.getThreadEM().persist((Object)checkReporter);
        if (messagingChannel != null) {
            messagingChannel.getCheckReporters().add(checkReporter);
            rwt.getThreadEM().merge((Object)messagingChannel);
        }
        return checkReporter;
    }

    private void validateInput(String tenantId, ProtoCheckReporter protoCheckReporter) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotNull((Object)protoCheckReporter.messagingChannelType, MSG_MESSAGING_CHANNEL_TYPE_EMPTY, new Object[0]);
        APIInputValidator.checkNotEmpty(protoCheckReporter.configuration, MSG_CONFIGURATION_NULL, new Object[0]);
    }

    private void validateTypes(MessagingChannelType checkReporterType, MessagingChannelType messagingChannelType) {
        if (checkReporterType != messagingChannelType) {
            APIInputValidator.throwInvalidArgumentException(MSG_MESSAGING_CHANNEL_TYPES_MISMATCH, new Object[0]);
        }
    }

    private CheckReporter buildEntity(Tenant tenant, MessagingChannel messagingChannel, ProtoCheckReporter protoCheckReporter) {
        CheckReporter checkReporter = new CheckReporter();
        checkReporter.setTenant(tenant);
        checkReporter.setMessagingChannelType(protoCheckReporter.messagingChannelType);
        checkReporter.setMessagingChannel(messagingChannel);
        this.setSanitizedConfiguration(protoCheckReporter, checkReporter);
        return checkReporter;
    }

    private void setSanitizedConfiguration(ProtoCheckReporter protoCheckReporter, CheckReporter checkReporter) {
        checkReporter.setConfigurationVersion(AlertingUtils.getCheckReporterConfigurationDefaultVersion(checkReporter.getMessagingChannelType()));
        try {
            MessageBuilder messageBuilder = this.checkReporterService.getMessageBuilder(checkReporter.getMessagingChannelType(), checkReporter.getConfigurationVersion());
            checkReporter.setConfiguration(messageBuilder.sanitizeConfiguration(protoCheckReporter.configuration));
        }
        catch (JsonSyntaxException e) {
            logger.errorV((Throwable)e, MSG_CONFIGURATION_INVALID, new Object[0]);
            APIInputValidator.throwInvalidArgumentException(MSG_CONFIGURATION_INVALID, new Object[0]);
        }
    }

    private CheckReporterDTO convertToDTO(CheckReporter checkReporter) {
        CheckReporterDTO checkReporterDTO = new CheckReporterDTO();
        checkReporterDTO.id = checkReporter.getId();
        checkReporterDTO.messagingChannelType = checkReporter.getMessagingChannelType();
        if (checkReporter.getMessagingChannel() != null) {
            checkReporterDTO.messagingChannelId = checkReporter.getMessagingChannel().getId();
        }
        checkReporterDTO.configuration = checkReporter.getConfiguration();
        checkReporterDTO.configurationVersion = checkReporter.getConfigurationVersion();
        return checkReporterDTO;
    }

    public CheckReporterDTO get(String tenantId, String checkReporterId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotBlank(checkReporterId, MSG_CHECK_REPORTER_ID_EMPTY, new Object[0]);
        CheckReporter checkReporter = this.dbService.getSingleCheckReporter(tenantId, checkReporterId);
        if (checkReporter == null) {
            return null;
        }
        return this.convertToDTO(checkReporter);
    }

    public void delete(String tenantId, String checkReporterId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotBlank(checkReporterId, MSG_CHECK_REPORTER_ID_EMPTY, new Object[0]);
        this.dbService.getMandatoryTenant(tenantId);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            CheckReporter checkReporter = this.dbService.getSingleCheckReporter(tenantId, checkReporterId);
            if (checkReporter == null) {
                return;
            }
            this.delete(checkReporter, rwt);
            rwt.commit();
        }
    }

    private void delete(CheckReporter checkReporter, DatabaseAccessService.ReadWriteTransaction rwt) {
        if (checkReporter.getMessagingChannel() != null) {
            MessagingChannel messagingChannel = checkReporter.getMessagingChannel();
            messagingChannel.getCheckReporters().remove(checkReporter);
            checkReporter.setMessagingChannel(null);
            rwt.getThreadEM().merge((Object)messagingChannel);
        }
        for (CheckDefinition checkDefinition : checkReporter.getCheckDefinitions()) {
            checkDefinition.getCheckReporters().remove(checkReporter);
            rwt.getThreadEM().merge((Object)checkDefinition);
        }
        rwt.getThreadEM().remove((Object)checkReporter);
    }

    public CheckReporterDTO upsert(String tenantId, ProtoCheckReporter protoCheckReporter) {
        this.validateInput(tenantId, protoCheckReporter);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        if (protoCheckReporter.messagingChannelId != null) {
            APIInputValidator.checkNotEmpty(protoCheckReporter.messagingChannelId, MSG_MESSAGING_CHANNEL_EMPTY, new Object[0]);
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            CheckReporter checkReporter = this.upsert(tenant, protoCheckReporter, rwt);
            rwt.commit();
            CheckReporterDTO checkReporterDTO = this.convertToDTO(checkReporter);
            return checkReporterDTO;
        }
    }

    private CheckReporter upsert(Tenant tenant, ProtoCheckReporter protoCheckReporter, DatabaseAccessService.ReadWriteTransaction rwt) {
        CheckReporter checkReporter = this.dbService.getSingleCheckReporter(tenant.getId(), protoCheckReporter.id);
        MessagingChannel messagingChannel = null;
        if (protoCheckReporter.messagingChannelId != null) {
            messagingChannel = this.dbService.getMandatoryMessagingChannel(tenant.getId(), protoCheckReporter.messagingChannelId);
            if (checkReporter != null) {
                this.validateTypes(checkReporter.getMessagingChannelType(), messagingChannel.getType());
            }
        }
        if (checkReporter == null) {
            return this.create(tenant, messagingChannel, protoCheckReporter, rwt);
        }
        if (protoCheckReporter.messagingChannelId != null) {
            this.updateMessagingChannel(checkReporter, messagingChannel, rwt);
        }
        this.setSanitizedConfiguration(protoCheckReporter, checkReporter);
        rwt.getThreadEM().merge((Object)checkReporter);
        return checkReporter;
    }

    private void updateMessagingChannel(CheckReporter checkReporter, @Nullable MessagingChannel newMessagingChannel, DatabaseAccessService.ReadWriteTransaction rwt) {
        MessagingChannel previousMessagingChannel = checkReporter.getMessagingChannel();
        if (previousMessagingChannel != null) {
            previousMessagingChannel.getCheckReporters().remove(checkReporter);
            rwt.getThreadEM().merge((Object)previousMessagingChannel);
        }
        if (newMessagingChannel != null) {
            checkReporter.setMessagingChannel(newMessagingChannel);
            rwt.getThreadEM().merge((Object)checkReporter);
            newMessagingChannel.getCheckReporters().add(checkReporter);
            rwt.getThreadEM().merge((Object)newMessagingChannel);
        }
    }

    public List<CheckReporterDTO> bulkUpsert(String tenantId, List<ProtoCheckReporter> protoCheckReporters, DatabaseAccessService.ReadWriteTransaction rwt) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotNull(protoCheckReporters, MSG_CHECK_REPORTERS_EMPTY, new Object[0]);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        ArrayList<CheckReporter> checkReporters = new ArrayList<CheckReporter>();
        List<CheckReporter> existingCheckReporters = this.dbService.getAllCheckReporters(tenantId);
        Set protoCheckReporterIds = protoCheckReporters.stream().map(protoCheckReporter -> protoCheckReporter.id).collect(Collectors.toSet());
        for (CheckReporter existingCheckReporter : existingCheckReporters) {
            if (protoCheckReporterIds.contains(existingCheckReporter.getId())) continue;
            this.delete(existingCheckReporter, rwt);
        }
        for (ProtoCheckReporter protoCheckReporter2 : protoCheckReporters) {
            this.validateInput(tenantId, protoCheckReporter2);
            CheckReporter checkReporter = this.upsert(tenant, protoCheckReporter2, rwt);
            checkReporters.add(checkReporter);
        }
        return this.convertToDTO(checkReporters);
    }

    private List<CheckReporterDTO> convertToDTO(List<CheckReporter> checkReporters) {
        ArrayList<CheckReporterDTO> checkReporterDTOS = new ArrayList<CheckReporterDTO>();
        if (checkReporters == null || checkReporters.isEmpty()) {
            return checkReporterDTOS;
        }
        for (CheckReporter checkReporter : checkReporters) {
            checkReporterDTOS.add(this.convertToDTO(checkReporter));
        }
        return checkReporterDTOS;
    }

    public List<CheckReporterDTO> list(String tenantId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        List<CheckReporter> checkReporters = this.dbService.getAllCheckReporters(tenantId);
        return checkReporters.stream().map(this::convertToDTO).collect(Collectors.toList());
    }
}

