/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.checkers;

import com.dataiku.fm.model.Utils;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.alerts.AlertingDBService;
import com.dataiku.fm.server.alerts.CheckResult;
import com.dataiku.fm.server.alerts.checkers.Checker;
import com.dataiku.fm.server.instances.InstancesHelper;
import java.util.Optional;
import java.util.function.Function;

public abstract class LogicalInstanceChecker
extends Checker {
    protected static final String ELEMENT_TYPE_DESCRIPTION = "instance";

    @Override
    public CheckResult check(String configuration, String elementId, AlertingDBService dbService) {
        return this.check(configuration, (LogicalInstance)dbService.getThreadEM().find(LogicalInstance.class, (Object)elementId));
    }

    protected abstract CheckResult check(String var1, LogicalInstance var2);

    protected Optional<Double> getDiskUsagePercentage(LogicalInstance logicalInstance, Function<AgentAPIController.HeartbeatState, Long> usageGetter, Function<AgentAPIController.HeartbeatState, Long> totalGetter) {
        if (logicalInstance.getCurrentPhysicalInstance() == null || InstancesHelper.isLogicalInstanceInTimeout(logicalInstance)) {
            return Optional.empty();
        }
        PhysicalInstance physicalInstance = logicalInstance.getCurrentPhysicalInstance();
        Optional<AgentAPIController.HeartbeatState> heartbeatState = Utils.parseHeartbeatState(Optional.ofNullable(physicalInstance.getLastHeartbeatState()));
        return Utils.computePercentage(heartbeatState.map(usageGetter), heartbeatState.map(totalGetter));
    }
}

