/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.util.DKUDebugUtils;
import com.dataiku.fm.server.core.CloudDataSyncService;
import com.dataiku.fm.server.security.FMMetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Writer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FMDebugController
extends DIPInternalControllerBase {
    @Autowired
    private FMMetaAuthService metaAuthService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/debug/dump-stacks"})
    public void dumpStacks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        DKUDebugUtils.printAllStacks((Writer)resp.getWriter());
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/debug/force-instance-images-refresh"})
    public void refreshInstanceImages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        ((CloudDataSyncService)SpringUtils.getBean(CloudDataSyncService.class)).forceImmediateRefresh();
    }
}

