/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.fm.cloud.CloudNetworkService;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.intellij.lang.annotations.PrintFormat;
import org.springframework.beans.factory.annotation.Autowired;

public class VirtualNetworksService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudNetworkService cloudNetworkService;
    @Autowired
    private FutureServiceBase futureService;

    public VirtualNetworkSettingsDTO createVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO in, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        VirtualNetwork vn = null;
        switch (in.mode) {
            case FM_MANAGED: {
                vn = this.cloudNetworkService.createManagedVirtualNetwork(tenantId, in, smartLogTail);
                break;
            }
            case EXISTING_MONOTENANT: 
            case EXISTING_MULTITENANT_PUBLIC_IP: {
                vn = this.cloudNetworkService.createUnmanagedVirtualNetwork(tenantId, in, smartLogTail);
            }
        }
        return this.convertToDtoAndEnrich(vn, FMApp.getFMSettingsUnsafe());
    }

    public ProtoVirtualNetworkDTO getDefaultCreationValues(Tenant tenant) {
        ProtoVirtualNetworkDTO result = new ProtoVirtualNetworkDTO();
        if (FMApp.getFMSettingsUnsafe().tenancy == FMTenancy.MONOTENANT) {
            result.mode = VirtualNetwork.VirtualNetworkMode.EXISTING_MONOTENANT;
            result.accountId = null;
            VirtualNetworkMetadata creationValues = this.cloudNetworkService.getDefaultCreationValues(tenant.getId());
            result.awsVpcId = creationValues.awsVpcId;
            result.awsSubnetId = creationValues.awsSubnetId;
            result.azureVnId = creationValues.azureVNId;
            result.azureSubnetId = creationValues.azureSubnetName;
            result.gcpProjectId = creationValues.gcpProjectId;
            result.gcpNetwork = creationValues.gcpNetwork;
            result.gcpSubnetwork = creationValues.gcpSubnetwork;
            result.gcpNetworkTags = new ArrayList<String>();
        } else {
            result.mode = VirtualNetwork.VirtualNetworkMode.FM_MANAGED;
        }
        result.awsSecurityGroups = new ArrayList<String>();
        result.awsAutoCreateSecurityGroups = true;
        result.autoCreatePeerings = true;
        result.internetAccessMode = ProtoVirtualNetworkDTO.InternetAccessMode.YES;
        return result;
    }

    public FutureResponse<VirtualNetworkSettingsDTO> startCreate(FMAuthCtx authCtx, ProtoVirtualNetworkDTO dto) throws Exception {
        VirtualNetworkCreationThread ft = new VirtualNetworkCreationThread(authCtx, dto);
        return this.futureService.runFuture((FutureThreadBase)ft, 0L, (TypeToken)new TypeToken<FutureResponse<VirtualNetworkSettingsDTO>>(){});
    }

    public FutureResponse<CommandResult> startDelete(FMAuthCtx authCtx, String virtualNetworkId, boolean deleteAutogeneratedSecurityGroups, boolean deleteAutogeneratedPeering) throws Exception {
        VirtualNetworkDeletionThread ft = new VirtualNetworkDeletionThread(authCtx, virtualNetworkId, deleteAutogeneratedSecurityGroups, deleteAutogeneratedPeering);
        return this.futureService.runFuture((FutureThreadBase)ft, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public static List<VirtualNetwork> getNetworks(Tenant tenant, DatabaseAccessService service) {
        return service.listResults(VirtualNetwork.class, "SELECT vn from virtualnetwork vn where vn.tenant=?1", tenant);
    }

    public List<VirtualNetworkSettingsDTO> list(Tenant tenant) {
        ArrayList<VirtualNetworkSettingsDTO> ret = new ArrayList<VirtualNetworkSettingsDTO>();
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, this.dbService)) {
            ret.add(this.convertToDtoAndEnrich(vn, fmSettings));
        }
        return ret;
    }

    public VirtualNetworkSettingsDTO getVirtualNetworkDTO(Tenant tenant, String vnId) {
        VirtualNetwork vn = this.getVirtualNetworkMandatory(tenant, vnId);
        return this.convertToDtoAndEnrich(vn, FMApp.getFMSettingsUnsafe());
    }

    public VirtualNetwork getVirtualNetworkMandatory(Tenant tenant, String vnId) {
        VirtualNetwork vn = this.dbService.getSingleResult(VirtualNetwork.class, "SELECT vn from virtualnetwork vn where vn.id=?1 AND vn.tenant=?2", vnId, tenant);
        if (vn == null) {
            throw new IllegalArgumentException(String.format("Unknown virtual network: tenantId=%s vnId=%s", tenant.getId(), vnId));
        }
        return vn;
    }

    public VirtualNetworkSettingsDTO saveVirtualNetwork(AuthCtx authCtx, Tenant tenant, String virtualNetworkId, VirtualNetworkSettingsDTO dto) throws UnauthorizedException {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)virtualNetworkId);
            this.cloudNetworkService.validateSettings(vn, dto);
            switch (vn.getMode()) {
                case FM_MANAGED: {
                    break;
                }
            }
            if (dto.dnsStrategy == VirtualNetwork.DNSStrategy.FM_MANAGED_CLOUD_DNS_SERVICE && dto.httpsStrategy == VirtualNetwork.HTTPSStrategy.LETSENCRYPT) {
                throw new IllegalArgumentException("Let's Encrypt cannot be used with this DNS strategy");
            }
            vn.setTenant(tenant);
            vn.setLabel(VirtualNetworksService.withDefaultVirtualNetworkLabel(authCtx, dto.label));
            vn.setDescription(dto.description);
            vn.setCloudTags(CloudTagList.toJSON(dto.cloudTags));
            vn.setAwsSecurityGroups(dto.awsSecurityGroups);
            vn.setAwsAssignPublicIP(dto.awsAssignPublicIP);
            vn.setAzureAssignPublicIP(dto.azureAssignPublicIP);
            vn.setGcpAssignPublicIP(dto.gcpAssignPublicIP);
            vn.setDnsStrategy(dto.dnsStrategy);
            vn.setContactMail(dto.contactMail);
            vn.setAwsRoute53PublicIPZoneId(com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils.stripToNull((String)dto.awsRoute53PublicIPZoneId));
            vn.setAwsRoute53PrivateIPZoneId(com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils.stripToNull((String)dto.awsRoute53PrivateIPZoneId));
            vn.setAzureVnId(dto.azureVnId);
            vn.setAzureRgName(dto.azureRgName);
            vn.setAzureSubnet(dto.azureSubnet);
            vn.setAwsSecondSubnetId(dto.awsSecondSubnetId);
            vn.setAzureSecondSubnet(dto.azureSecondSubnet);
            vn.setAzureRgNameForCreatedResources(dto.azureRgNameForCreatedResources);
            vn.setAzureRegion(dto.azureRegion);
            vn.setHttpsStrategy(dto.httpsStrategy);
            vn.setHttpStrategy(dto.httpStrategy);
            vn.setAzureDnsZoneId(dto.azureDnsZoneId);
            vn.setGcpProjectId(dto.gcpProjectId);
            vn.setGcpProjectIdForCreatedResources(dto.gcpProjectIdForCreatedResources);
            vn.setGcpNetwork(dto.gcpNetwork);
            vn.setGcpSubnetwork(dto.gcpSubnetwork);
            vn.setGcpRegion(dto.gcpRegion);
            vn.setGcpZone(dto.gcpZone);
            vn.setGcpNetworkTags(dto.gcpNetworkTags);
            vn.setGcpCloudDnsPublicIPZoneId(dto.gcpCloudDnsPublicIPZoneId);
            vn.setGcpCloudDnsPrivateIPZoneId(dto.gcpCloudDnsPrivateIPZoneId);
            vn.setManagedNodesDirectory(dto.managedNodesDirectory);
            vn.setEventServerNodeLabel(dto.eventServerNodeLabel);
            vn.setGovernServerNodeLabel(dto.governServerNodeLabel);
            vn.setNodesDirectoryDeployerMode(dto.nodesDirectoryDeployerMode);
            vn.setFMVisibleURL(dto.fmVisibleURL);
            rwt.getThreadEM().persist((Object)vn);
            rwt.commit();
            VirtualNetworkSettingsDTO virtualNetworkSettingsDTO = this.convertToDtoAndEnrich(vn, FMApp.getFMSettingsUnsafe());
            return virtualNetworkSettingsDTO;
        }
    }

    private VirtualNetworkSettingsDTO convertToDto(VirtualNetwork vn) {
        VirtualNetworkSettingsDTO dto = new VirtualNetworkSettingsDTO();
        dto.id = vn.getId();
        dto.label = vn.getLabel();
        dto.description = vn.getDescription();
        dto.cloudTags = CloudTagList.fromJSON(vn.getCloudTags());
        dto.inheritedCloudTags = vn.getInheritedCloudTags(FMApp.getFMSettingsUnsafe());
        dto.mode = vn.getMode();
        dto.managedCidr = vn.getManagedCidr();
        dto.awsVpcId = vn.getAwsVpcId();
        dto.awsRegionId = vn.getAwsRegion();
        dto.awsAvailabilityZone = vn.getAwsAvailabilityZone();
        dto.awsSubnetId = vn.getAwsSubnetId();
        dto.awsSecondSubnetId = vn.getAwsSecondSubnetId();
        dto.awsSecurityGroups = vn.getAwsSecurityGroups();
        dto.awsDefaultSecurityGroup = vn.getAwsDefaultSecurityGroup();
        dto.awsAssignPublicIP = vn.isAwsAssignPublicIP();
        dto.azureAssignPublicIP = vn.isAzureAssignPublicIP();
        dto.gcpAssignPublicIP = vn.isGcpAssignPublicIP();
        dto.managedNodesDirectory = vn.isManagedNodesDirectory();
        dto.eventServerNodeLabel = vn.getEventServerNodeLabel();
        dto.governServerNodeLabel = vn.getGovernServerNodeLabel();
        dto.nodesDirectoryDeployerMode = vn.getNodesDirectoryDeployerMode();
        dto.dnsStrategy = vn.getDnsStrategy();
        dto.contactMail = vn.getContactMail();
        dto.awsRoute53PrivateIPZoneId = vn.getAwsRoute53PrivateIPZoneId();
        dto.awsRoute53PublicIPZoneId = vn.getAwsRoute53PublicIPZoneId();
        dto.azureVnId = vn.getAzureVnId();
        dto.azureRgName = vn.getAzureRgName();
        dto.azureSubnet = vn.getAzureSubnet();
        dto.azureSecondSubnet = vn.getAzureSecondSubnet();
        dto.azureRgNameForCreatedResources = vn.getAzureRgNameForCreatedResources();
        dto.httpsStrategy = vn.getHttpsStrategy();
        dto.httpStrategy = vn.getHttpStrategy();
        dto.azureDnsZoneId = vn.getAzureDnsZoneId();
        dto.azureRegion = vn.getAzureRegion();
        dto.gcpProjectId = vn.getGcpProjectId();
        dto.gcpProjectIdForCreatedResources = vn.getGcpProjectIdForCreatedResources();
        dto.gcpNetwork = vn.getGcpNetwork();
        dto.gcpSubnetwork = vn.getGcpSubnetwork();
        dto.gcpRegion = vn.getGcpRegion();
        dto.gcpZone = vn.getGcpZone();
        dto.gcpNetworkTags = vn.getGcpNetworkTags();
        dto.gcpCloudDnsPublicIPZoneId = vn.getGcpCloudDnsPublicIPZoneId();
        dto.gcpCloudDnsPrivateIPZoneId = vn.getGcpCloudDnsPrivateIPZoneId();
        dto.fmVisibleURL = vn.getFMVisibleURL();
        return dto;
    }

    private VirtualNetworkSettingsDTO convertToDtoAndEnrich(VirtualNetwork vn, FMSettings fmSettings) {
        VirtualNetworkSettingsDTO dto = this.convertToDto(vn);
        Optional<String> peering = this.cloudNetworkService.getPeeringId(vn.getTenant().getId(), vn);
        dto.needPeering = this.cloudNetworkService.needsPeering(vn.getTenant().getId(), vn);
        dto.hasPeering = peering.isPresent();
        dto.peeringId = peering.orElse(null);
        dto.peeringState = vn.getPeeringState().name();
        dto.accountId = vn.getCloudAccountOrVirtualCloudAccount().getId();
        dto.accountLabel = vn.getCloudAccountOrVirtualCloudAccount().getLabel();
        dto.azureTenantId = vn.getCloudAccountOrVirtualCloudAccount().getAzureTenantId();
        dto.azureSubscription = vn.getCloudAccountOrVirtualCloudAccount().getAzureSubscription();
        List<LogicalInstance> instanceList = this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.virtualNetwork=?1", vn);
        dto.nbInstances = instanceList.size();
        dto.nbInstancesProvisioned = VirtualNetworksService.filterProvisioned(instanceList).size();
        List<LogicalLoadBalancer> loadBalancerList = this.dbService.listResults(LogicalLoadBalancer.class, "SELECT llb from logicalloadbalancer llb where llb.virtualNetwork=?1", vn);
        dto.nbLoadBalancers = loadBalancerList.size();
        dto.nbLoadBalancersProvisioned = loadBalancerList.stream().filter(lb -> lb.getCurrentPhysicalLoadBalancer() != null).count();
        return dto;
    }

    private static List<LogicalInstance> filterProvisioned(List<LogicalInstance> instanceList) {
        ArrayList<LogicalInstance> result = new ArrayList<LogicalInstance>();
        for (LogicalInstance li : instanceList) {
            if (li.getCurrentPhysicalInstance() == null) continue;
            result.add(li);
        }
        return result;
    }

    private static CommandResult virtualNetworkInUseError(@PrintFormat String errMsgFormat, Object ... args) {
        CommandResult result = CommandResult.withSuccess(false);
        result.statusMessages.withFatal((InfoMessage.MessageCode)FMServerCodes.ERR_VIRTUAL_NETWORK_IN_USE, String.format(errMsgFormat, args));
        return result;
    }

    private static String withDefaultVirtualNetworkLabel(AuthCtx authCtx, String label) {
        return StringUtils.isNotBlank((String)label) ? label : "Virtual network created on " + DateTimeFormat.forPattern((String)"MMM dd yyyy").print((ReadableInstant)DateTime.now()) + " by " + authCtx.getIdentifier();
    }

    private class VirtualNetworkCreationThread
    extends SimpleFMFutureThread<VirtualNetworkSettingsDTO> {
        private final ProtoVirtualNetworkDTO dto;
        final DKUtils.SmartLogTailBuilder smartLogTail;

        public VirtualNetworkCreationThread(FMAuthCtx authCtx, ProtoVirtualNetworkDTO dto) {
            super(VirtualNetworksService.this.dbService, authCtx, authCtx.getTenantId());
            this.smartLogTail = new DKUtils.SmartLogTailBuilder();
            this.dto = dto;
        }

        @Override
        protected VirtualNetworkSettingsDTO compute() throws Exception {
            this.dto.label = VirtualNetworksService.withDefaultVirtualNetworkLabel(this.owner, this.dto.label);
            VirtualNetwork vn = null;
            switch (this.dto.mode) {
                case FM_MANAGED: {
                    try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Creating managed virtual network", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                        vn = VirtualNetworksService.this.cloudNetworkService.createManagedVirtualNetwork(this.tenantId, this.dto, this.smartLogTail);
                        break;
                    }
                }
                case EXISTING_MONOTENANT: 
                case EXISTING_MULTITENANT_PUBLIC_IP: {
                    FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Creating unmanaged virtual network", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        vn = VirtualNetworksService.this.cloudNetworkService.createUnmanagedVirtualNetwork(this.tenantId, this.dto, this.smartLogTail);
                        if (globalState == null) break;
                    }
                    catch (Throwable throwable) {
                        if (globalState != null) {
                            try {
                                globalState.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    globalState.close();
                    break;
                }
            }
            return VirtualNetworksService.this.convertToDtoAndEnrich(vn, FMApp.getFMSettingsUnsafe());
        }

        public SmartLogTail getLog() {
            return this.smartLogTail.get();
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"create-virtual-network", (String)"Create virtual network");
        }
    }

    private class VirtualNetworkDeletionThread
    extends SimpleFMFutureThread<CommandResult> {
        private final String vnId;
        private final boolean deleteAutogeneratedSecurityGroups;
        private final boolean deleteAutogeneratedPeering;

        public VirtualNetworkDeletionThread(FMAuthCtx authCtx, String vnId, boolean deleteAutogeneratedSecurityGroups, boolean deleteAutogeneratedPeering) {
            super(VirtualNetworksService.this.dbService, authCtx, authCtx.getTenantId());
            this.vnId = vnId;
            this.deleteAutogeneratedSecurityGroups = deleteAutogeneratedSecurityGroups;
            this.deleteAutogeneratedPeering = deleteAutogeneratedPeering;
        }

        @Override
        protected CommandResult compute() {
            try (DatabaseAccessService.ReadWriteTransaction rwt = VirtualNetworksService.this.dbService.rwTransaction();){
                Tenant tenant = (Tenant)VirtualNetworksService.this.dbService.getThreadEM().find(Tenant.class, (Object)this.tenantId);
                VirtualNetwork vn = VirtualNetworksService.this.getVirtualNetworkMandatory(tenant, this.vnId);
                List<LogicalInstance> instanceList = VirtualNetworksService.this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.virtualNetwork=?1", vn);
                if (instanceList.size() > 0) {
                    String culpritInstance = instanceList.get(0).getLabel();
                    CommandResult commandResult = VirtualNetworksService.virtualNetworkInUseError("The instance \"%s\" is using this virtual network. Only virtual networks without any usage can be deleted.", culpritInstance);
                    return commandResult;
                }
                List<LogicalLoadBalancer> loadBalancerList = VirtualNetworksService.this.dbService.listResults(LogicalLoadBalancer.class, "SELECT llb from logicalloadbalancer llb where llb.virtualNetwork=?1", vn);
                if (loadBalancerList.size() > 0) {
                    String culpritLoadBalancer = loadBalancerList.get(0).getName();
                    CommandResult commandResult = VirtualNetworksService.virtualNetworkInUseError("The load balancer \"%s\" is using this virtual network. Only virtual networks without any usage can be deleted.", culpritLoadBalancer);
                    return commandResult;
                }
                CommandResult result = CommandResult.withSuccess(true);
                result.statusMessages.mergeFrom(VirtualNetworksService.this.cloudNetworkService.deleteVirtualNetwork(vn, this.deleteAutogeneratedPeering));
                if (this.deleteAutogeneratedSecurityGroups) {
                    result.statusMessages.mergeFrom(VirtualNetworksService.this.cloudNetworkService.deleteVirtualNetworkSecurityGroups(vn));
                }
                rwt.getThreadEM().remove((Object)vn);
                rwt.commit();
                CommandResult commandResult = result;
                return commandResult;
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"create-virtual-network", (String)"Create virtual network");
        }
    }
}

