/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.server.db.DatabaseAccessService;
import org.jetbrains.annotations.NotNull;

public class InstancesHelper {
    private static final long HEARTBEAT_TIMEOUT = 120000L;

    private InstancesHelper() {
    }

    public static LogicalInstance getInstance(DatabaseAccessService dbService, String tenantId, String instanceId) {
        return dbService.getSingleResult(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant.id = ?1 AND li.id = ?2", tenantId, instanceId);
    }

    public static PhysicalDataVolume getVolume(DatabaseAccessService dbService, LogicalInstance li) {
        return dbService.getSingleResult(PhysicalDataVolume.class, "SELECT pdv from physicaldatavolume pdv WHERE pdv.logicalInstance=?1 AND (pdv.detached = FALSE OR pdv.detached IS NULL)", li);
    }

    public static PhysicalInstance.LifecycleStage getLifeCycleStage(DatabaseAccessService dbService, String tenantId, String instanceId) {
        LogicalInstance li = InstancesHelper.getInstance(dbService, tenantId, instanceId);
        PhysicalInstance pi = InstancesHelper.getPhysicalInstance(dbService, li);
        return pi.getLifecycleStage();
    }

    public static void assertInstanceRunning(PhysicalInstance.LifecycleStage stage) {
        if (stage != PhysicalInstance.LifecycleStage.RUNNING) {
            throw new IllegalStateException("Instance is not currently running or not responding. Please wait or start it manually.");
        }
    }

    public static LogicalInstance getInstanceMandatory(DatabaseAccessService dbService, String tenantId, String instanceId) {
        LogicalInstance li = InstancesHelper.getInstance(dbService, tenantId, instanceId);
        if (li == null) {
            throw new IllegalArgumentException("Instance %s in tenant %s does not exist. It may have been deleted.".formatted(instanceId, tenantId));
        }
        return li;
    }

    public static PhysicalInstance getPhysicalInstance(DatabaseAccessService dbService, LogicalInstance li) {
        return dbService.getSingleResult(PhysicalInstance.class, "SELECT pi from physicalinstance pi where pi.logicalInstance=?1", li);
    }

    public static PhysicalInstance getPhysicalInstance(DatabaseAccessService dbService, String tenantId, String instanceId) {
        return InstancesHelper.getPhysicalInstance(dbService, InstancesHelper.getInstanceMandatory(dbService, tenantId, instanceId));
    }

    private static boolean isInTimeOut(long lastHeartbeatTimestamp) {
        return Math.max(0L, System.currentTimeMillis() - lastHeartbeatTimestamp) >= 120000L;
    }

    public static PhysicalInstance.LifecycleStage computeLifeCycleStage(PhysicalInstance instance) {
        PhysicalInstance.LifecycleStage result = instance.getLifecycleStage();
        if (result == PhysicalInstance.LifecycleStage.RUNNING && InstancesHelper.isInTimeOut(instance.getLastHeartbeatTimestamp())) {
            result = PhysicalInstance.LifecycleStage.NOT_RESPONDING;
        }
        return result;
    }

    public static boolean isLogicalInstanceInTimeout(@NotNull LogicalInstance logicalInstance) {
        return logicalInstance.getCurrentPhysicalInstance() != null && InstancesHelper.isInTimeOut(logicalInstance.getCurrentPhysicalInstance().getLastHeartbeatTimestamp());
    }
}

