/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.licensing;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.license.License;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.server.licensing.RegistrationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RegisterController
extends DIPInternalControllerBase {
    @Autowired
    private RegistrationService registerService;

    @AuditedCall(value={"msgType", "fm-install-license"})
    @RequestMapping(value={"/api/ui/install-license"})
    public void instanceLicense(HttpServletRequest req, HttpServletResponse resp, @RequestParam String license) throws Exception {
        this.registerService.installLicense((License)JSON.parse((String)this.parseLicense(license), License.class));
    }

    private String parseLicense(String input) {
        String license;
        String string = license = input == null ? "" : input.trim();
        if (license.contains("{")) {
            return license;
        }
        try {
            String l2 = new String(Base64.decodeBase64((String)license), StandardCharsets.UTF_8);
            if (l2.contains("{")) {
                return l2;
            }
            throw new IOException("");
        }
        catch (Exception e) {
            throw new ApplicativeException("Invalid license", "This does not look like a valid Fleet Manager license");
        }
    }
}

