/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.loadbalancers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.cloud.CloudDNSservice;
import com.dataiku.fm.cloud.CloudLoadBalancerService;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerLogicalStatus;
import com.dataiku.fm.model.published.LoadBalancerNodeMappingDTO;
import com.dataiku.fm.model.published.ProtoLoadBalancer;
import com.dataiku.fm.model.published.ProtoLoadBalancerNodeMapping;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.core.FMFutureResponse;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.loadbalancers.LoadBalancerCodes;
import com.dataiku.fm.utils.APIInputValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoadBalancersCRUDService {
    private static final DKULogger logger = DKULogger.getLogger((String)"fm.lb");
    private final DatabaseAccessService dbService;
    private final CloudLoadBalancerService cloudLoadBalancerService;
    private final FMFutureService futureService;
    private final InstancesCRUDService instancesCRUDService;
    private final CloudDNSservice cloudDNSservice;
    private final FMApp fmApp;

    @Autowired
    public LoadBalancersCRUDService(DatabaseAccessService dbService, CloudLoadBalancerService cloudLoadBalancerService, FMFutureService futureService, InstancesCRUDService instancesCRUDService, CloudDNSservice cloudDNSservice, FMApp fmApp) {
        this.dbService = dbService;
        this.cloudLoadBalancerService = cloudLoadBalancerService;
        this.futureService = futureService;
        this.instancesCRUDService = instancesCRUDService;
        this.cloudDNSservice = cloudDNSservice;
        this.fmApp = fmApp;
    }

    public List<LoadBalancerDTO> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        ArrayList<LoadBalancerDTO> ret = new ArrayList<LoadBalancerDTO>();
        for (LogicalLoadBalancer lb : this.dbService.listResults(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.tenant=?1", tenant)) {
            ret.add(this.convertToDTO(lb, false));
        }
        return ret;
    }

    public List<LoadBalancerDTO> list(VirtualNetwork virtualNetwork) {
        return this.listInternal(virtualNetwork).stream().map(lb -> this.convertToDTO((LogicalLoadBalancer)lb, false)).collect(Collectors.toList());
    }

    public List<LogicalLoadBalancer> listInternal(VirtualNetwork virtualNetwork) {
        return this.dbService.listResults(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.virtualNetwork=?1", virtualNetwork);
    }

    public LoadBalancerDTO create(String tenantId, ProtoLoadBalancer plb) {
        APIInputValidator.checkNotBlank(plb.name, "Load balancer name is null", new Object[0]);
        APIInputValidator.checkNotBlank(plb.virtualNetworkId, "Load balancer virtual network id is null", new Object[0]);
        APIInputValidator.checkNotNull((Object)plb.certificateMode, "Load balancer certificate mode is null", new Object[0]);
        FMSettings settings = this.fmApp.getFMSettings();
        switch (settings.cloud) {
            case AWS: {
                if (plb.certificateMode != CertificateMode.AWS_ARN) break;
                APIInputValidator.checkNotBlank(plb.awsCertificateARN, "Load balancer AWS certificate ARN is null", new Object[0]);
                break;
            }
            case AZURE: {
                APIInputValidator.checkNotNull((Object)plb.tier, "Load balancer type is null", new Object[0]);
                APIInputValidator.checkNotNull((Object)plb.publicIpMode, "Load balancer public ip mode is null", new Object[0]);
                if (plb.certificateMode == CertificateMode.AZURE_SECRET_ID) {
                    APIInputValidator.checkNotBlank(plb.azureCertificateSecretId, "Load balancer certificate secret id is null", new Object[0]);
                }
                if (plb.publicIpMode != LoadBalancerPublicIPMode.STATIC_PUBLIC_IP) break;
                APIInputValidator.checkNotBlank(plb.azurePublicIPID, "Load balancer public IP id is null", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Load balancer not supported for cloud type: " + String.valueOf((Object)settings.cloud));
            }
        }
        LogicalLoadBalancer lb = new LogicalLoadBalancer();
        lb.setId("lb-" + SecretKeyGenerator.generate((int)12));
        lb.setName(plb.name);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            plb.nodes.forEach(protoNodeMapping -> APIInputValidator.checkArgument(this.getLoadBalancer(protoNodeMapping.instanceId) == null, (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Instance '" + this.instancesCRUDService.getInternal(tenantId, protoNodeMapping.instanceId).getLabel() + "' already associated to another load balancer", new Object[0]));
            List<LogicalLoadBalancer> existingLBs = this.dbService.listResults(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.name=?1", plb.name);
            APIInputValidator.checkArgument(existingLBs.isEmpty(), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Load balancer name is already in use", new Object[0]);
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            lb.setTenant(tenant);
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)plb.virtualNetworkId);
            APIInputValidator.checkNotNull(vn, "Virtual network '" + plb.virtualNetworkId + "' doesn't exist.", new Object[0]);
            assert (vn.getTenant().getId().equals(tenant.getId()));
            lb.setVirtualNetwork(vn);
            lb.setCloudTags(CloudTagList.toJSON(plb.cloudTags));
            lb.setDescription(plb.description);
            lb.setTier(plb.tier);
            lb.setCertificateMode(plb.certificateMode);
            lb.setAwsCertificateARN(plb.awsCertificateARN);
            lb.setAzureCertificateSecretId(plb.azureCertificateSecretId);
            lb.setPublicIpMode(plb.publicIpMode);
            lb.setAzurePublicIPID(plb.azurePublicIPID);
            this.dbService.getThreadEM().persist((Object)lb);
            lb.setLoadBalancerNodeMapping(plb.nodes.stream().map(n -> this.createEntity((ProtoLoadBalancerNodeMapping)n, lb)).collect(Collectors.toSet()));
            rwt.commit();
            LoadBalancerDTO loadBalancerDTO = this.convertToDTO(lb, true);
            return loadBalancerDTO;
        }
    }

    @Nullable
    public LogicalLoadBalancer getLoadBalancer(String logicalInstanceId) {
        LoadBalancerNodeMapping mapping = this.dbService.getSingleResult(LoadBalancerNodeMapping.class, "SELECT lbm from loadbalancernodemapping lbm where lbm.logicalInstance.id = ?1", logicalInstanceId);
        if (mapping == null) {
            return null;
        }
        return mapping.getLogicalLoadBalancer();
    }

    public LoadBalancerDTO save(String tenantId, LoadBalancerDTO loadBalancerDTO) {
        APIInputValidator.checkNotBlank(loadBalancerDTO.name, "Load balancer name is null", new Object[0]);
        APIInputValidator.checkNotBlank(loadBalancerDTO.virtualNetworkId, "Load balancer virtual network id is null", new Object[0]);
        APIInputValidator.checkNotNull((Object)loadBalancerDTO.certificateMode, "Load balancer certificate mode is null", new Object[0]);
        FMSettings settings = this.fmApp.getFMSettings();
        switch (settings.cloud) {
            case AWS: {
                if (loadBalancerDTO.certificateMode != CertificateMode.AWS_ARN) break;
                APIInputValidator.checkNotBlank(loadBalancerDTO.awsCertificateARN, "Load balancer AWS certificate ARN is null", new Object[0]);
                break;
            }
            case AZURE: {
                APIInputValidator.checkNotNull((Object)loadBalancerDTO.tier, "Load balancer type is null", new Object[0]);
                APIInputValidator.checkNotNull((Object)loadBalancerDTO.publicIpMode, "Load balancer public ip mode is null", new Object[0]);
                if (loadBalancerDTO.certificateMode == CertificateMode.AZURE_SECRET_ID) {
                    APIInputValidator.checkNotBlank(loadBalancerDTO.azureCertificateSecretId, "Load balancer certificate secret id is null", new Object[0]);
                }
                if (loadBalancerDTO.publicIpMode != LoadBalancerPublicIPMode.STATIC_PUBLIC_IP) break;
                APIInputValidator.checkNotBlank(loadBalancerDTO.azurePublicIPID, "Load balancer public IP id is null", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Load balancer not supported for cloud type: " + String.valueOf((Object)settings.cloud));
            }
        }
        LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerDTO.id);
        lb.setDescription(loadBalancerDTO.description);
        Map oldLBNodeMapping = lb.getLoadBalancerNodeMapping().stream().collect(Collectors.toMap(LoadBalancerNodeMapping::getId, Function.identity()));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            loadBalancerDTO.nodes.forEach(protoNodeMapping -> {
                LogicalLoadBalancer loadBalancerAssociatedToInstance = this.getLoadBalancer(protoNodeMapping.instanceId);
                APIInputValidator.checkArgument(loadBalancerAssociatedToInstance == null || loadBalancerAssociatedToInstance.getId().equals(loadBalancerDTO.id), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Instance '" + this.instancesCRUDService.getInternal(tenantId, protoNodeMapping.instanceId).getLabel() + "' already associated to another load balancer", new Object[0]);
            });
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            lb.setTenant(tenant);
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)loadBalancerDTO.virtualNetworkId);
            APIInputValidator.checkNotNull(vn, "Virtual network '" + loadBalancerDTO.virtualNetworkId + "' doesn't exist.", new Object[0]);
            assert (vn.getTenant().getId().equals(tenant.getId()));
            lb.setVirtualNetwork(vn);
            lb.setTier(loadBalancerDTO.tier);
            lb.setCloudTags(CloudTagList.toJSON(loadBalancerDTO.cloudTags));
            HashSet<LoadBalancerNodeMapping> loadBalancerNodeMappings = new HashSet<LoadBalancerNodeMapping>();
            for (LoadBalancerNodeMappingDTO loadBalancerNodeMappingDTO : loadBalancerDTO.nodes) {
                LogicalInstance instance = InstancesHelper.getInstanceMandatory(this.dbService, lb.getTenant().getId(), loadBalancerNodeMappingDTO.instanceId);
                LoadBalancerNodeMapping loadBalancerNodeMapping = this.getLoadBalancerMapping(lb.getId(), loadBalancerNodeMappingDTO.instanceId);
                if (loadBalancerNodeMapping == null) {
                    loadBalancerNodeMapping = new LoadBalancerNodeMapping();
                    loadBalancerNodeMapping.setLogicalInstance(instance);
                    loadBalancerNodeMapping.setLogicalLoadBalancer(lb);
                    loadBalancerNodeMapping.setId("lb-node-mapping-" + SecretKeyGenerator.generate((int)12));
                } else {
                    oldLBNodeMapping.remove(loadBalancerNodeMapping.getId());
                    loadBalancerNodeMapping.setStatus(LoadBalancerNodeMapping.Status.ACTIVE);
                }
                loadBalancerNodeMapping.setSubdomainOrFQDN(loadBalancerNodeMappingDTO.hostname);
                loadBalancerNodeMappings.add(loadBalancerNodeMapping);
            }
            lb.setLoadBalancerNodeMapping(loadBalancerNodeMappings);
            lb.setCertificateMode(loadBalancerDTO.certificateMode);
            lb.setAwsCertificateARN(loadBalancerDTO.awsCertificateARN);
            lb.setAzureCertificateSecretId(loadBalancerDTO.azureCertificateSecretId);
            lb.setPublicIpMode(loadBalancerDTO.publicIpMode);
            lb.setAzurePublicIPID(loadBalancerDTO.azurePublicIPID);
            this.dbService.getThreadEM().persist((Object)lb);
            for (LoadBalancerNodeMapping loadBalancerNodeMapping : oldLBNodeMapping.values()) {
                if (this.cloudLoadBalancerService.isLoadBalancerNodeMappingProvisioned(lb, loadBalancerNodeMapping)) {
                    loadBalancerNodeMapping.setStatus(LoadBalancerNodeMapping.Status.INACTIVE);
                    this.dbService.getThreadEM().persist((Object)loadBalancerNodeMapping);
                    continue;
                }
                LogicalInstance logicalInstance = loadBalancerNodeMapping.getLogicalInstance();
                this.dbService.getThreadEM().remove((Object)loadBalancerNodeMapping);
            }
            rwt.commit();
            LoadBalancerDTO loadBalancerDTO2 = this.convertToDTO(lb, true);
            return loadBalancerDTO2;
        }
    }

    public LoadBalancerDTO get(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
        return this.convertToDTO(lb, true);
    }

    public PhysicalLoadBalancer getPhysicalLoadBalancer(LogicalLoadBalancer logicalLoadBalancer) {
        return this.dbService.getSingleResult(PhysicalLoadBalancer.class, "SELECT pi from physicalloadbalancer pi where pi.logicalLoadBalancer=?1", logicalLoadBalancer);
    }

    public LoadBalancerLogicalStatus getLogicalLoadBalancerStatus(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer loadBalancer = this.getLoadBalancerMand(tenantId, loadBalancerId);
        FMFutureResponse job = this.futureService.getUpdates().stream().filter(u -> u.sourceObjectId != null && u.sourceObjectId.equals(loadBalancerId)).sorted((u1, u2) -> Long.compare(u2.startTime, u1.startTime)).findFirst().orElse(null);
        return new LoadBalancerLogicalStatus(loadBalancer.getCurrentPhysicalLoadBalancer() != null ? LoadBalancerDTO.PhysicalStatus.PROVISIONED : LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED, job);
    }

    public void onAfterInstanceStatusUpdate(String tenantId, String instanceId) {
        LogicalInstance logicalInstance = this.instancesCRUDService.getLogicalInstanceMand(tenantId, instanceId);
        LogicalLoadBalancer loadBalancer = this.instancesCRUDService.getLoadBalancer(logicalInstance);
        if (loadBalancer == null) {
            return;
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.cloudLoadBalancerService.onInstancePhysicalStateChange(rwt, loadBalancer, logicalInstance);
            rwt.getThreadEM().persist((Object)loadBalancer);
            rwt.commit();
        }
    }

    public void deleteLoadBalancerDependencies(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance logicalInstance) {
        LogicalLoadBalancer loadBalancer = this.instancesCRUDService.getLoadBalancer(logicalInstance);
        if (loadBalancer == null) {
            return;
        }
        LoadBalancerNodeMapping nodeMapping = loadBalancer.getLoadBalancerNodeMapping().stream().filter(n -> n.getLogicalInstance().equals(logicalInstance)).findAny().orElseThrow(() -> new IllegalStateException("Node mapping does not exist although instance '" + logicalInstance.getLabel() + " ' is linked to lb '" + loadBalancer.getName() + "'"));
        loadBalancer.getLoadBalancerNodeMapping().remove(nodeMapping);
        if (this.cloudLoadBalancerService.isLoadBalancerNodeMappingProvisioned(loadBalancer, nodeMapping)) {
            this.cloudLoadBalancerService.onInstanceDeleteEvent(rwt, loadBalancer, nodeMapping, logicalInstance);
        }
        rwt.getThreadEM().remove((Object)nodeMapping);
        rwt.getThreadEM().persist((Object)loadBalancer);
        if (loadBalancer.getCurrentPhysicalLoadBalancer() != null) {
            rwt.getThreadEM().persist((Object)loadBalancer.getCurrentPhysicalLoadBalancer());
        }
    }

    private LoadBalancerDTO convertToDTO(LogicalLoadBalancer loadBalancer, boolean populateDNS) {
        LoadBalancerDTO lbdto = new LoadBalancerDTO();
        VirtualNetwork vn = loadBalancer.getVirtualNetwork();
        lbdto.id = loadBalancer.getId();
        lbdto.name = loadBalancer.getName();
        lbdto.description = loadBalancer.getDescription();
        lbdto.tier = loadBalancer.getTier();
        lbdto.virtualNetworkId = vn.getId();
        lbdto.virtualNetworkLabel = StringUtils.isBlank((String)vn.getLabel()) ? vn.getId() : vn.getLabel();
        lbdto.cloudTags = CloudTagList.fromJSON(loadBalancer.getCloudTags());
        lbdto.inheritedCloudTags = loadBalancer.getInheritedCloudTags(this.fmApp.getFMSettings());
        lbdto.nodes = loadBalancer.getLoadBalancerNodeMapping().stream().filter(m -> m.getStatus() != LoadBalancerNodeMapping.Status.INACTIVE).map(m -> new LoadBalancerNodeMappingDTO(m.getSubdomainOrFQDN(), m.getLogicalInstance().getId())).collect(Collectors.toSet());
        lbdto.certificateMode = loadBalancer.getCertificateMode();
        lbdto.awsCertificateARN = loadBalancer.getAwsCertificateARN();
        lbdto.azureCertificateSecretId = loadBalancer.getAzureCertificateSecretId();
        lbdto.publicIpMode = loadBalancer.getPublicIpMode();
        lbdto.azurePublicIPID = loadBalancer.getAzurePublicIPID();
        if (populateDNS) {
            lbdto.publicDnsZone = this.cloudDNSservice.getPublicDNSZoneDomain(vn);
            lbdto.privateDnsZone = this.cloudDNSservice.getPrivateDNSZoneDomain(vn);
        }
        return lbdto;
    }

    private LoadBalancerNodeMapping toEntity(ProtoLoadBalancerNodeMapping protoLoadBalancerNodeMapping, String id, LogicalLoadBalancer loadBalancer) {
        LoadBalancerNodeMapping loadBalancerNodeMapping = new LoadBalancerNodeMapping();
        loadBalancerNodeMapping.setLogicalLoadBalancer(loadBalancer);
        loadBalancerNodeMapping.setId(id);
        loadBalancerNodeMapping.setSubdomainOrFQDN(protoLoadBalancerNodeMapping.hostname);
        loadBalancerNodeMapping.setLogicalInstance(InstancesHelper.getInstanceMandatory(this.dbService, loadBalancer.getTenant().getId(), protoLoadBalancerNodeMapping.instanceId));
        return loadBalancerNodeMapping;
    }

    private LoadBalancerNodeMapping createEntity(ProtoLoadBalancerNodeMapping protoLoadBalancerNodeMapping, LogicalLoadBalancer loadBalancer) {
        return this.toEntity(protoLoadBalancerNodeMapping, "lb-node-mapping-" + SecretKeyGenerator.generate((int)12), loadBalancer);
    }

    public LogicalLoadBalancer getLoadBalancerMand(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer lb = this.dbService.getSingleResult(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.tenant.id = ?1 AND lb.id = ?2", tenantId, loadBalancerId);
        if (lb == null) {
            throw new IllegalStateException(String.format("Unknown or missing load balancer: %s.%s", tenantId, loadBalancerId));
        }
        lb.setCurrentPhysicalLoadBalancer(this.getPhysicalLoadBalancer(lb));
        return lb;
    }

    private LoadBalancerNodeMapping getLoadBalancerMapping(String loadBalancerId, String instanceId) {
        return this.dbService.getSingleResult(LoadBalancerNodeMapping.class, "SELECT lbm from loadbalancernodemapping lbm where lbm.logicalInstance.id = ?1 AND lbm.logicalLoadBalancer.id = ?2", instanceId, loadBalancerId);
    }

    public List<LogicalLoadBalancer> getLoadBalancersWithConflictingSubdomainOrFQDN(String loadBalancerId) {
        return this.dbService.listResults(LogicalLoadBalancer.class, "    SELECT llb FROM logicalloadbalancer llb\n        WHERE llb.id <> ?1\n        AND EXISTS (\n            SELECT 1 FROM loadbalancernodemapping lbnm1, loadbalancernodemapping lbnm2\n            WHERE lbnm1.logicalLoadBalancer.id = llb.id\n            AND lbnm2.logicalLoadBalancer.id = ?1\n            AND lbnm1.subdomainOrFQDN  = lbnm2.subdomainOrFQDN)\n", loadBalancerId);
    }

    public CommandResult deleteLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            CommandResult commandResult;
            block18: {
                Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
                assert (tenant != null);
                LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
                FutureProgress.AutocloseableFutureProgressStateWithAutoincrement deletingLBStep = FutureProgress.pushAutoCloseableState((String)"Deleting node mappings", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);
                try {
                    PhysicalLoadBalancer pi = lb.getCurrentPhysicalLoadBalancer();
                    if (pi != null) {
                        throw new IllegalStateException("Load balancer is currently provisioned. Deprovision it first to delete it.");
                    }
                    rwt.getThreadEM().remove((Object)lb);
                    rwt.commit();
                    commandResult = CommandResult.withSuccess(true);
                    if (deletingLBStep == null) break block18;
                }
                catch (Throwable pi) {
                    try {
                        if (deletingLBStep != null) {
                            try {
                                deletingLBStep.close();
                            }
                            catch (Throwable throwable) {
                                pi.addSuppressed(throwable);
                            }
                        }
                        throw pi;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not delete physical LB.", (Throwable)e);
                        logger.info((Object)("Saving current LB physical state: " + String.valueOf(lb.getCurrentPhysicalLoadBalancer())));
                        rwt.getThreadEM().persist((Object)lb);
                        rwt.commit();
                        CommandResult commandResult2 = CommandResult.withSuccess(false);
                        commandResult2.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_DELETE_ERROR, e.getMessage());
                        CommandResult commandResult3 = commandResult2;
                        if (rwt != null) {
                            rwt.close();
                        }
                        return commandResult3;
                    }
                }
                deletingLBStep.close();
            }
            return commandResult;
        }
    }
}

