/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIFMFuturesController
extends PublicAPIControllerBase {
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private FutureServiceBase futureService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.api.futures");

    private boolean canAccess(FMAuthCtx authCtx, FutureResponse<?> fr) throws UnauthorizedException, DKUSecurityException {
        return fr.tenantId != null && fr.tenantId.equals(authCtx.getTenantId());
    }

    @AuditedCall(value={"msgType", "futures-list"})
    @RequestMapping(value={"/api/public/tenants/{tenantId}/futures"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        ArrayList updates = Lists.newArrayList();
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Map allFutures = this.futureService.getAllThreads();
        for (Map.Entry running : allFutures.entrySet()) {
            FutureResponse fr = this.futureService.getProgress((String)running.getKey());
            if (fr == null || !this.canAccess(authCtx, fr)) continue;
            updates.add(fr);
        }
        Collections.sort(updates, new Comparator<FutureResponse<?>>(){

            @Override
            public int compare(FutureResponse<?> r0, FutureResponse<?> r1) {
                return -((int)(r0.startTime - r1.startTime));
            }
        });
        PublicAPIFMFuturesController.writeJSON((HttpServletResponse)resp, (Object)updates);
    }

    @AuditedCall(value={"msgType", "future-get", "futureId", "${jobId}"})
    @RequestMapping(value={"/api/public/tenants/{tenantId}/futures/{jobId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String jobId, @RequestParam(required=false, defaultValue="false") boolean peek) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        FutureResponse fr = this.futureService.getProgress(jobId);
        if (fr == null) {
            throw new IllegalArgumentException("No future by that id");
        }
        if (!this.canAccess(authCtx, fr)) {
            throw new DKUSecurityException("Insufficient rights to inspect future");
        }
        if (!peek) {
            fr = this.futureService.getUpdate(jobId);
        }
        PublicAPIFMFuturesController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @AuditedCall(value={"msgType", "future-abort", "futureId", "${jobId}"})
    @RequestMapping(value={"/api/public/tenants/{tenantId}/futures/{jobId}"}, method={RequestMethod.DELETE})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String jobId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        FutureResponse fr = this.futureService.getProgress(jobId);
        if (fr == null) {
            throw new IllegalArgumentException("No future by that id");
        }
        if (!this.canAccess(authCtx, fr)) {
            throw new DKUSecurityException("Insufficient rights to abort future");
        }
        this.futureService.abort(jobId, (AuthCtx)authCtx);
    }
}

