/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.snapshots;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.cloud.CloudInstanceService;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class SnapshotsManagementTask
implements Runnable {
    private DatabaseAccessService dbService;
    private CloudInstanceService cloudInstanceService;
    private final boolean deleteExpiredAutomaticSnapshots;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.snapshots");

    public SnapshotsManagementTask(DatabaseAccessService dbService, CloudInstanceService cloudInstanceService, Boolean deleteExpiredAutomaticSnapshots) {
        this.dbService = dbService;
        this.cloudInstanceService = cloudInstanceService;
        this.deleteExpiredAutomaticSnapshots = deleteExpiredAutomaticSnapshots == null || deleteExpiredAutomaticSnapshots != false;
    }

    @Override
    public void run() {
        try {
            this.createSnapshots();
            if (this.deleteExpiredAutomaticSnapshots) {
                this.deleteExpiredSnapshots();
            }
        }
        finally {
            this.dbService.close();
        }
    }

    private void createSnapshots() {
        logger.info((Object)"Creating scheduled snapshots");
        for (Tenant tenant : this.listTenants()) {
            for (LogicalInstance logicalinstance : this.listLogicalInstances(tenant)) {
                try {
                    if (!logicalinstance.getEnableAutomatedSnapshot()) {
                        logger.debugV("Skipping instance %s because automated snapshot is disabled", new Object[]{logicalinstance.getId()});
                        continue;
                    }
                    List<DataVolumeSnapshot> snapshots = this.listSnapshotsOldestFirst(logicalinstance);
                    DataVolumeSnapshot latestSnapshot = snapshots.isEmpty() ? null : snapshots.get(snapshots.size() - 1);
                    this.createSnapshot(logicalinstance, latestSnapshot);
                }
                catch (Exception e) {
                    logger.error((Object)("Error happened while creating  scheduled snapshot for instance '" + logicalinstance.getId() + "'."), (Throwable)e);
                }
            }
        }
    }

    private void deleteExpiredSnapshots() {
        logger.info((Object)"Deleting expired scheduled snapshots");
        for (Tenant tenant : this.listTenants()) {
            for (LogicalInstance logicalinstance : this.listLogicalInstances(tenant)) {
                int retentionCount = logicalinstance.getAutomatedSnapshotRetention();
                if (!logicalinstance.getEnableAutomatedSnapshot() || retentionCount <= 0) {
                    logger.debugV("Skipping instance %s because automated snapshot is disabled or retention count is not set.", new Object[]{logicalinstance.getId()});
                    continue;
                }
                ArrayDeque<DataVolumeSnapshot> snapshots = new ArrayDeque<DataVolumeSnapshot>(this.automaticOnly(this.listSnapshotsOldestFirst(logicalinstance)));
                logger.debugV("Found %d automatic snapshots in history / retentionCount=%d", new Object[]{snapshots.size(), retentionCount});
                while (snapshots.size() > retentionCount) {
                    DataVolumeSnapshot oldestSnapshot = (DataVolumeSnapshot)snapshots.remove();
                    try {
                        this.deleteSnapshot(oldestSnapshot, logicalinstance);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error happened while deleting scheduled snapshot '" + oldestSnapshot.getId() + "' for instance '" + logicalinstance.getId() + "'."), (Throwable)e);
                    }
                }
            }
        }
    }

    private void createSnapshot(LogicalInstance logicalInstance, DataVolumeSnapshot latestSnapshot) {
        PhysicalInstance physicalInstance = this.getPhysicalInstance(logicalInstance);
        if (physicalInstance == null) {
            logger.debugV("Skipping instance %s because it is not provisioned", new Object[]{logicalInstance.getId()});
            return;
        }
        if (latestSnapshot == null || SnapshotsManagementTask.shouldCreateDataVolumeSnapshot(logicalInstance, latestSnapshot)) {
            logger.info((Object)"Creating new automatic snapshot because the latest one is considered too old");
            DataVolumeSnapshot dvs = this.cloudInstanceService.createPhysicalDataVolumeSnapshot(logicalInstance, "automatic", "Triggered by scheduler");
            logger.infoV("Automatic snapshot created: awsId=%s, azureId=%s", new Object[]{dvs.getAwsSnapshotId(), dvs.getAzureSnapshotId()});
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                dvs.setCreationState(physicalInstance.getCreationState());
                rwt.getThreadEM().persist((Object)dvs);
                rwt.commit();
            }
        } else {
            logger.debugV("Skipping instance %s because last snapshot is recent enough", new Object[]{logicalInstance.getId()});
        }
    }

    private static boolean shouldCreateDataVolumeSnapshot(LogicalInstance logicalInstance, DataVolumeSnapshot dataVolumeSnapshots) {
        long now = System.currentTimeMillis();
        long expirationDate = now - (long)(Math.max(1, logicalInstance.getAutomatedSnapshotPeriod()) * 3600 * 1000);
        return dataVolumeSnapshots.getCreationDate() < expirationDate;
    }

    private void deleteSnapshot(DataVolumeSnapshot dataVolumeSnapshot, LogicalInstance logicalInstance) {
        logger.infoV("Deleting expired snapshot: awsId=%s, azureId=%s, creationDate=%d", new Object[]{dataVolumeSnapshot.getAwsSnapshotId(), dataVolumeSnapshot.getAzureSnapshotId(), dataVolumeSnapshot.getCreationDate()});
        this.cloudInstanceService.deletePhysicalDataVolumeSnapshot(dataVolumeSnapshot, logicalInstance);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().remove(rwt.getThreadEM().contains((Object)dataVolumeSnapshot) ? dataVolumeSnapshot : rwt.getThreadEM().merge((Object)dataVolumeSnapshot));
            rwt.commit();
        }
    }

    private List<Tenant> listTenants() {
        return this.dbService.listResults(Tenant.class, "SELECT te from tenant te", new Object[0]);
    }

    private List<LogicalInstance> listLogicalInstances(Tenant tenant) {
        return this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1", tenant);
    }

    private PhysicalInstance getPhysicalInstance(LogicalInstance logicalInstance) {
        return this.dbService.getSingleResult(PhysicalInstance.class, "SELECT pi from physicalinstance pi where pi.logicalInstance=?1", logicalInstance);
    }

    private List<DataVolumeSnapshot> automaticOnly(List<DataVolumeSnapshot> snapshots) {
        ArrayList<DataVolumeSnapshot> result = new ArrayList<DataVolumeSnapshot>();
        for (DataVolumeSnapshot snapshot : snapshots) {
            if (!"automatic".equals(snapshot.getSnapshotType())) continue;
            result.add(snapshot);
        }
        return result;
    }

    private List<DataVolumeSnapshot> listSnapshotsOldestFirst(LogicalInstance logicalinstance) {
        return this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1 order by creationDate asc", logicalinstance);
    }
}

