/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.utils;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.server.api.PublicAPICodes;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.intellij.lang.annotations.PrintFormat;

public class APIInputValidator {
    public static void checkNotNull(Object o, @PrintFormat String message, Object ... arguments) {
        APIInputValidator.checkArgument(o != null, (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    public static <T> void checkListNotEmpty(List<T> l, @PrintFormat String message, Object ... arguments) {
        APIInputValidator.checkArgument(l != null && !l.isEmpty(), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    public static void checkNotEmpty(String str, @PrintFormat String message, Object ... arguments) {
        APIInputValidator.checkArgument(StringUtils.isNotEmpty((String)str), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    public static void checkNotBlank(String str, @PrintFormat String message, Object ... arguments) {
        APIInputValidator.checkArgument(StringUtils.isNotBlank((String)str), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    public static void checkArgument(boolean expression, InfoMessage.MessageCode code, @PrintFormat String message, Object ... arguments) {
        if (!expression) {
            throw new APIIllegalArgumentException(code, String.format(message, arguments));
        }
    }

    public static void throwInvalidArgumentException(@PrintFormat String message, Object ... arguments) {
        throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, String.format(message, arguments));
    }
}

