/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.SlowCodeReporter;
import com.dataiku.dip.utils.StackUtils;
import com.google.gson.JsonObject;
import java.util.List;

public class SlowBackendCodeContext
extends SlowCodeReporter.SlowCodeContext {
    private final String txStackTrace;
    private final List<StackTraceElement> cleanStackTrace;
    private final List<StackTraceElement> simpleStackTrace;

    public static SlowBackendCodeContext capture(TransactionRef t) {
        String transactionStackTrace = t.getDebugInfo().getFormattedStackStrace();
        try {
            throw new IllegalStateException();
        }
        catch (IllegalStateException ise) {
            StackTraceElement[] stackTrace = ise.getStackTrace();
            List<StackTraceElement> cleanStackTrace = StackUtils.getStackFrom(stackTrace, "com.dataiku.dip.utils.PerfUtils", "markSlowCode", 30);
            List<StackTraceElement> simpleStackTrace = StackUtils.getShortStackForDeduplication(stackTrace, "com.dataiku.dip.utils.PerfUtils", "markSlowCode", 10);
            return new SlowBackendCodeContext(transactionStackTrace, cleanStackTrace, simpleStackTrace);
        }
    }

    private SlowBackendCodeContext(String txStackTrace, List<StackTraceElement> cleanStackTrace, List<StackTraceElement> simpleStackTrace) {
        super("slow_code_path_backend_transaction");
        this.txStackTrace = txStackTrace;
        this.cleanStackTrace = cleanStackTrace;
        this.simpleStackTrace = simpleStackTrace;
    }

    @Override
    public List<StackTraceElement> getStackTrace() {
        return this.cleanStackTrace;
    }

    @Override
    public List<StackTraceElement> getSimpleStackTrace() {
        return this.simpleStackTrace;
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("stackTrace", StackUtils.getStringStack(this.cleanStackTrace));
        json.addProperty("transactionStartingThreadStackTrace", this.txStackTrace);
        return json;
    }
}

