/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils.copy;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.copy.CopyMethod;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class StreamCopyMethod
implements CopyMethod {
    private final byte[] buffer;
    private final FSUtils.CopyStats stats = new FSUtils.CopyStats();

    public StreamCopyMethod(int bufferSize) {
        this.buffer = new byte[bufferSize];
    }

    public StreamCopyMethod() {
        this(65536);
    }

    @Override
    public void copyFile(ReadOnlyFS srcFS, RelFile srcFile, @Nullable RelFileAttribute srcAttr, ReadWriteFS dstFS, RelFile dstFile, @Nullable RelFileAttribute dstAttr) throws IOException {
        try (RelFileInputStream in = srcFS.readStream(srcFile);
             RelFileOutputStream out = dstFS.writeStreamNoMkdir(dstFile);){
            IOUtils.copyLarge((InputStream)((Object)in), (OutputStream)((Object)out), (byte[])this.buffer);
            ++this.stats.nbFilesCopied;
        }
        catch (Exception e) {
            throw new IOException("Error while copying \"" + String.valueOf(srcFile) + "\" to \"" + String.valueOf(dstFile) + "\" (" + e.getMessage() + ")", e);
        }
    }

    @Override
    public FSUtils.CopyStats getStats() {
        return this.stats;
    }

    @Override
    public void close() {
    }
}

