/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.util.SecretKeyGenerator;
import org.apache.commons.codec.digest.DigestUtils;

public class HashUtils {
    public static final String ALGORITHM_PREFIX = "sha256:";

    public static String sha256WithSalt(String unhashedValue) {
        if (unhashedValue == null) {
            throw new IllegalArgumentException("Cannot hash null value");
        }
        String salt = SecretKeyGenerator.generate(8);
        String valuePlusSalt = HashUtils.addSalt(unhashedValue, salt);
        return ALGORITHM_PREFIX + salt + ":" + DigestUtils.sha256Hex((String)valuePlusSalt);
    }

    public static boolean verifySha256(String unhashedValue, String hashedValue) {
        if (unhashedValue == null || hashedValue == null) {
            return false;
        }
        if (!hashedValue.startsWith(ALGORITHM_PREFIX)) {
            return false;
        }
        String[] parts = hashedValue.split(":");
        if (parts.length == 3) {
            String salt = parts[1];
            String hashToCompare = parts[2];
            return hashToCompare.equals(DigestUtils.sha256Hex((String)HashUtils.addSalt(unhashedValue, salt)));
        }
        throw new IllegalArgumentException("Can't compare hashes, invalid hashed format");
    }

    private static String addSalt(String value, String salt) {
        return value + salt;
    }
}

