(function() {
    'use strict';

    const app = angular.module('dataiku.fm.users', ['dataiku.services', 'dataiku.filters', "dataiku.fm.dialogs"]);

    app.controller('UsersListController', function($scope, $state, $location, FMAPI, Dialogs) {
        let refreshList = function() {
            FMAPI.users.list().success(function(data) {
                $scope.users = data;
            }).error(setErrorInScope.bind($scope));
        };

        $scope.deleteUser = function(user) {
            Dialogs.confirmInfoMessages($scope, 'Confirm user deletion', null, 'Are you sure you want to delete user ' + sanitize(user.emailAddress) + '?', false).then(function() {
                FMAPI.users.delete(user.emailAddress)
                    .success(refreshList)
                    .error(setErrorInScope.bind($scope));
            });
        };

        refreshList();
    });

    app.controller("UsersCreationController", function($scope, $state, FMAPI, Logger, ActivityIndicator) {
        $scope.user = {};
        
        $scope.createUser = function() {
            FMAPI.users.create($scope.user).success(function() {
                ActivityIndicator.success("User created");
                $state.go("users.list");
            }).error(setErrorInScope.bind($scope));
        };

        $scope.$watch("user", function(nv) {
            $scope.editionState.duplicateUser = nv && nv.emailAddress
                && $scope.users && !!$scope.users.find(u => u.emailAddress === nv.emailAddress);
        }, true);

        // Define scope variables
        $scope.editionState = {
            duplicateUser: false
        };

        // Retrieve list of all users to verify that we are not trying to create a user that already exist.
        FMAPI.users.list().success(function(data) {
            $scope.users = data;
        }).error(setErrorInScope.bind($scope));
    });

    app.controller("UsersEditController", function($scope, $state, $stateParams, FMAPI, Logger, ActivityIndicator) {
        $scope.saveUser = function() {
            FMAPI.users.save($scope.user.emailAddress, $scope.editedUser).success(function() {
                // Update info of currently logged user if it has changed.
                if ($scope.user.emailAddress === $scope.appConfig.login) {
                    $scope.appConfig.login = $scope.editedUser.emailAddress;
                    $scope.appConfig.user.emailAddress = $scope.editedUser.emailAddress;
                    $scope.appConfig.user.displayName = $scope.editedUser.displayName;
                }
                // eslint-disable-next-line no-undef
                $scope.user = dkuDeepCopy($scope.editedUser, filterDollarKey);
                ActivityIndicator.success("User details updated");
                $state.go("users.list");
            }).error(setErrorInScope.bind($scope));
        };

        $scope.$watch("editedUser", function(nv) {
            $scope.editionState.duplicateUser = nv && nv.emailAddress && nv.emailAddress !== $scope.user.emailAddress
                && $scope.users && !!$scope.users.find(u => u.emailAddress === nv.emailAddress);

            if (nv) {
                if (nv.password || nv.confirmPassword) {
                    // If user is trying to change its password, consider it as dirty
                    $scope.editionState.dirty = true;
                } else {
                    // Else check whether the other properties have changed
                    const newUser = dkuDeepCopy(nv, key => key !== "confirmPassword" && key !== "password");
                    $scope.editionState.dirty = !angular.equals(newUser, $scope.user);
                }
            }
        }, true);

        // Define scope variables
        $scope.editionState = {
            duplicateUser: false,
            dirty: false
        };

        FMAPI.users.get($stateParams.emailAddress).success(function(user) {
            $scope.user = user;
            // eslint-disable-next-line no-undef
            $scope.editedUser = dkuDeepCopy($scope.user, filterDollarKey);
        }).error(setErrorInScope.bind($scope));

        // Retrieve list of all users to verify that we are not trying to create a user that already exist.
        FMAPI.users.list().success(function(data) {
            $scope.users = data;
        }).error(setErrorInScope.bind($scope));
    });

}());
