(function() {
    "use strict";

    angular.module("dataiku.addDatasetWorkflow").factory("AddDatasetWorkflowService", AddDatasetWorkflowService)

    function AddDatasetWorkflowService(CreateModalFromTemplate, GlobalProjectActions, DataikuAPI) {
        const pinnedItems = [];
        let datasetsMenus = [];

       function openAddDatasetModal(flowScope) {
           CreateModalFromTemplate("/static/dataiku/add-dataset-workflow/add-dataset-modal/add-dataset-modal.html", flowScope, null, function(modalScope, element) {
               modalScope.flowScope = flowScope;
               modalScope.initModal(element, flowScope);
           });
       }


        function getMenuData(flowScope) {
            const flowOthersItems = GlobalProjectActions.getFlowOtherItemsBySection(flowScope);
            const recipesMenus = GlobalProjectActions.getAllRecipesBySection(flowScope);

            return GlobalProjectActions.getAllDatasetsBySection(flowScope).then(items => {
                datasetsMenus = items;
                return {
                    flowOthersItems,
                    recipesMenus,
                    datasetsMenus: items
                };
           })
       }

        function togglePinItem(item, $scope) {
            return DataikuAPI.profile.togglePinnedConnectionType(item).then(items => {
                pinnedItems.length = 0;
                pinnedItems.push(...mapPinnedNestedItems(items.data))
            }).catch(setErrorInScope.bind($scope))
        }

        function getPinnedItems($scope) {
            return DataikuAPI.profile.getPinnedConnectionTypes().then(items => {
                pinnedItems.length = 0;
                pinnedItems.push(...mapPinnedNestedItems(items.data))
            }).catch(setErrorInScope.bind($scope))
       }

        function mapPinnedNestedItems(items) {
            return items.map(pinnedItem => {
                const foundDataset = datasetsMenus.find(dataset => {
                    if (dataset.isSection) {
                        return dataset.items.find(item => item.type === pinnedItem)
                    }
                    return dataset.type === pinnedItem;
                })
                if (foundDataset?.isSection) {
                    return foundDataset.items.find(item => item.type === pinnedItem)
                }
                return foundDataset
            }).filter(Boolean)
        }

       return {
           openAddDatasetModal,
           getMenuData,
           togglePinItem,
           getPinnedItems,
           pinnedItems
       }
    }
})();