(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('BinnedXYChartDefController', function($scope, ChartTypeChangeHandler, CHART_VARIANTS) {
        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };
        $scope.acceptDimension = function(data) {
            return ChartTypeChangeHandler.binnedXYAcceptDimension($scope.chart.def, data);
        };
        $scope.hasSizeMenu = function() {
            return $scope.chart.def.variant === CHART_VARIANTS.binnedXYHexagon;
        };
    });
})();
