import sys
import dataikuapi
from .auth import get_or_create_api_key
import argparse
import os
import logging


node_type = os.environ.get("DKU_NODE_TYPE", "design")


######################
# Commands definition
######################

parser = argparse.ArgumentParser(description="Manage the local DSS Node (Design or Automation)")
subparsers = parser.add_subparsers(help="command to execute")

####### API services

from . import security_commands

security_commands.declare_users_list(subparsers)
security_commands.declare_user_create(subparsers)
security_commands.declare_user_edit(subparsers)
security_commands.declare_user_delete(subparsers)
security_commands.declare_api_keys_list(subparsers)
security_commands.declare_api_key_create(subparsers)
security_commands.declare_api_key_edit(subparsers)
security_commands.declare_api_key_delete(subparsers)
security_commands.declare_invalidate_conf_cache(subparsers)
security_commands.declare_set_license(subparsers)

from . import groups_commands

####### Groups

groups_commands.declare_groups_list(subparsers)
groups_commands.declare_group_create(subparsers)
groups_commands.declare_group_edit(subparsers)
groups_commands.declare_group_delete(subparsers)

from . import connections_commands

####### Connections

connections_commands.declare_connections_list(subparsers)


from . import codeenvs_commands

####### Code envs

codeenvs_commands.declare_codeenvs_list(subparsers)
codeenvs_commands.declare_codeenv_update(subparsers)
codeenvs_commands.declare_codeenv_rebuild_images(subparsers)


from . import containers_commands

####### Containers

containers_commands.declare_push_base_images(subparsers)


from . import projects_commands

####### Projects

projects_commands.declare_projects_list(subparsers)
projects_commands.declare_project_export(subparsers)
projects_commands.declare_project_import(subparsers)
projects_commands.declare_project_delete(subparsers)


from . import managed_folders_commands

####### Managed Folders

managed_folders_commands.declare_managed_folders_list(subparsers)
managed_folders_commands.declare_managed_folder_list_contents(subparsers)
managed_folders_commands.declare_managed_folder_get_file(subparsers)

####### Bundles

if node_type == "design":
    projects_commands.declare_bundles_list_exported(subparsers)
    projects_commands.declare_bundle_export(subparsers)
    projects_commands.declare_bundle_download_archive(subparsers)

elif node_type == "automation":
    projects_commands.declare_bundles_list_imported(subparsers)
    projects_commands.declare_bundle_import(subparsers)
    projects_commands.declare_bundle_activate(subparsers)
    projects_commands.declare_bundle_delete(subparsers)
    projects_commands.declare_project_create_from_bundle(subparsers)

####### Jobs

from . import jobs_commands

jobs_commands.declare_jobs_list(subparsers)
jobs_commands.declare_build(subparsers)
jobs_commands.declare_job_abort(subparsers)
jobs_commands.declare_job_status(subparsers)

####### Scenarios

from . import scenarios_commands

scenarios_commands.declare_scenarios_list(subparsers)
scenarios_commands.declare_scenario_runs_list(subparsers)
scenarios_commands.declare_scenario_run(subparsers)
scenarios_commands.declare_scenario_abort(subparsers)

####### Datasets

from . import datasets_commands

datasets_commands.declare_datasets_list(subparsers)
datasets_commands.declare_dataset_schema_dump(subparsers)
datasets_commands.declare_dataset_list_partitions(subparsers)
datasets_commands.declare_dataset_clear(subparsers)
datasets_commands.declare_dataset_delete(subparsers)

####### API services

from . import apiservices_commands

apiservices_commands.declare_api_services_list(subparsers)
apiservices_commands.declare_api_service_package_create(subparsers)

####### Code Studio templates services

from . import code_studio_templates_commands

code_studio_templates_commands.declare_code_studio_templates_list(subparsers)
code_studio_templates_commands.declare_code_studio_templates_build(subparsers)

######################
# Main
######################

logging.basicConfig(level=logging.INFO, format='[%(asctime)s] [%(levelname)s] [%(name)s] %(message)s')

args = parser.parse_args()
# Python 3.6 argument parser does not exit if subcommand is missing?
if "func" not in args:
    print("Missing subcommand, use -h for help")
    sys.exit(1)

# Init connection
user = args.impersonate_user if "impersonate_user" in args else ""
key = get_or_create_api_key(impersonate_user=user)
port = int(os.environ["DKU_BACKEND_PORT"])
client = dataikuapi.DSSClient("http://127.0.0.1:%s" % port, key)

# Call subcommand

args.func(args, client)
