/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;

public class PkDrivenByDefaultMapsIdSecondPass
extends FkSecondPass {
    private final String referencedEntityName;
    private final AnnotatedJoinColumns columns;
    private final SimpleValue value;

    public PkDrivenByDefaultMapsIdSecondPass(String referencedEntityName, AnnotatedJoinColumns columns, SimpleValue value) {
        super(value, columns);
        this.referencedEntityName = referencedEntityName;
        this.columns = columns;
        this.value = value;
    }

    @Override
    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public boolean isInPrimaryKey() {
        return true;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        PersistentClass referencedEntity = persistentClasses.get(this.referencedEntityName);
        if (referencedEntity == null) {
            throw new AnnotationException("Unknown entity name '" + this.referencedEntityName + "'");
        }
        TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(referencedEntity, referencedEntity.getKey(), this.columns, this.value);
    }
}

