/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomaton;

import com.BoxOfC.LevenshteinAutomaton.AugBitSet;
import com.BoxOfC.LevenshteinAutomaton.State;
import java.util.Arrays;
import java.util.HashSet;

public class Position
implements Comparable<Position> {
    private final int I;
    private final int E;
    private final boolean T;
    private static final ElementaryTransitionTerm[] MATCH_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.MATCH};
    private static final ElementaryTransitionTerm[] INSERTION_PRETRANSPOSITION_SUBSTITUTION_DELETION_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.INSERTION, ElementaryTransitionTerm.PRETRANSPOSITION, ElementaryTransitionTerm.SUBSTITUTION, ElementaryTransitionTerm.DELETION};
    private static final ElementaryTransitionTerm[] INSERTION_SUBSTITUTION_DELETION_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.INSERTION, ElementaryTransitionTerm.SUBSTITUTION, ElementaryTransitionTerm.DELETION};
    private static final ElementaryTransitionTerm[] INSERTION_SUBSTITUTION_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.INSERTION, ElementaryTransitionTerm.SUBSTITUTION};
    private static final ElementaryTransitionTerm[] TRANSPOSITION_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.TRANSPOSITION};
    private static final ElementaryTransitionTerm[] INSERTION_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.INSERTION};
    private static final ElementaryTransitionTerm[] FAILURE_TRANSITION = new ElementaryTransitionTerm[]{ElementaryTransitionTerm.FAILURE};

    public Position(int I, int E, boolean T) {
        this.I = I;
        this.E = E;
        this.T = T;
    }

    public int getI() {
        return this.I;
    }

    public int getE() {
        return this.E;
    }

    public boolean getT() {
        return this.T;
    }

    public ElementaryTransitionTerm[] procureTransition(EditDistanceRelationType edRelationType, StateRelevantSubwordSizeType sRSSizeType, PositionType pType, RelevantSubwordHitIndexType rsHitIndexType) {
        switch (edRelationType) {
            case AT_ZERO_AND_NOT_AT_MAX: {
                switch (sRSSizeType) {
                    case ATLEAST_TWO: {
                        switch (rsHitIndexType) {
                            case FIRST_INDEX: {
                                return MATCH_TRANSITION;
                            }
                            case SECOND_INDEX: {
                                return INSERTION_PRETRANSPOSITION_SUBSTITUTION_DELETION_TRANSITION;
                            }
                            case TRAILING_INDEX: {
                                return INSERTION_SUBSTITUTION_DELETION_TRANSITION;
                            }
                        }
                        return INSERTION_SUBSTITUTION_TRANSITION;
                    }
                    case ONE: {
                        switch (rsHitIndexType) {
                            case FIRST_INDEX: {
                                return MATCH_TRANSITION;
                            }
                        }
                        return INSERTION_SUBSTITUTION_TRANSITION;
                    }
                }
                return INSERTION_TRANSITION;
            }
            case NOT_AT_ZERO_AND_NOT_AT_MAX: {
                switch (sRSSizeType) {
                    case ATLEAST_TWO: {
                        switch (pType) {
                            case STANDARD_POSITION: {
                                switch (rsHitIndexType) {
                                    case FIRST_INDEX: {
                                        return MATCH_TRANSITION;
                                    }
                                    case SECOND_INDEX: {
                                        return INSERTION_PRETRANSPOSITION_SUBSTITUTION_DELETION_TRANSITION;
                                    }
                                    case TRAILING_INDEX: {
                                        return INSERTION_SUBSTITUTION_DELETION_TRANSITION;
                                    }
                                }
                                return INSERTION_SUBSTITUTION_TRANSITION;
                            }
                        }
                        switch (rsHitIndexType) {
                            case FIRST_INDEX: {
                                return TRANSPOSITION_TRANSITION;
                            }
                        }
                        return FAILURE_TRANSITION;
                    }
                    case ONE: {
                        switch (rsHitIndexType) {
                            case FIRST_INDEX: {
                                return MATCH_TRANSITION;
                            }
                        }
                        return INSERTION_SUBSTITUTION_TRANSITION;
                    }
                }
                return INSERTION_TRANSITION;
            }
        }
        switch (sRSSizeType) {
            case ZERO: {
                return FAILURE_TRANSITION;
            }
        }
        switch (pType) {
            case STANDARD_POSITION: {
                switch (rsHitIndexType) {
                    case FIRST_INDEX: {
                        return MATCH_TRANSITION;
                    }
                }
                return FAILURE_TRANSITION;
            }
        }
        switch (rsHitIndexType) {
            case FIRST_INDEX: {
                return TRANSPOSITION_TRANSITION;
            }
        }
        return FAILURE_TRANSITION;
    }

    public State transitionInternal(int maxEditDistance, int relevantSubwordSize, int hitIndex) {
        RelevantSubwordHitIndexType rsHitIndexType;
        EditDistanceRelationType edRelationType;
        EditDistanceRelationType editDistanceRelationType = this.E < maxEditDistance ? (this.E == 0 ? EditDistanceRelationType.AT_ZERO_AND_NOT_AT_MAX : EditDistanceRelationType.NOT_AT_ZERO_AND_NOT_AT_MAX) : (edRelationType = EditDistanceRelationType.AT_MAX);
        StateRelevantSubwordSizeType stateRSSizeType = relevantSubwordSize >= 2 ? StateRelevantSubwordSizeType.ATLEAST_TWO : (relevantSubwordSize == 1 ? StateRelevantSubwordSizeType.ONE : StateRelevantSubwordSizeType.ZERO);
        PositionType pType = this.T ? PositionType.TRANSPOSITION_POSITION : PositionType.STANDARD_POSITION;
        switch (hitIndex) {
            case -1: {
                rsHitIndexType = RelevantSubwordHitIndexType.NO_INDEX;
                break;
            }
            case 0: {
                rsHitIndexType = RelevantSubwordHitIndexType.FIRST_INDEX;
                break;
            }
            case 1: {
                rsHitIndexType = RelevantSubwordHitIndexType.SECOND_INDEX;
                break;
            }
            default: {
                rsHitIndexType = RelevantSubwordHitIndexType.TRAILING_INDEX;
            }
        }
        ElementaryTransitionTerm[] elementaryTransition = this.procureTransition(edRelationType, stateRSSizeType, pType, rsHitIndexType);
        HashSet<Position> possibleNewPositionHashSet = new HashSet<Position>();
        for (ElementaryTransitionTerm currentTerm : elementaryTransition) {
            Position transitionPosition = currentTerm.execute(this, hitIndex);
            if (transitionPosition == null) continue;
            possibleNewPositionHashSet.add(transitionPosition);
        }
        if (!possibleNewPositionHashSet.isEmpty()) {
            Object[] positionArray = possibleNewPositionHashSet.toArray(new Position[possibleNewPositionHashSet.size()]);
            Arrays.sort(positionArray);
            return new State((Position[])positionArray);
        }
        return null;
    }

    public int[] procurePositionTransitionData(int maxEditDistance, int relevantSubwordStartIndex, AugBitSet parentStateRelevantSubwordCharacteristicVector) {
        int firstHitIndex;
        int relevantSubwordSize;
        if (relevantSubwordStartIndex < parentStateRelevantSubwordCharacteristicVector.getRelevantBitSetSize()) {
            relevantSubwordSize = Math.min(maxEditDistance - this.E + 1, parentStateRelevantSubwordCharacteristicVector.getRelevantBitSetSize() - relevantSubwordStartIndex);
            AugBitSet relevantSubwordCharacteristicVector = parentStateRelevantSubwordCharacteristicVector.get(relevantSubwordStartIndex, relevantSubwordStartIndex + relevantSubwordSize);
            firstHitIndex = relevantSubwordCharacteristicVector.nextSetBit(0);
        } else {
            relevantSubwordSize = 0;
            firstHitIndex = -1;
        }
        return new int[]{relevantSubwordSize, firstHitIndex};
    }

    public State transition(int maxEditDistance, int parentStateRelevantSubwordLocationIndex, AugBitSet parentStateRelevantSubwordCharacteristicVector) {
        int[] positionTransitionDataArray = this.procurePositionTransitionData(maxEditDistance, parentStateRelevantSubwordLocationIndex, parentStateRelevantSubwordCharacteristicVector);
        return this.transitionInternal(maxEditDistance, positionTransitionDataArray[0], positionTransitionDataArray[1]);
    }

    public boolean subsumes(Position p, int maxEditDistance) {
        if (this.T) {
            if (p.T) {
                return this.E < p.E && this.I == p.I;
            }
            return p.E == maxEditDistance && p.E > this.E && this.I == p.I;
        }
        if (p.T) {
            return this.E < p.E && Math.abs(p.I - (this.I - 1)) <= p.E - this.E;
        }
        return this.E < p.E && Math.abs(p.I - this.I) <= p.E - this.E;
    }

    @Override
    public int compareTo(Position p2) {
        if (this.I == p2.I) {
            int eComparisonResultInt = Integer.compare(this.E, p2.E);
            return eComparisonResultInt == 0 ? Boolean.compare(this.T, p2.T) : eComparisonResultInt;
        }
        if (this.I < p2.I) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        boolean areEqual;
        boolean bl = areEqual = this == obj;
        if (!areEqual && obj != null && obj.getClass().equals(Position.class)) {
            Position ps = (Position)obj;
            areEqual = this.I == ps.I && this.E == ps.E && this.T == ps.T;
        }
        return areEqual;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + this.I;
        hash = 13 * hash + this.E;
        hash = 13 * hash + (this.T ? 1 : 0);
        return hash;
    }

    public String toString() {
        return this.I + (this.T ? "(t)" : "") + "(#" + this.E + ")";
    }

    private static enum ElementaryTransitionTerm {
        MATCH(1, 0, false),
        INSERTION(0, 1, false),
        PRETRANSPOSITION(0, 1, true),
        TRANSPOSITION(2, 0, false),
        SUBSTITUTION(1, 1, false),
        DELETION(0, 0, false),
        FAILURE(0, 0, false);

        private final int I_OFFSET;
        private final int E_OFFSET;
        private final boolean REPRESENTS_PRETRANSPOSITION;

        private ElementaryTransitionTerm(int iOffset, int eOffset, boolean representsTransposition) {
            this.I_OFFSET = iOffset;
            this.E_OFFSET = eOffset;
            this.REPRESENTS_PRETRANSPOSITION = representsTransposition;
        }

        public Position execute(Position p, int hitIndex) {
            if (!this.equals((Object)FAILURE)) {
                int newI = p.getI() + (this.equals((Object)DELETION) ? hitIndex + 1 : this.I_OFFSET);
                int newE = p.getE() + (this.equals((Object)DELETION) ? hitIndex + 1 - 1 : this.E_OFFSET);
                return new Position(newI, newE, this.REPRESENTS_PRETRANSPOSITION);
            }
            return null;
        }
    }

    private static enum RelevantSubwordHitIndexType {
        FIRST_INDEX,
        SECOND_INDEX,
        TRAILING_INDEX,
        NO_INDEX;

    }

    private static enum PositionType {
        STANDARD_POSITION,
        TRANSPOSITION_POSITION;

    }

    private static enum StateRelevantSubwordSizeType {
        ATLEAST_TWO,
        ONE,
        ZERO;

    }

    private static enum EditDistanceRelationType {
        AT_MAX,
        NOT_AT_ZERO_AND_NOT_AT_MAX,
        AT_ZERO_AND_NOT_AT_MAX;

    }
}

