/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomatonTest;

import com.BoxOfC.MDAG.MDAG;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class LevenshteinAutomatonTest {
    ArrayList<String> wordArrayList = new ArrayList();
    MDAG mdag = null;
    int maxEditDistanceToTest = 2;

    @BeforeClass
    public void initializer() throws IOException {
        String currentWord;
        BufferedReader breader = new BufferedReader(new FileReader(new File("C:\\Users\\Kevin\\Documents\\NetBeansProjects\\MDAGTest\\words.txt")));
        while ((currentWord = breader.readLine()) != null) {
            this.wordArrayList.add(currentWord);
        }
        this.mdag = new MDAG(this.wordArrayList);
    }

    public static int computeEditDistance(String str1, String str2) {
        int i;
        int str1Length = str1.length();
        int str2Length = str2.length();
        if (str1.equals(str2)) {
            return 0;
        }
        if (str1Length == 0) {
            return str2.length();
        }
        if (str2Length == 0) {
            return str1.length();
        }
        int[] ancestorMatrixCol = new int[str2Length + 1];
        int[] previousMatrixCol = new int[str2Length + 1];
        int[] currentMatrixCol = new int[str2Length + 1];
        for (i = 0; i < previousMatrixCol.length; ++i) {
            previousMatrixCol[i] = i;
        }
        for (i = 0; i < str1Length; ++i) {
            int j;
            currentMatrixCol[0] = i + 1;
            for (j = 0; j < str2Length; ++j) {
                int deletionCost = currentMatrixCol[j] + 1;
                int insertionCost = previousMatrixCol[j + 1] + 1;
                int curCharEditDistance = str1.charAt(i) == str2.charAt(j) ? 0 : 1;
                int substitutionCost = previousMatrixCol[j] + curCharEditDistance;
                int minEditOperationCost = Math.min(deletionCost, insertionCost);
                minEditOperationCost = Math.min(minEditOperationCost, substitutionCost);
                if (i > 0 && j > 0 && str1.charAt(i) == str2.charAt(j - 1) && str1.charAt(i - 1) == str2.charAt(j)) {
                    minEditOperationCost = Math.min(minEditOperationCost, ancestorMatrixCol[j - 1] + curCharEditDistance);
                }
                currentMatrixCol[j + 1] = minEditOperationCost;
            }
            for (j = 0; j < previousMatrixCol.length; ++j) {
                ancestorMatrixCol[j] = previousMatrixCol[j];
                previousMatrixCol[j] = currentMatrixCol[j];
            }
        }
        return currentMatrixCol[str2Length];
    }

    @DataProvider(name="automatonWordDataProvider")
    public Object[][] automatonWordDataProvider() {
        int testCount = 15;
        Object[][] argArrayContainerArray = new Object[testCount][];
        int wordCount = this.wordArrayList.size();
        for (int i = 0; i < testCount; ++i) {
            int randomMaxEditDistance = (int)(Math.random() * (double)this.maxEditDistanceToTest) + 1;
            int randomIndex = (int)(Math.random() * (double)wordCount);
            argArrayContainerArray[i] = new Object[]{randomMaxEditDistance, this.wordArrayList.get(randomIndex)};
        }
        return argArrayContainerArray;
    }
}

