/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exceptions;

import com.dataiku.dip.exceptions.PivotMissingContext;

public class PivotMissingColumnException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    public final String code = "MISSING_COLUMN";
    public final String title = "Unable to build chart";
    public String invalidColumnName;
    public PivotMissingContext pivotMissingContext;

    public PivotMissingColumnException(String invalidColumnName) {
        super(String.format("Column %s does not exist", invalidColumnName));
        this.invalidColumnName = invalidColumnName;
    }

    public PivotMissingColumnException(String invalidColumnName, PivotMissingContext pivotMissingContext) {
        super(String.format("Column %s does not exist", invalidColumnName) + PivotMissingColumnException.getMessageForMissingContext(pivotMissingContext));
        this.invalidColumnName = invalidColumnName;
        this.pivotMissingContext = pivotMissingContext;
    }

    private static String getMessageForMissingContext(PivotMissingContext pivotMissingContext) {
        String baseMessage = " (used %s)";
        if (pivotMissingContext == PivotMissingContext.FILTERS) {
            return String.format(baseMessage, "in filters");
        }
        if (pivotMissingContext == PivotMissingContext.BREAK_DOWN) {
            return String.format(baseMessage, "to break down");
        }
        return "";
    }
}

