/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleList
implements Iterable<Double> {
    private transient double[] data;
    private int size;

    public DoubleList(int initialCapacity) {
        this.data = new double[initialCapacity];
    }

    public DoubleList() {
        this(10);
    }

    public DoubleList(DoubleList other) {
        this.size = other.size();
        this.data = new double[other.capacity()];
        System.arraycopy(other.getAllData(), 0, this.data, 0, other.capacity());
    }

    protected double[] getAllData() {
        return this.data;
    }

    public double[] getValidDataCopy() {
        double[] newData = new double[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    public double get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
        return this.data[index];
    }

    public double getUnsafe(int index) {
        return this.data[index];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int capacity() {
        return this.data.length;
    }

    public void setSize(int newSize) {
        if (newSize > this.capacity()) {
            throw new IndexOutOfBoundsException("Trying to set size to " + newSize + " but capacity only " + this.capacity());
        }
        this.size = newSize;
    }

    public double set(int index, double element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
        double previous = this.data[index];
        this.data[index] = element;
        return previous;
    }

    public void add(double o) {
        if (this.size >= this.data.length) {
            this.grow(this.size + 1);
        }
        this.data[this.size++] = o;
    }

    public void grow(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new double[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public void growExact(int capacity) {
        int oldCapacity = this.data.length;
        if (oldCapacity >= capacity) {
            return;
        }
        double[] oldData = this.data;
        this.data = new double[capacity];
        System.arraycopy(oldData, 0, this.data, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                return this.nextIndex < DoubleList.this.size();
            }

            @Override
            public Double next() {
                if (this.nextIndex >= DoubleList.this.size()) {
                    throw new NoSuchElementException();
                }
                return DoubleList.this.data[this.nextIndex++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported on DoubleList.");
            }
        };
    }
}

