/*
 * Decompiled with CFR 0.152.
 */
package net.sf.spnego;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.logging.Logger;

public class UserHttpSessionFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(UserHttpSessionFilter.class.getName());
    private String httpSessAttribName = "spnegoAuthNuser";

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("UserHttpSessionFilter::init");
        String tmp = filterConfig.getInitParameter("http.sess.attib.name");
        if (null != tmp && !tmp.isBlank()) {
            this.httpSessAttribName = tmp;
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String spnegoAuthNuser;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String remoteUser = httpRequest.getRemoteUser();
        HttpSession httpSession = httpRequest.getSession(false);
        if (null != remoteUser && !remoteUser.isBlank()) {
            spnegoAuthNuser = this.getSpnegoAuthNuser(remoteUser);
            if (null != httpSession) {
                LOGGER.fine("UserHttpSessionFilter::doFilter: has httpSession");
                httpRequest.getSession().setAttribute(this.httpSessAttribName, (Object)spnegoAuthNuser);
            } else {
                LOGGER.fine("UserHttpSessionFilter::doFilter: no httpSession");
            }
        } else if (null != httpSession && null != httpSession.getAttribute(this.httpSessAttribName)) {
            LOGGER.fine("UserHttpSessionFilter::doFilter: httpSession=" + httpSession);
            spnegoAuthNuser = (String)httpSession.getAttribute("spnegoAuthNuser");
            LOGGER.fine("UserHttpSessionFilter::doFilter: spnegoAuthNuser=" + spnegoAuthNuser);
        } else {
            throw new ServletException("Could not identify logged-in user: httpSession=" + httpSession + "; remoteUser=" + remoteUser);
        }
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(httpRequest){

            public String getRemoteUser() {
                return spnegoAuthNuser;
            }
        };
        chain.doFilter((ServletRequest)wrapper, response);
    }

    private String getSpnegoAuthNuser(String remoteUser) {
        return remoteUser;
    }
}

