/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;

public class ApiKeyFileWriter {
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.fm.cli");

    static boolean writeOutputFile(String outputFilename, String keyName, String secret) {
        try {
            File outputFile = new File(outputFilename);
            if (outputFile.exists() && outputFile.isDirectory()) {
                throw new IOException(outputFile.getAbsolutePath() + " already exists and is a directory.");
            }
            JSON.prettyToFile((Object)new APIKey(keyName, secret), (File)outputFile);
            System.out.println("Key details written into " + outputFile.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            logger.error((Object)("Unable to write key file. Reason: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private static class APIKey {
        final String id;
        final String secret;

        public APIKey(String id, String secret) {
            this.id = id;
            this.secret = secret;
        }
    }
}

