/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.FMGroup;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.google.common.collect.Sets;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class CreateUserCommand
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "USER_ID"};

    @Override
    public String getUsageCommandName() {
        return "create-user";
    }

    @Override
    public String description() {
        return "Create a user within a tenant, and associate it with the administrators group for this tenant.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String emailAddress = args.get("USER_ID");
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        try (DatabaseAccessService.ReadWriteTransaction t = dbService.rwTransaction();){
            Tenant tenant = (Tenant)t.getThreadEM().find(Tenant.class, (Object)tenantId);
            if (tenant == null) {
                if (FMApp.getFMSettingsUnsafe().tenancy == FMTenancy.MONOTENANT) {
                    throw new IllegalStateException("No tenant created on this monotenant FM instance. Create the tenant first with the 'create-single-tenant' command.");
                }
                throw new IllegalArgumentException("Invalid or unknown tenant: " + tenantId);
            }
            FMUser existingUser = dbService.getSingleResult(FMUser.class, "SELECT u from fmuser u where u.tenant.id=?1 AND u.emailAddress = ?2", tenantId, emailAddress);
            if (existingUser != null) {
                throw new IllegalStateException(String.format("User '%s' already exists on the tenant.", emailAddress));
            }
            String groupId = "administrators";
            FMGroup group = dbService.getSingleResult(FMGroup.class, "SELECT g from fmgroup g where g.tenant.id=?1 AND g.groupId = ?2", tenantId, groupId);
            if (group == null) {
                group = new FMGroup();
                group.setTenant(tenant);
                group.setGroupId(groupId);
                group.setAdmin(true);
                t.getThreadEM().persist((Object)group);
            }
            FMUser user = new FMUser();
            user.setTenant(tenant);
            user.setEmailAddress(emailAddress);
            user.setGroups(Sets.newHashSet((Object[])new FMGroup[]{group}));
            t.getThreadEM().persist((Object)user);
            t.commit();
            System.out.println("Created new user: " + emailAddress);
            int n = 0;
            return n;
        }
    }
}

