/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.aws.AWSDNSService;
import com.dataiku.fm.cloud.azure.AzureDNSService;
import com.dataiku.fm.cloud.gcp.GCPDNSService;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class CloudDNSservice
implements DNSservice {
    @Autowired
    private AWSDNSService awsdnsService;
    @Autowired
    private AzureDNSService azureDNSService;
    @Autowired
    private GCPDNSService gcpdnsService;
    private DNSservice adapter;

    @PostConstruct
    public void init() {
        this.adapter = this.createAdapter();
    }

    private DNSservice createAdapter() {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                return this.awsdnsService;
            }
            case AZURE: {
                return this.azureDNSService;
            }
            case GCP: {
                return this.gcpdnsService;
            }
        }
        throw new IllegalStateException("Invalid cloud type: " + String.valueOf((Object)settings.cloud));
    }

    @Override
    public Map<DNSservice.ZoneType, PhysicalDNSRecord> addDNSRecords(VirtualNetwork virtualNetwork, String recordName, String targetPublicIP, String targetPrivateIp, DNSservice.RecordType recordType, Map<String, String> tags) {
        return this.adapter.addDNSRecords(virtualNetwork, recordName, targetPublicIP, targetPrivateIp, recordType, tags);
    }

    @Override
    public void removeDNSRecords(VirtualNetwork virtualNetwork, String recordName, DNSservice.RecordType recordType, boolean computeDNSNameWithZone) {
        this.adapter.removeDNSRecords(virtualNetwork, recordName, recordType, computeDNSNameWithZone);
    }

    @Override
    public Map<DNSservice.ZoneType, String> getFQDNs(VirtualNetwork virtualNetwork, String recordName) {
        return this.adapter.getFQDNs(virtualNetwork, recordName);
    }

    @Override
    public String getPublicDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return this.adapter.getPublicDNSZoneDomain(virtualNetwork);
    }

    @Override
    public String getPrivateDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return this.adapter.getPrivateDNSZoneDomain(virtualNetwork);
    }

    @Override
    public void checkIfZoneExist(VirtualNetwork virtualNetwork, String zoneId) {
        this.adapter.checkIfZoneExist(virtualNetwork, zoneId);
    }
}

