/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.VirtualNetwork;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LoadBalancerUtils {
    private LoadBalancerUtils() {
    }

    public static String getFQDN(String subdomainOrFQDN, LogicalLoadBalancer loadBalancer, DNSservice dnSservice) {
        VirtualNetwork virtualNetwork = loadBalancer.getVirtualNetwork();
        return virtualNetwork.getDnsStrategy() == VirtualNetwork.DNSStrategy.NONE ? subdomainOrFQDN : dnSservice.computeFQDNs(virtualNetwork, subdomainOrFQDN, loadBalancer.getPublicIpMode().isPublicIp()).orElse(subdomainOrFQDN);
    }
}

