/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Ec2Exception;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Filter;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.HttpTokensState;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Instance;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.InstanceStateName;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Reservation;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.ResourceType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Snapshot;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Tag;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.TagSpecification;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Volume;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudInstanceServiceInterface;
import com.dataiku.fm.cloud.CloudInstanceServiceUtils;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.PhysicalInstanceCloudState;
import com.dataiku.fm.cloud.VolumeNotFoundException;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.cloud.aws.AWSDNSService;
import com.dataiku.fm.cloud.aws.AWSUtils;
import com.dataiku.fm.cloud.aws.sdk.Ec2ClientWrapper;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettingsRepository;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.tag.TagService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AWSCloudInstanceService
implements CloudInstanceServiceInterface {
    private final AWSClientService awsClientService;
    private final DatabaseAccessService dbService;
    private final InstancesCRUDService instancesService;
    private final InstancesEventLogService eventsLogService;
    private final AWSDNSService awsdnsService;
    private final CloudCryptoService cryptoService;
    private final FMApp fmApp;
    private final InstanceImagesSettingsRepository instanceImagesSettingsRepository;
    private final TagService tagService;
    public static final long AWS_EBS_OPTIMIZING_RETRY_DELAY_MILLIS = 60000L;
    public static final long AWS_EBS_RATE_LIMIT_RETRY_DELAY_MILLIS = 21600000L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.aws.instances");

    @Autowired
    public AWSCloudInstanceService(AWSClientService awsClientService, DatabaseAccessService dbService, InstancesCRUDService instancesService, InstancesEventLogService eventsLogService, AWSDNSService awsdnsService, CloudCryptoService cryptoService, FMApp fmApp, InstanceImagesSettingsRepository instanceImagesSettingsRepository, TagService tagService) {
        this.awsClientService = awsClientService;
        this.dbService = dbService;
        this.instancesService = instancesService;
        this.eventsLogService = eventsLogService;
        this.awsdnsService = awsdnsService;
        this.cryptoService = cryptoService;
        this.fmApp = fmApp;
        this.instanceImagesSettingsRepository = instanceImagesSettingsRepository;
        this.tagService = tagService;
    }

    private AWSInstanceUserDataFMInfo generateFMInfo(FMSettings settings, LogicalInstance li) {
        AWSInstanceUserDataFMInfo fmInfo = new AWSInstanceUserDataFMInfo();
        CloudInstanceServiceUtils.fillFMInfo(this.cryptoService, fmInfo, settings, li, this.fmApp);
        switch (li.getVirtualNetwork().getHttpsStrategy()) {
            case NONE: {
                break;
            }
            case SELF_SIGNED: 
            case LETSENCRYPT: {
                fmInfo.domainNamesForCertificate.addAll(this.awsdnsService.getFQDNs(li.getVirtualNetwork(), li.getLabel()).values());
                if (StringUtils.isNotBlank((CharSequence)li.getAdditionalDomainNamesForCertificate())) {
                    JSON.StringList additionalDomainNames = (JSON.StringList)JSON.parse((String)li.getAdditionalDomainNamesForCertificate(), JSON.StringList.class);
                    fmInfo.domainNamesForCertificate.addAll(additionalDomainNames);
                }
                fmInfo.certbotStaging = Boolean.parseBoolean(System.getenv("DKU_FMMAIN_CERTBOT_STAGING"));
                fmInfo.contactMail = li.getVirtualNetwork().getContactMail();
                break;
            }
            case CUSTOM_CERTIFICATE: {
                fmInfo.sslCertificateKeyStorageMode = li.getSSLCertificateKeyStorageMode();
                fmInfo.sslCertificatePEM = li.getSslCertificatePEM();
                fmInfo.sslCertificateAwsSecretName = li.getSslCertificateAwsSecretName();
                break;
            }
            case AWS_ACM_PCA: {
                throw new NotImplementedException("AWS ACM PCA");
            }
        }
        fmInfo.dataikuAwsAPIAccessMode = li.getInstanceSettingsTemplate().getDataikuAWSAPIAccessMode();
        if (fmInfo.dataikuAwsAPIAccessMode == InstanceSettingsTemplate.DataikuAWSAPIAccessMode.KEYPAIR) {
            fmInfo.dataikuAwsKeypairStorageMode = li.getInstanceSettingsTemplate().getDataikuAwsKeypairStorageMode();
            switch (li.getInstanceSettingsTemplate().getDataikuAwsKeypairStorageMode()) {
                case NONE: 
                case INLINE_ENCRYPTED: {
                    break;
                }
                case AWS_SECRETS_MANAGER: {
                    fmInfo.dataikuAwsAccessKeyId = li.getInstanceSettingsTemplate().getDataikuAwsAccessKeyId();
                    fmInfo.dataikuAwsSecretKeyAwsSecretName = li.getInstanceSettingsTemplate().getDataikuAwsSecretAccessKeyAwsSecretName();
                }
            }
        }
        fmInfo.restrictAwsMetadataServerAccess = li.getInstanceSettingsTemplate().isRestrictAwsMetadataServerAccess();
        return fmInfo;
    }

    @Override
    public void checkInstanceCreation(VirtualNetwork vn, InstanceSettingsTemplate ist) {
        String keypair = ist.getAwsKeyPairName();
        if (StringUtils.isEmpty((CharSequence)keypair)) {
            return;
        }
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(vn, this.cryptoService, FMApp.getFMSettingsUnsafe()));
        try {
            DescribeKeyPairsResponse res = ec2.describeKeyPairs((DescribeKeyPairsRequest)DescribeKeyPairsRequest.builder().keyNames(new String[]{keypair}).build());
            if (res.keyPairs().isEmpty()) {
                throw new IllegalArgumentException("The key pair '" + keypair + "' does not exist in the '" + vn.getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe()) + "' region");
            }
        }
        catch (Ec2Exception ex) {
            if (ex.awsErrorDetails().errorCode().equals("UnauthorizedOperation")) {
                logger.info((Object)"No right to check if keypair exist, see ec2:DescribeKeyPairs");
                return;
            }
            throw new IllegalArgumentException("The key pair '" + keypair + "' cannot be checked in the in the '" + vn.getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe()) + "' region");
        }
    }

    private PhysicalDataVolume createPhysicalDataVolume(LogicalInstance li, CreateVolumeResponse response, PhysicalInstanceCreationState pics) {
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8));
        pdv.setLogicalInstance(li);
        pdv.setAwsEBSId(response.volumeId());
        pdv.setCreationState(pics);
        pdv.setGrowthState(PhysicalDataVolume.GrowthState.OK);
        pdv.setLastGrowthStateChangedTimestamp(0L);
        return pdv;
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolume(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        String region = li.getVirtualNetwork().getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe());
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        CreateVolumeRequest.Builder cvr = CreateVolumeRequest.builder();
        cvr.availabilityZone(li.getVirtualNetwork().getAwsAvailabilityZone()).size(Integer.valueOf(li.getDataVolumeSizeGB())).volumeType(li.getDataVolumeType()).tagSpecifications(new TagSpecification[]{AWSUtils.getTagsWithName(ResourceType.VOLUME, "Datadir for " + li.getLabel() + " (DSS managed by FM)", this.tagService.getCloudApplicableTags(li))});
        if (!li.getDataVolumeType().equals("gp2") && li.getDataVolumeIOPS() != null) {
            cvr.iops(li.getDataVolumeIOPS());
        }
        if (li.getEncryptDataVolume()) {
            cvr.encrypted(Boolean.valueOf(true));
            cvr.kmsKeyId(li.getDataVolumeEncryptionKey());
        }
        CreateVolumeResponse result = ec2.createVolume((CreateVolumeRequest)cvr.build());
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        InstanceImagesSettings.InstanceImage instanceImage = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId());
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        pics.setAwsAMIId(instanceImage.getAMIIdForRegion(region));
        PhysicalDataVolume pdv = this.createPhysicalDataVolume(li, result, pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolumeFromExternalSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String externalSnapshotId) {
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        Snapshot snapshot = (Snapshot)ec2.describeSnapshots((DescribeSnapshotsRequest)DescribeSnapshotsRequest.builder().snapshotIds(new String[]{externalSnapshotId}).build()).snapshots().get(0);
        if (snapshot.encrypted().booleanValue() && !li.getEncryptDataVolume()) {
            throw new IllegalStateException("If the source snapshot is encrypted, the resulting data volume must be encrypted");
        }
        li.setDataVolumeSizeGB(snapshot.volumeSize());
        CreateVolumeRequest.Builder cvr = CreateVolumeRequest.builder();
        cvr.availabilityZone(li.getVirtualNetwork().getAwsAvailabilityZone()).snapshotId(externalSnapshotId).tagSpecifications(new TagSpecification[]{AWSUtils.getTagsWithName(ResourceType.VOLUME, "Datadir for " + li.getLabel() + " (DSS managed by FM)", this.tagService.getCloudApplicableTags(li, Optional.empty(), Optional.of(externalSnapshotId)))});
        if (li.getEncryptDataVolume()) {
            cvr.encrypted(Boolean.valueOf(true));
            String dataVolumeKey = li.getDataVolumeEncryptionKey();
            if (snapshot.encrypted().booleanValue() && dataVolumeKey == null) {
                String defaultKmsKeyID = ec2.getEbsDefaultKmsKeyId((GetEbsDefaultKmsKeyIdRequest)GetEbsDefaultKmsKeyIdRequest.builder().build()).kmsKeyId();
                cvr.kmsKeyId(defaultKmsKeyID);
            } else {
                cvr.kmsKeyId(dataVolumeKey);
            }
        }
        CreateVolumeResponse response = ec2.createVolume((CreateVolumeRequest)cvr.build());
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        InstanceImagesSettings.InstanceImage instanceImage = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId());
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        pics.setAwsAMIId(instanceImage.getAMIIdForRegion(settings.awsSettings.regionId));
        PhysicalDataVolume pdv = this.createPhysicalDataVolume(li, response, pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public PhysicalDataVolume createPhysicalDataVolumeFromSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String snapshotId) {
        String region = li.getVirtualNetwork().getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe());
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        DataVolumeSnapshot dvs = (DataVolumeSnapshot)this.dbService.getThreadEM().find(DataVolumeSnapshot.class, (Object)snapshotId);
        CreateVolumeRequest.Builder cvr = CreateVolumeRequest.builder();
        cvr.availabilityZone(li.getVirtualNetwork().getAwsAvailabilityZone()).snapshotId(dvs.getAwsSnapshotId()).tagSpecifications(new TagSpecification[]{AWSUtils.getTagsWithName(ResourceType.VOLUME, "Datadir for " + li.getLabel() + " (DSS managed by FM)", this.tagService.getCloudApplicableTags(li, Optional.empty(), Optional.of(dvs.getId())))});
        if (li.getEncryptDataVolume()) {
            cvr.encrypted(Boolean.valueOf(true));
            cvr.kmsKeyId(li.getDataVolumeEncryptionKey());
        }
        CreateVolumeResponse response = ec2.createVolume((CreateVolumeRequest)cvr.build());
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        InstanceImagesSettings.InstanceImage instanceImage = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId());
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        pics.setAwsAMIId(instanceImage.getAMIIdForRegion(region));
        PhysicalDataVolume pdv = this.createPhysicalDataVolume(li, response, pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public DataVolumeSnapshot createPhysicalDataVolumeSnapshot(LogicalInstance li, String snapshotType, String description) {
        CreateSnapshotResponse csr;
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No Physical Data Volume for instance: " + li.getId());
        }
        long now = System.currentTimeMillis();
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        try {
            csr = ec2.createSnapshot((CreateSnapshotRequest)CreateSnapshotRequest.builder().description(String.format("fm-snap-%s-%s-%s", li.getId(), description, DKUDateUtils.isoFormatFileFriendlyLocal((long)now))).volumeId(pdv.getAwsEBSId()).tagSpecifications(new TagSpecification[]{AWSUtils.getTagsWithName(ResourceType.SNAPSHOT, "Snapshot of " + li.getLabel() + " (DSS managed by FM)", this.tagService.getSnapshotCloudApplicableTags(li, snapshotType, description, Optional.empty()))}).build());
        }
        catch (Ec2Exception e) {
            if (e.statusCode() == 400 && e.awsErrorDetails().errorCode().equals("InvalidVolume.NotFound")) {
                throw new VolumeNotFoundException(pdv.getAwsEBSId(), e);
            }
            throw e;
        }
        DataVolumeSnapshot dvs = new DataVolumeSnapshot();
        dvs.setId("dvs-" + SecretKeyGenerator.generate((int)12));
        dvs.setLogicalInstance(li);
        dvs.setAwsSnapshotId(csr.snapshotId());
        dvs.setCreationDate(now);
        dvs.setSnapshotType(snapshotType);
        dvs.setDescription(description);
        return dvs;
    }

    @Override
    public void deletePhysicalDataVolumeSnapshot(DataVolumeSnapshot dataVolumeSnapshot, LogicalInstance logicalInstance) {
        block2: {
            Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(logicalInstance.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
            try {
                ec2.deleteSnapshot((DeleteSnapshotRequest)DeleteSnapshotRequest.builder().snapshotId(dataVolumeSnapshot.getAwsSnapshotId()).build());
            }
            catch (Ec2Exception e) {
                if (e.awsErrorDetails().errorCode().equals("InvalidSnapshot.NotFound")) break block2;
                throw e;
            }
        }
    }

    @Override
    public void deletePhysicalDataVolume(PhysicalDataVolume physicalDataVolume, LogicalInstance logicalInstance) {
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(logicalInstance.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        try {
            ec2.deleteVolume((DeleteVolumeRequest)DeleteVolumeRequest.builder().volumeId(physicalDataVolume.getAwsEBSId()).build());
        }
        catch (Ec2Exception e) {
            if (e.statusCode() == 400 && e.awsErrorDetails().errorCode().equals("InvalidVolume.NotFound")) {
                throw new VolumeNotFoundException(physicalDataVolume.getAwsEBSId(), e);
            }
            throw e;
        }
    }

    @Override
    public String createPhysicalInstance(LogicalInstance li, DKUtils.SmartLogTailBuilder smartLogTail) throws MessagingException, IOException {
        String groups;
        FMSettings settings = this.fmApp.getFMSettings();
        String region = li.getVirtualNetwork().getAwsRegionOrSettingsDefault(settings);
        AWSInstanceUserDataFMInfo fmInfo = this.generateFMInfo(settings, li);
        String awsUserData = CloudInstanceServiceUtils.generateUserData(fmInfo);
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No PDV for instance: " + li.getId());
        }
        InstanceImagesSettings.InstanceImage instanceImage = this.instanceImagesSettingsRepository.getAll().get(li.getImageId());
        logger.info((Object)("ASSIGN PUBLIC IP: " + li.getVirtualNetwork().isAwsAssignPublicIP()));
        InstanceNetworkInterfaceSpecification.Builder networkSpec = InstanceNetworkInterfaceSpecification.builder().deviceIndex(Integer.valueOf(0)).subnetId(li.getVirtualNetwork().getAwsSubnetId());
        if (StringUtils.isNotBlank((CharSequence)li.getAwsPrivateIP())) {
            networkSpec.privateIpAddress(li.getAwsPrivateIP());
        }
        if (StringUtils.isNotBlank((CharSequence)(groups = li.getVirtualNetwork().getAwsSecurityGroups()))) {
            networkSpec.groups((Collection)Lists.newArrayList((Object[])groups.split(",")));
        }
        boolean requireIMDSv2 = Boolean.parseBoolean(this.fmApp.getProperty_IM("requireIMDSv2", "true"));
        networkSpec.associatePublicIpAddress(Boolean.valueOf(li.getVirtualNetwork().isAwsAssignPublicIP()));
        InstanceMetadataOptionsRequest metadataOptions = (InstanceMetadataOptionsRequest)InstanceMetadataOptionsRequest.builder().httpTokens(requireIMDSv2 ? HttpTokensState.REQUIRED : HttpTokensState.OPTIONAL).build();
        RunInstancesRequest.Builder riq = RunInstancesRequest.builder().metadataOptions(metadataOptions).minCount(Integer.valueOf(1)).maxCount(Integer.valueOf(1)).networkInterfaces(new InstanceNetworkInterfaceSpecification[]{(InstanceNetworkInterfaceSpecification)networkSpec.build()}).imageId(instanceImage.getAMIIdForRegion(region)).instanceType(li.getCloudInstanceType()).userData(awsUserData);
        if (StringUtils.isNotBlank((CharSequence)ist.getStartupInstanceProfileArn())) {
            riq.iamInstanceProfile((IamInstanceProfileSpecification)IamInstanceProfileSpecification.builder().arn(ist.getStartupInstanceProfileArn()).build());
        } else if (StringUtils.isNotBlank((CharSequence)ist.getRuntimeInstanceProfileArn())) {
            riq.iamInstanceProfile((IamInstanceProfileSpecification)IamInstanceProfileSpecification.builder().arn(ist.getRuntimeInstanceProfileArn()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)ist.getAwsKeyPairName())) {
            riq.keyName(ist.getAwsKeyPairName());
        }
        if (li.getRootVolumeSizeGB() != null) {
            EbsBlockDevice.Builder ebd = EbsBlockDevice.builder();
            ebd.volumeSize(li.getRootVolumeSizeGB());
            if (li.getAwsRootVolumeType() != null) {
                ebd.volumeType(li.getAwsRootVolumeType());
                if (li.getAwsRootVolumeType().equals("io1") || li.getAwsRootVolumeType().equals("gp3")) {
                    ebd.iops(li.getAwsRootVolumeIOPS());
                }
            }
            if (li.getEncryptDataVolume() && li.getEncryptRootVolume()) {
                ebd.encrypted(Boolean.valueOf(true));
                ebd.kmsKeyId(li.getDataVolumeEncryptionKey());
            }
            riq.blockDeviceMappings(new BlockDeviceMapping[]{(BlockDeviceMapping)BlockDeviceMapping.builder().deviceName("/dev/sda1").ebs((EbsBlockDevice)ebd.build()).build()});
        }
        String physicalInstanceId = "pi-" + SecretKeyGenerator.generate((int)12);
        HashMap<ResourceType, String> resourceTypesToTag = new HashMap<ResourceType, String>(Map.of(ResourceType.INSTANCE, String.format("%s (DSS managed by FM)", li.getLabel()), ResourceType.NETWORK_INTERFACE, String.format("Network interface for %s (DSS managed by FM)", li.getLabel())));
        boolean skipRootVolumeTag = Boolean.parseBoolean(this.fmApp.getProperty_IM("skipRootVolumeTag", "false"));
        if (!skipRootVolumeTag) {
            resourceTypesToTag.put(ResourceType.VOLUME, String.format("Root volume for %s (DSS managed by FM)", li.getLabel()));
        }
        Collection tags = resourceTypesToTag.entrySet().stream().map(resource -> AWSUtils.getTagsWithName((ResourceType)resource.getKey(), (String)resource.getValue(), this.tagService.getCloudApplicableTags(li, physicalInstanceId))).collect(Collectors.toList());
        riq.tagSpecifications(tags);
        try {
            logger.info((Object)("RIQ: " + JSON.pretty((Object)riq)));
        }
        catch (Exception e) {
            logger.info((Object)"Couldn't log request.", (Throwable)e);
        }
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("cloudInstanceType", li.getCloudInstanceType()).with("imageId", li.getImageId()));
        Ec2ClientWrapper ec2ClientWrapper = this.awsClientService.getEc2ClientWrapper(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, this.fmApp.getFMSettings()));
        Ec2Client ec2 = ec2ClientWrapper.getClient();
        RunInstancesResponse rir = ec2.runInstances((RunInstancesRequest)riq.build());
        String awsInstanceId = ((Instance)rir.instances().get(0)).instanceId();
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-vm-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("ec2InstanceId", awsInstanceId));
        PhysicalInstance pi = new PhysicalInstance();
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
            pi.setId(physicalInstanceId);
            pi.setLogicalInstance(li);
            pi.setCreationState(pics);
            pi.setAwsEC2InstanceId(awsInstanceId);
            rwt.getThreadEM().persist((Object)pics);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        logger.info((Object)"Waiting for instance to be running");
        ec2.waiter().waitUntilInstanceRunning((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{awsInstanceId}).build());
        Volume dataVolume = null;
        try {
            List matchingVolumes = ec2.describeVolumes((DescribeVolumesRequest)DescribeVolumesRequest.builder().volumeIds(new String[]{pdv.getAwsEBSId()}).build()).volumes();
            if (!matchingVolumes.isEmpty()) {
                dataVolume = (Volume)matchingVolumes.get(0);
            }
        }
        catch (Ec2Exception e) {
            if (e.statusCode() == 400 && e.awsErrorDetails().errorCode().equals("InvalidVolume.NotFound")) {
                throw new IllegalStateException(String.format("Data disk '%s' was not found, either reprovision from a snapshot, or re-create a new DSS instance using template '%s'", pdv.getAwsEBSId(), li.getInstanceSettingsTemplate().getId()));
            }
            throw e;
        }
        logger.info((Object)"Instance is running, attaching volume");
        ec2.attachVolume((AttachVolumeRequest)AttachVolumeRequest.builder().device("/dev/sdf").instanceId(awsInstanceId).volumeId(pdv.getAwsEBSId()).build());
        this.eventsLogService.addEventASync_NT(li, null, "pi-volume-attached", JF.obj().with("physicalInstanceId", physicalInstanceId).with("ec2InstanceId", awsInstanceId));
        try {
            Optional<String> restoredFromFMSnapshotIdOptional = dataVolume != null && !StringUtils.isBlank((CharSequence)dataVolume.snapshotId()) ? Optional.of(dataVolume.snapshotId()) : Optional.empty();
            ec2.createTags((CreateTagsRequest)CreateTagsRequest.builder().tags((Collection)AWSUtils.getTagSpecification(ResourceType.VOLUME, this.tagService.getCloudApplicableTags(li, Optional.of(physicalInstanceId), restoredFromFMSnapshotIdOptional)).tags()).resources(new String[]{pdv.getAwsEBSId()}).build());
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Unable to update tags on data disk '%s' of instance '%s'. Skipping.", new Object[]{pdv.getAwsEBSId(), awsInstanceId});
        }
        logger.info((Object)("Assign elastic IP: " + li.isAwsAssignElasticIP()));
        if (li.isAwsAssignElasticIP()) {
            ec2.associateAddress((AssociateAddressRequest)AssociateAddressRequest.builder().instanceId(awsInstanceId).allocationId(li.getAwsElasticIPAllocationId()).build());
        }
        this.awsdnsService.updateDnsRecords(ec2, awsInstanceId, pi, DNSservice.RecordType.A, this.tagService.getCloudApplicableTags(li).asMap());
        this.updateSnapshotTags(li, ec2ClientWrapper, physicalInstanceId);
        return physicalInstanceId;
    }

    private void updateSnapshotTags(LogicalInstance li, Ec2ClientWrapper ec2ClientWrapper, String physicalInstanceId) {
        try {
            List<DataVolumeSnapshot> snapshots = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1", li);
            if (snapshots == null || snapshots.isEmpty()) {
                logger.debugV("The instance '%s' has no linked snapshots, or none was found", new Object[]{li.getLabel()});
            } else {
                snapshots.stream().filter(snapshot -> StringUtils.isNotBlank((CharSequence)snapshot.getAwsSnapshotId())).forEach(snapshot -> {
                    String snapshotId = snapshot.getAwsSnapshotId();
                    Set existingTags = ec2ClientWrapper.describeTags(snapshotId).tags().stream().map(tagDescription -> (Tag)Tag.builder().key(tagDescription.key()).value(tagDescription.value()).build()).collect(Collectors.toSet());
                    Set<Tag> desiredTags = AWSUtils.getTags(this.tagService.getSnapshotCloudApplicableTags(li, physicalInstanceId, snapshot.getSnapshotType(), snapshot.getDescription(), Optional.of("Name")));
                    Set<Tag> tagsToDelete = existingTags.stream().filter(tag -> !desiredTags.contains(tag)).collect(Collectors.toSet());
                    Set<Tag> tagsToCreate = desiredTags.stream().filter(tag -> !existingTags.contains(tag)).collect(Collectors.toSet());
                    ec2ClientWrapper.deleteTags(snapshotId, tagsToDelete);
                    ec2ClientWrapper.createTags(snapshotId, tagsToCreate);
                });
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Error updating tags for snapshots of instance '%s'", new Object[]{li.getLabel()});
        }
    }

    @Override
    public boolean growPhysicalDataVolume(LogicalInstance li, double growthFactor) {
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        boolean growthSuccessful = false;
        long dslc = System.currentTimeMillis() - pdv.getLastGrowthStateChangedTimestamp();
        if (pdv.getGrowthState() == PhysicalDataVolume.GrowthState.OK || 60000L < dslc && pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_OPTIMTIZING || 21600000L < dslc && pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_RATE_LIMIT) {
            Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                int currentSize = li.getDataVolumeSizeGB();
                int newSize = (int)Math.ceil(growthFactor * (double)currentSize);
                if (newSize <= currentSize) {
                    newSize = currentSize + 1;
                }
                if (li.getDataVolumeSizeMaxGB() < newSize) {
                    newSize = li.getDataVolumeSizeMaxGB();
                }
                try {
                    ec2.modifyVolume((ModifyVolumeRequest)ModifyVolumeRequest.builder().size(Integer.valueOf(newSize)).volumeId(pdv.getAwsEBSId()).build());
                    pdv.setGrowthState(PhysicalDataVolume.GrowthState.OK);
                    pdv.setLastGrowthStateChangedTimestamp(System.currentTimeMillis());
                    li.setDataVolumeSizeGB(newSize);
                    growthSuccessful = true;
                }
                catch (Ec2Exception e) {
                    logger.warn((Object)"EBS Volume cannot be grown", (Throwable)e);
                    if (e.awsErrorDetails().errorCode().equals("IncorrectModificationState")) {
                        pdv.setGrowthState(PhysicalDataVolume.GrowthState.AWS_OPTIMTIZING);
                        pdv.setLastGrowthStateChangedTimestamp(System.currentTimeMillis());
                    }
                    if (e.awsErrorDetails().errorCode().equals("VolumeModificationRateExceeded")) {
                        pdv.setGrowthState(PhysicalDataVolume.GrowthState.AWS_RATE_LIMIT);
                        pdv.setLastGrowthStateChangedTimestamp(System.currentTimeMillis());
                    }
                    throw e;
                }
                rwt.getThreadEM().persist((Object)pdv);
                rwt.getThreadEM().persist((Object)li);
                rwt.commit();
            }
        }
        logger.debugV("Error delays not expired, disk growth skipped li=%s, pdv=%s", new Object[]{li, pdv});
        return growthSuccessful;
    }

    @Override
    public void configurePhysicalInstanceBeforeStartupPhase(PhysicalInstance pi) {
        logger.info((Object)"Instance is starting up, switching the role if needed");
        InstanceSettingsTemplate ist = pi.getLogicalInstance().getInstanceSettingsTemplate();
        boolean instanceHasStartupRole = StringUtils.isNotBlank((CharSequence)ist.getStartupInstanceProfileArn());
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(pi.getLogicalInstance().getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        DescribeIamInstanceProfileAssociationsResponse describer = ec2.describeIamInstanceProfileAssociations((DescribeIamInstanceProfileAssociationsRequest)DescribeIamInstanceProfileAssociationsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("instance-id").values(new String[]{pi.getAwsEC2InstanceId()}).build()}).build());
        if (instanceHasStartupRole) {
            logger.info((Object)("Instance has a startup role " + ist.getStartupInstanceProfileArn() + ", need to associate it to the VM"));
            if (StringUtils.isNotBlank((CharSequence)ist.getRuntimeInstanceProfileArn())) {
                logger.info((Object)("Instance has a runtime role " + ist.getRuntimeInstanceProfileArn() + ", disassociating runtime one first"));
                String associationId = ((IamInstanceProfileAssociation)describer.iamInstanceProfileAssociations().get(0)).associationId();
                String oldARN = ((IamInstanceProfileAssociation)describer.iamInstanceProfileAssociations().get(0)).iamInstanceProfile().arn();
                logger.info((Object)("IAM profile associated associationId=" + associationId + " oldARN=" + oldARN));
                ec2.disassociateIamInstanceProfile((DisassociateIamInstanceProfileRequest)DisassociateIamInstanceProfileRequest.builder().associationId(associationId).build());
            }
            logger.info((Object)("Associating startup profile ARN " + pi.getLogicalInstance().getInstanceSettingsTemplate().getStartupInstanceProfileArn()));
            ec2.associateIamInstanceProfile((AssociateIamInstanceProfileRequest)AssociateIamInstanceProfileRequest.builder().iamInstanceProfile((IamInstanceProfileSpecification)IamInstanceProfileSpecification.builder().arn(pi.getLogicalInstance().getInstanceSettingsTemplate().getStartupInstanceProfileArn()).build()).instanceId(pi.getAwsEC2InstanceId()).build());
        }
    }

    @Override
    public void configurePhysicalInstanceAfterStartupPhase(PhysicalInstance pi) {
        logger.info((Object)"Instance has finished startup, switching the role if needed");
        InstanceSettingsTemplate ist = pi.getLogicalInstance().getInstanceSettingsTemplate();
        boolean instanceHasRuntimeRole = StringUtils.isNotBlank((CharSequence)ist.getRuntimeInstanceProfileArn());
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(pi.getLogicalInstance().getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        DescribeIamInstanceProfileAssociationsResponse describer = ec2.describeIamInstanceProfileAssociations((DescribeIamInstanceProfileAssociationsRequest)DescribeIamInstanceProfileAssociationsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("instance-id").values(new String[]{pi.getAwsEC2InstanceId()}).build()}).build());
        boolean skipReassociation = false;
        if (!describer.iamInstanceProfileAssociations().isEmpty()) {
            String associationId = ((IamInstanceProfileAssociation)describer.iamInstanceProfileAssociations().get(0)).associationId();
            String oldARN = ((IamInstanceProfileAssociation)describer.iamInstanceProfileAssociations().get(0)).iamInstanceProfile().arn();
            logger.info((Object)("IAM profile associated associationId=" + associationId + " oldARN=" + oldARN));
            boolean disassociate = false;
            if (!instanceHasRuntimeRole) {
                logger.info((Object)"Instance has no runtime ARN profile, disassociating");
                disassociate = true;
            } else if (instanceHasRuntimeRole && !oldARN.equals(ist.getRuntimeInstanceProfileArn())) {
                logger.info((Object)("Instance has different runtime profile ARN " + ist.getRuntimeInstanceProfileArn() + " than current one, disassociating current one"));
                disassociate = true;
            } else if (instanceHasRuntimeRole) {
                logger.info((Object)"Instance has same runtime role as current one, not disassociating (and thus not reassociating)");
                skipReassociation = true;
            }
            if (disassociate) {
                ec2.disassociateIamInstanceProfile((DisassociateIamInstanceProfileRequest)DisassociateIamInstanceProfileRequest.builder().associationId(associationId).build());
            }
        }
        if (instanceHasRuntimeRole && !skipReassociation) {
            logger.info((Object)("Associating runtime profile ARN " + pi.getLogicalInstance().getInstanceSettingsTemplate().getRuntimeInstanceProfileArn()));
            ec2.associateIamInstanceProfile((AssociateIamInstanceProfileRequest)AssociateIamInstanceProfileRequest.builder().iamInstanceProfile((IamInstanceProfileSpecification)IamInstanceProfileSpecification.builder().arn(pi.getLogicalInstance().getInstanceSettingsTemplate().getRuntimeInstanceProfileArn()).build()).instanceId(pi.getAwsEC2InstanceId()).build());
        }
    }

    @Override
    public void terminatePhysicalInstance(PhysicalInstance pi) {
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(pi.getLogicalInstance().getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        logger.infoV("Requesting termination of instance li=%s pi=%s aws=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAwsEC2InstanceId()});
        ec2.terminateInstances((TerminateInstancesRequest)TerminateInstancesRequest.builder().instanceIds(new String[]{pi.getAwsEC2InstanceId()}).build());
        logger.infoV("waiting for termination of instance li=%s pi=%s aws=%s to complete", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAwsEC2InstanceId()});
        ec2.waiter().waitUntilInstanceTerminated((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{pi.getAwsEC2InstanceId()}).build());
        this.awsdnsService.removeDNSRecords(pi.getLogicalInstance().getVirtualNetwork(), pi.getLogicalInstance().getLabel(), DNSservice.RecordType.A, true);
    }

    @Override
    public void startPhysicalInstance(PhysicalInstance pi) {
        LogicalInstance li = pi.getLogicalInstance();
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        String awsEC2InstanceId = pi.getAwsEC2InstanceId();
        logger.infoV("Requesting start of instance li=%s pi=%s aws=%s", new Object[]{pi.getId(), li.getId(), awsEC2InstanceId});
        ec2.startInstances((StartInstancesRequest)StartInstancesRequest.builder().instanceIds(new String[]{awsEC2InstanceId}).build());
        logger.infoV("Waiting for start of instance li=%s pi=%s aws=%s to complete", new Object[]{pi.getId(), li.getId(), awsEC2InstanceId});
        ec2.waiter().waitUntilInstanceRunning((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{awsEC2InstanceId}).build());
        if (!li.isAwsAssignElasticIP()) {
            this.awsdnsService.updateDnsRecords(ec2, awsEC2InstanceId, pi, DNSservice.RecordType.A, this.tagService.getCloudApplicableTags(li).asMap());
        }
    }

    @Override
    public void stopPhysicalInstance(PhysicalInstance pi) {
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(pi.getLogicalInstance().getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        logger.infoV("Requesting stop of instance li=%s pi=%s aws=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAwsEC2InstanceId()});
        ec2.stopInstances((StopInstancesRequest)StopInstancesRequest.builder().instanceIds(new String[]{pi.getAwsEC2InstanceId()}).build());
        logger.infoV("waiting for stop of instance li=%s pi=%s aws=%s to complete", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAwsEC2InstanceId()});
        ec2.waiter().waitUntilInstanceStopped((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{pi.getAwsEC2InstanceId()}).build());
    }

    @Override
    public void rebootPhysicalInstance(PhysicalInstance pi) {
        LogicalInstance li = pi.getLogicalInstance();
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(li.getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        String awsEC2InstanceId = pi.getAwsEC2InstanceId();
        logger.infoV("Requesting restart of instance li=%s pi=%s aws=%s", new Object[]{pi.getId(), li.getId(), awsEC2InstanceId});
        ec2.rebootInstances((RebootInstancesRequest)RebootInstancesRequest.builder().instanceIds(new String[]{awsEC2InstanceId}).build());
        logger.infoV("Waiting for restart of instance li=%s pi=%s aws=%s to complete", new Object[]{pi.getId(), li.getId(), awsEC2InstanceId});
        ec2.waiter().waitUntilInstanceRunning((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{awsEC2InstanceId}).build());
    }

    @Override
    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(Tenant tenant, Collection<PhysicalInstance> piList) {
        return piList.stream().collect(Collectors.groupingBy(physicalInstance -> physicalInstance.getLogicalInstance().getVirtualNetwork())).entrySet().stream().flatMap(e -> this.getPhysicalInstancesCloudState((VirtualNetwork)e.getKey(), (Collection<PhysicalInstance>)((Collection)e.getValue())).stream()).collect(Collectors.toList());
    }

    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(VirtualNetwork virtualNetwork, Collection<PhysicalInstance> piList) {
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cryptoService, FMApp.getFMSettingsUnsafe()));
        HashMap<String, PhysicalInstanceCloudState> cloudStateMap = new HashMap<String, PhysicalInstanceCloudState>();
        for (PhysicalInstance pi : piList) {
            cloudStateMap.put(pi.getAwsEC2InstanceId(), new PhysicalInstanceCloudState(pi));
        }
        try {
            DescribeInstancesResponse describeResult = ec2.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(cloudStateMap.keySet()).build());
            for (Reservation reservation : describeResult.reservations()) {
                for (Instance ec2Instance : reservation.instances()) {
                    PhysicalInstanceCloudState state = (PhysicalInstanceCloudState)cloudStateMap.get(ec2Instance.instanceId());
                    if (state == null) {
                        logger.warn((Object)("Received instance state about a non-requested instance: " + ec2Instance.instanceId()));
                        continue;
                    }
                    state.cloudMachineExists = true;
                    if (ec2Instance.state().name() != InstanceStateName.RUNNING) continue;
                    state.cloudMachineIsUp = true;
                }
            }
        }
        catch (Ec2Exception e) {
            logger.warn((Object)"Failed to describe instances, they are probably not available", (Throwable)e);
        }
        return cloudStateMap.values();
    }

    @Override
    public void fillPhysicalStatusWithCloudSpecificData(PhysicalInstance pi, PhysicalDataVolume pdv, PublicPhysicalInstanceStatus status) {
        long remainingTimeMillis;
        String region = pi.getLogicalInstance().getVirtualNetwork().getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe());
        Ec2Client ec2 = this.awsClientService.getEC2Client(AWSUtils.buildAWSAccount(pi.getLogicalInstance().getVirtualNetwork(), this.cryptoService, FMApp.getFMSettingsUnsafe()));
        try {
            DescribeInstancesResponse described = ec2.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{pi.getAwsEC2InstanceId()}).build());
            List reservations = described.reservations();
            if (reservations.isEmpty()) {
                status.cloudMachineExists = false;
            } else {
                status.cloudMachineExists = true;
                Instance instance = (Instance)((Reservation)reservations.get(0)).instances().get(0);
                if (instance.state().name() == InstanceStateName.RUNNING) {
                    status.cloudMachineIsUp = true;
                } else {
                    if (instance.state().name() == InstanceStateName.STOPPING) {
                        status.cloudInTransition = true;
                    }
                    status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "EC2 machine is not RUNNING: it is '%s'", new Object[]{instance.state().name()});
                }
                status.awsRegionId = region;
                status.awsInstanceId = instance.instanceId();
                status.privateIP = instance.privateIpAddress();
                status.publicIP = instance.publicIpAddress();
            }
            status.externalURL = pi.getLogicalInstance().getExternalURL();
        }
        catch (Ec2Exception e) {
            logger.warn((Object)"Failed to describe instance, it's probably not available", (Throwable)e);
            status.cloudMachineExists = false;
            status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "Failed to get the status of the EC2 machine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        VirtualNetwork virtualNetwork = pi.getLogicalInstance().getVirtualNetwork();
        status.privateDNS = pi.getPrivateDnsName();
        status.privateURL = AWSCloudInstanceService.computeUrl(virtualNetwork, status.privateDNS, status.privateIP);
        status.publicDNS = pi.getPublicDnsName();
        status.publicURL = StringUtils.isBlank((CharSequence)status.externalURL) ? AWSCloudInstanceService.computeUrl(virtualNetwork, status.publicDNS, status.publicIP) : status.externalURL;
        if (pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_OPTIMTIZING) {
            long remainingTimeMillis2 = 60000L - System.currentTimeMillis() + pdv.getLastGrowthStateChangedTimestamp();
            if (0L < remainingTimeMillis2) {
                status.statusMessages.withWarning((InfoMessage.MessageCode)FMServerCodes.WARN_DATA_VOLUME_CANNOT_GROW, "EBS volume cannot be grown in OPTIMIZING state.");
            }
        } else if (pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_RATE_LIMIT && 0L < (remainingTimeMillis = 21600000L - System.currentTimeMillis() + pdv.getLastGrowthStateChangedTimestamp())) {
            long remainingHours = TimeUnit.MILLISECONDS.toHours(remainingTimeMillis);
            long remainingMinutes = TimeUnit.MILLISECONDS.toMinutes(remainingTimeMillis - 3600000L * remainingHours);
            status.statusMessages.withWarningV((InfoMessage.MessageCode)FMServerCodes.WARN_DATA_VOLUME_CANNOT_GROW, "EBS volume exceeded the growth rate limit. Remaining time before next growth: %d hour(s) and %d minute(s)", new Object[]{remainingHours, remainingMinutes});
        }
    }

    private static String computeUrl(VirtualNetwork virtualNetwork, String dnsName, String ip) {
        String prefix;
        String string = prefix = virtualNetwork.getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? "http://" : "https://";
        if (dnsName != null) {
            return StringUtils.removeEnd((String)(prefix + dnsName), (String)".");
        }
        if (ip != null) {
            return prefix + ip;
        }
        return null;
    }

    static class AWSInstanceUserDataFMInfo
    extends CloudInstanceServiceUtils.BaseInstanceUserDataFMInfo {
        String sslCertificateAwsSecretName;
        InstanceSettingsTemplate.DataikuAWSAPIAccessMode dataikuAwsAPIAccessMode;
        InstanceSettingsTemplate.DataikuAWSKeypairStorageMode dataikuAwsKeypairStorageMode;
        String dataikuAwsAccessKeyId;
        String dataikuAwsSecretKeyAwsSecretName;
        boolean restrictAwsMetadataServerAccess;

        AWSInstanceUserDataFMInfo() {
        }
    }
}

