/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws.sdk;

import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DeleteCertificateRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DeleteCertificateResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DescribeCertificateRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DescribeCertificateResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DomainValidationOption;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.RequestCertificateRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.RequestCertificateResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.Tag;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AcmClientWrapper {
    private final AcmClient acmClient;

    public AcmClientWrapper(AcmClient acmClient) {
        this.acmClient = acmClient;
    }

    public RequestCertificateResponse requestCertificate(String domain, List<String> remainingDomains, Collection<Tag> tags) {
        RequestCertificateRequest.Builder requestCertificateRequest = RequestCertificateRequest.builder().domainValidationOptions(new DomainValidationOption[]{(DomainValidationOption)DomainValidationOption.builder().domainName(domain).validationDomain(domain).build()}).validationMethod("DNS").domainName(domain).tags(tags).subjectAlternativeNames(remainingDomains.isEmpty() ? null : remainingDomains);
        return this.acmClient.requestCertificate((RequestCertificateRequest)requestCertificateRequest.build());
    }

    public DescribeCertificateResponse describeCertificate(String certificateARN) {
        return this.acmClient.describeCertificate((DescribeCertificateRequest)DescribeCertificateRequest.builder().certificateArn(certificateARN).build());
    }

    public DeleteCertificateResponse deleteCertificate(String certificateARN) {
        return this.acmClient.deleteCertificate((DeleteCertificateRequest)DeleteCertificateRequest.builder().certificateArn(certificateARN).build());
    }
}

