/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AzureInstanceMetadataReader {
    private static final Cache<String, String> metadataCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final Logger logger = Logger.getLogger((String)"dku.fm.azure.metadata");

    public static JSONObject getInstanceMetadata() {
        String response = AzureInstanceMetadataReader.getLocalMetadata("instance");
        if (StringUtils.isNotBlank((String)response)) {
            return new JSONObject(response);
        }
        return new JSONObject();
    }

    public static String getLocalMetadata(String path) {
        try {
            return (String)metadataCache.get((Object)"metadata", () -> {
                URL url = new URL(String.format("http://169.254.169.254/metadata/%s?api-version=2020-06-01", path));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestProperty("Metadata", "true");
                con.setConnectTimeout(15000);
                if (con.getResponseCode() == 200) {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String string = in.lines().collect(Collectors.joining());
                        return string;
                    }
                }
                logger.warn((Object)("Unable to retrieve local metadata " + path + ", response code=" + con.getResponseCode()));
                return "";
            });
        }
        catch (ExecutionException e) {
            logger.warn((Object)("Unable to retrieve local metadata " + path), (Throwable)e);
            return "";
        }
    }
}

