/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientCertificateCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientSecretCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.DefaultAzureCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.ManagedIdentityCredentialBuilder;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.server.FMApp;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class AzureUtils {
    public static final String NAME_TAG_KEY = "Name";

    public static Map<String, String> getTagsWithName(@Nonnull String resourceName, CloudTagList tags) {
        return tags.with(NAME_TAG_KEY, resourceName).asMap();
    }

    public static TokenCredential getManagedIdentityCredentials(String managedIdentityId) {
        return new ManagedIdentityCredentialBuilder().resourceId(managedIdentityId).build();
    }

    public static TokenCredential getDefaultManagedIdentityCredentials() {
        return new DefaultAzureCredentialBuilder().authorityHost(AzureUtils.getAzureEnvironment().getActiveDirectoryEndpoint()).build();
    }

    public static TokenCredential getSecretCredentials(String clientId, String domain, String secret) {
        return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(domain)).authorityHost("https://login.microsoftonline.com/")).build();
    }

    public static TokenCredential getCertificateCredentials(String clientId, String domain, String certificatePath, String certificatePassword) {
        return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(clientId)).tenantId(domain)).pemCertificate(certificatePath).clientCertificatePassword(certificatePassword).build();
    }

    public static AzureEnvironment getAzureEnvironment() {
        String environment = FMApp.getFMSettingsUnsafe().azureSettings.environment;
        if (environment == null) {
            return AzureEnvironment.AZURE;
        }
        switch (environment.toUpperCase()) {
            case "AZURE_CHINA": {
                return AzureEnvironment.AZURE_CHINA;
            }
            case "AZURE_GERMANY": {
                return AzureEnvironment.AZURE_GERMANY;
            }
            case "AZURE_US_GOVERNMENT": {
                return AzureEnvironment.AZURE_US_GOVERNMENT;
            }
        }
        return AzureEnvironment.AZURE;
    }

    public static String getResourceGroupForCreatedResources(VirtualNetwork vn) {
        return StringUtils.defaultIfBlank((String)vn.getAzureRgNameForCreatedResources(), (String)vn.getAzureRgName());
    }
}

