/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure.sdk;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.AzureResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFirewallMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayOperationalState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedServiceIdentityUserAssignedIdentities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIPSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ResourceIdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasName;
import com.dataiku.fm.cloud.azure.AzureCloudLoadBalancerService;
import com.dataiku.fm.model.db.AzureLoadbalancerTier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class AzureResourceManagerWrapper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.azure.loadbalancer");
    private final AzureResourceManager resourceManager;

    public AzureResourceManagerWrapper(AzureResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public String getInstancePrivateIp(String instanceId) {
        return ((VirtualMachine)this.resourceManager.virtualMachines().getById(instanceId)).getPrimaryNetworkInterface().primaryIPConfiguration().privateIpAddress();
    }

    public Map<String, BackendWrapper> getBackends(String applicationGatewayId) {
        return ((ApplicationGateway)this.resourceManager.applicationGateways().getById(applicationGatewayId)).backends().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new BackendWrapper()));
    }

    public void updateApplicationGateway(String applicationGatewayId, Set<Resource> resources, Predicate<HasName> isManagedPredicate, String publicIpId, boolean areNodesHttps, CertificateConfiguration certificateConfiguration) {
        ApplicationGateway applicationGateway = (ApplicationGateway)this.resourceManager.applicationGateways().getById(applicationGatewayId);
        ApplicationGateway.Update update = (ApplicationGateway.Update)applicationGateway.update();
        this.computeActions(applicationGateway, resources, isManagedPredicate, publicIpId, areNodesHttps, certificateConfiguration).forEach(action -> action.apply(update));
        update.apply();
    }

    public void updateApplicationGatewayBackends(String applicationGatewayId, Set<Resource> resources, Predicate<HasName> isManagedPredicate) {
        ApplicationGateway applicationGateway = (ApplicationGateway)this.resourceManager.applicationGateways().getById(applicationGatewayId);
        ApplicationGateway.Update update = (ApplicationGateway.Update)applicationGateway.update();
        Set<String> desiredResourceIds = resources.stream().map(Resource::id).collect(Collectors.toSet());
        List<Action> actionList = AzureResourceManagerWrapper.computeBackendActions(applicationGateway, resources, isManagedPredicate, desiredResourceIds).toList();
        if (!actionList.isEmpty()) {
            actionList.forEach(action -> action.apply(update));
            update.apply();
        }
    }

    public StatusCheckResult generateMessagesForStatusCheck(String applicationGatewayId, Set<Resource> resources, Predicate<HasName> isManagedPredicate, String publicIpId, boolean areNodesHttps, CertificateConfiguration certificateConfiguration) {
        ApplicationGateway applicationGateway = (ApplicationGateway)this.resourceManager.applicationGateways().getById(applicationGatewayId);
        return this.computeActions(applicationGateway, resources, isManagedPredicate, publicIpId, areNodesHttps, certificateConfiguration).stream().map(Action::buildStatusCheckResult).reduce(StatusCheckResult.noAction(), StatusCheckResult::merge);
    }

    private List<Action> computeActions(ApplicationGateway applicationGateway, Set<Resource> resources, Predicate<HasName> isManagedPredicate, String publicIpId, boolean areNodesHttps, CertificateConfiguration certificateConfiguration) {
        Set<String> desiredResourceIds = resources.stream().map(Resource::id).collect(Collectors.toSet());
        Optional<ApplicationGatewaySslCertificate> applicationGatewaySslCertificateOptional = Optional.ofNullable((ApplicationGatewaySslCertificate)applicationGateway.sslCertificates().get(certificateConfiguration.name));
        Stream certificateActions = certificateConfiguration.keyVaultSecretId.map(keyVaultSecretId -> applicationGatewaySslCertificateOptional.map(applicationGatewaySslCertificate -> Stream.of(new UpdateCertificateAction((ApplicationGatewaySslCertificate)applicationGatewaySslCertificate, certificateConfiguration.name, (String)keyVaultSecretId))).orElseGet(() -> Stream.of(new AssignCertificateAction(certificateConfiguration.name, (String)keyVaultSecretId)))).orElse(applicationGatewaySslCertificateOptional.isPresent() ? Stream.of(new UnassignCertificateAction(certificateConfiguration.name)) : Stream.empty());
        Map existingListenersMap = applicationGateway.listeners();
        Stream<Action> deleteListenerActions = existingListenersMap.entrySet().stream().filter(entry -> !desiredResourceIds.contains(entry.getKey()) && isManagedPredicate.test((HasName)entry.getValue())).map(entry -> new DeleteListenerAction((String)entry.getKey()));
        Optional certificateNameOptional = certificateConfiguration.keyVaultSecretId.isPresent() ? Optional.of(certificateConfiguration.name) : Optional.empty();
        Stream<Action> createAndUpdateListenerActions = resources.stream().map(resource -> {
            String listenerId = resource.id;
            return Optional.ofNullable((ApplicationGatewayListener)existingListenersMap.get(listenerId)).map(listener -> new UpdateListenerAction((ApplicationGatewayListener)listener, (Resource)resource, certificateNameOptional)).orElseGet(() -> new CreateListenerAction((Resource)resource, certificateNameOptional));
        });
        Map existingBackendConfigs = applicationGateway.backendHttpConfigurations();
        Stream<Action> deleteBackendConfigActions = existingBackendConfigs.entrySet().stream().filter(entry -> !desiredResourceIds.contains(entry.getKey()) && isManagedPredicate.test((HasName)entry.getValue())).map(entry -> new DeleteBackendConfigAction((String)entry.getKey()));
        Stream<Action> createAndUpdateBackendConfigActions = resources.stream().map(resource -> {
            String backendConfigId = resource.id;
            return Optional.ofNullable((ApplicationGatewayBackendHttpConfiguration)existingBackendConfigs.get(backendConfigId)).map(backendConfig -> new UpdateBackendConfigAction((ApplicationGatewayBackendHttpConfiguration)backendConfig, (Resource)resource, areNodesHttps)).orElseGet(() -> new CreateBackendConfigAction((Resource)resource, areNodesHttps));
        });
        Map existingRulesMap = applicationGateway.requestRoutingRules();
        Stream<Action> deleteRulesActions = existingRulesMap.entrySet().stream().filter(entry -> !desiredResourceIds.contains(entry.getKey()) && isManagedPredicate.test((HasName)entry.getValue())).map(entry -> new DeleteRuleAction((String)entry.getKey()));
        Stream<Action> createRuleActions = resources.stream().filter(resource -> {
            String ruleId = resource.id;
            return !existingRulesMap.containsKey(ruleId);
        }).map(CreateRuleAction::new);
        return Stream.of(Stream.of(new UpdatePublicIpAction(applicationGateway, publicIpId)), certificateActions, deleteListenerActions, createAndUpdateListenerActions, deleteBackendConfigActions, createAndUpdateBackendConfigActions, deleteRulesActions, createRuleActions, AzureResourceManagerWrapper.computeBackendActions(applicationGateway, resources, isManagedPredicate, desiredResourceIds)).flatMap(Function.identity()).toList();
    }

    private static Stream<Action> computeBackendActions(ApplicationGateway applicationGateway, Set<Resource> resources, Predicate<HasName> isManagedPredicate, Set<String> desiredResourceIds) {
        Map existingBackendsMap = applicationGateway.backends();
        return Stream.of(existingBackendsMap.entrySet().stream().filter(entry -> !desiredResourceIds.contains(entry.getKey()) && isManagedPredicate.test((HasName)entry.getValue())).map(entry -> new DeleteBackendAction((String)entry.getKey())), resources.stream().map(resource -> {
            String backendId = resource.id;
            return Optional.ofNullable((ApplicationGatewayBackend)existingBackendsMap.get(backendId)).map(backend -> {
                Set<String> currentIps = backend.addresses().stream().map(ApplicationGatewayBackendAddress::ipAddress).collect(Collectors.toSet());
                return new UpdateBackendAction((Resource)resource, currentIps);
            }).orElseGet(() -> new CreateBackendAction((Resource)resource));
        })).flatMap(Function.identity());
    }

    public PublicIpAddressWrapper createPublicIpAddress(String id, String region, String resourceGroup, Map<String, String> tags) {
        PublicIpAddress publicIpAddress = (PublicIpAddress)((PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.resourceManager.publicIpAddresses().define(id)).withRegion(region)).withExistingResourceGroup(resourceGroup)).withSku(PublicIPSkuType.STANDARD).withStaticIP().withTags(tags)).create();
        return new PublicIpAddressWrapper(publicIpAddress.id(), publicIpAddress.ipAddress(), publicIpAddress.name());
    }

    public PublicIpAddressWrapper getPublicIpAddress(String id) {
        PublicIpAddress publicIpAddress = (PublicIpAddress)this.resourceManager.publicIpAddresses().getById(id);
        return new PublicIpAddressWrapper(publicIpAddress.id(), publicIpAddress.ipAddress(), publicIpAddress.name());
    }

    @Nullable
    public ApplicationGatewayWrapper getApplicationGateway(String applicationGatewayId) {
        return this.buildWrapper((ApplicationGateway)this.resourceManager.applicationGateways().getById(applicationGatewayId));
    }

    public ApplicationGatewayWrapper createApplicationGateway(String id, String region, String resourceGroup, String virtualNetworkId, String subnetName, String managedIdentityId, Map<String, String> tags, AzureLoadbalancerTier loadBalancerTier, Set<Resource> resources, String publicIpId, boolean areNodeHttps, CertificateConfiguration certificateConfiguration) {
        return this.buildWrapper(new AzureGatewayBuilder(id, region, resourceGroup, virtualNetworkId, subnetName, managedIdentityId, tags, loadBalancerTier, resources, publicIpId, areNodeHttps, certificateConfiguration).build(this.resourceManager));
    }

    @Nullable
    private ApplicationGatewayWrapper buildWrapper(ApplicationGateway applicationGateway) {
        if (applicationGateway == null) {
            return null;
        }
        return new ApplicationGatewayWrapper(applicationGateway.id(), applicationGateway.name(), applicationGateway.defaultPublicFrontend().getPublicIpAddress().ipAddress(), applicationGateway.operationalState(), applicationGateway.networkId());
    }

    public record CertificateConfiguration(String name, Optional<String> keyVaultSecretId) {
    }

    public record StatusCheckResult(ReconciliationAction reconciliationAction, List<InfoMessage> messages) {
        static StatusCheckResult noAction() {
            return new StatusCheckResult(ReconciliationAction.NO_ACTION, List.of());
        }

        static StatusCheckResult update(InfoMessage message) {
            return new StatusCheckResult(ReconciliationAction.UPDATE, List.of(message));
        }

        static StatusCheckResult update(List<InfoMessage> messages) {
            return new StatusCheckResult(messages.isEmpty() ? ReconciliationAction.NO_ACTION : ReconciliationAction.UPDATE, messages);
        }

        static StatusCheckResult reprovision(InfoMessage message) {
            return new StatusCheckResult(ReconciliationAction.REPROVISION, List.of(message));
        }

        public boolean isNoAction() {
            return this.reconciliationAction == ReconciliationAction.NO_ACTION;
        }

        StatusCheckResult merge(StatusCheckResult another) {
            return new StatusCheckResult(ReconciliationAction.returnHighestPriority(this.reconciliationAction, another.reconciliationAction), Stream.concat(this.messages.stream(), another.messages.stream()).toList());
        }
    }

    private record UnassignCertificateAction(String certificateName) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            update.withoutSslCertificate(this.certificateName);
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Certificate %s should be unassigned.", this.certificateName));
        }
    }

    private record UpdatePublicIpAction(ApplicationGateway applicationGateway, String publicIpId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            this.buildStatusCheckResult().messages.stream().findAny().ifPresent(infoMessage -> {
                throw new IllegalStateException(infoMessage.details);
            });
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            String currentPublicIpId = this.applicationGateway.defaultPublicFrontend().publicIpAddressId();
            return this.publicIpId.equals(currentPublicIpId) ? StatusCheckResult.noAction() : StatusCheckResult.reprovision(this.buildMessage("This can only be fixed via reprovisioning, not via update: Application Gateway has Public IP ID %s instead of %s.", currentPublicIpId, this.publicIpId));
        }
    }

    public record PublicIpAddressWrapper(String id, String ipAddress, String name) {
    }

    public record ApplicationGatewayWrapper(String id, String name, String ipAddress, ApplicationGatewayOperationalState operationalState, String networkId) {
    }

    private static class AzureGatewayBuilder {
        private final String id;
        private final String region;
        private final String resourceGroup;
        private final String virtualNetworkId;
        private final String subnetName;
        private final String managedIdentityId;
        private final Map<String, String> tags;
        private final AzureLoadbalancerTier loadBalancerTier;
        private final Set<Resource> resources;
        private final String publicIpId;
        private final boolean areNodeHttps;
        private final CertificateConfiguration certificateConfiguration;

        public AzureGatewayBuilder(String id, String region, String resourceGroup, String virtualNetworkId, String subnetName, String managedIdentityId, Map<String, String> tags, AzureLoadbalancerTier loadBalancerTier, Set<Resource> resources, String publicIpId, boolean areNodeHttps, CertificateConfiguration certificateConfiguration) {
            this.id = id;
            this.region = region;
            this.resourceGroup = resourceGroup;
            this.virtualNetworkId = virtualNetworkId;
            this.subnetName = subnetName;
            this.managedIdentityId = managedIdentityId;
            this.tags = tags;
            this.loadBalancerTier = loadBalancerTier;
            this.resources = resources;
            this.publicIpId = publicIpId;
            this.areNodeHttps = areNodeHttps;
            this.certificateConfiguration = certificateConfiguration;
        }

        private static <T, R> Function<T, R> chain(Function<T, R> first) {
            return first;
        }

        public ApplicationGateway build(AzureResourceManager azureResourceManager) {
            return AzureGatewayBuilder.chain(this::setupGateway).andThen(this::setupRules).andThen(this::setupListeners).andThen(this::setupBackends).andThen(this::setupCertificate).andThen(this::setupIp).andThen(this::createGateway).apply(azureResourceManager);
        }

        private ApplicationGateway.DefinitionStages.WithRequestRoutingRule setupGateway(AzureResourceManager azureResourceManager) {
            return (ApplicationGateway.DefinitionStages.WithRequestRoutingRule)((ApplicationGateway.DefinitionStages.WithGroup)((ApplicationGateway.DefinitionStages.Blank)azureResourceManager.applicationGateways().define(this.id)).withRegion(this.region)).withExistingResourceGroup(this.resourceGroup);
        }

        private ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate setupRules(ApplicationGateway.DefinitionStages.WithRequestRoutingRule withRequestRoutingRule) {
            ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate attach = null;
            for (Resource resource : this.resources) {
                String ruleId = resource.id;
                logger.info((Object)("Creating rule '" + ruleId + "'"));
                attach = (ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate)(attach == null ? withRequestRoutingRule.defineRequestRoutingRule(ruleId) : attach.defineRequestRoutingRule(ruleId)).fromListener(resource.id).toBackendHttpConfiguration(resource.id).toBackend(resource.id).attach();
            }
            return attach;
        }

        private ApplicationGateway.DefinitionStages.WithCreate setupListeners(ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate withRequestRoutingRuleOrCreate) {
            logger.info((Object)"Defines listeners");
            ApplicationGateway.DefinitionStages.WithCreate withCreate = null;
            for (Resource resource : this.resources) {
                String listenerId = resource.id;
                logger.info((Object)("Creating listener '" + listenerId + "'"));
                String hostname = resource.fqdn;
                if (this.certificateConfiguration.keyVaultSecretId.isEmpty()) {
                    withCreate = (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayListener.DefinitionStages.WithAttach)(withCreate == null ? withRequestRoutingRuleOrCreate.defineListener(listenerId) : withCreate.defineListener(listenerId)).withPublicFrontend().withFrontendPort(80).withHttp().withHostname(hostname)).attach();
                    continue;
                }
                withCreate = (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayListener.DefinitionStages.WithAttach)((ApplicationGatewayListener.DefinitionStages.WithAttach)(withCreate == null ? withRequestRoutingRuleOrCreate.defineListener(listenerId) : withCreate.defineListener(listenerId)).withPublicFrontend().withFrontendPort(443).withHttps().withSslCertificate(this.certificateConfiguration.name)).withHostname(hostname)).attach();
            }
            return withCreate;
        }

        private ApplicationGateway.DefinitionStages.WithCreate setupBackends(ApplicationGateway.DefinitionStages.WithCreate withCreate) {
            logger.info((Object)"Defines backend");
            for (Resource resource : this.resources) {
                String backendConfigId = resource.id;
                logger.info((Object)("Creating backend config '" + backendConfigId + "'"));
                withCreate = this.areNodeHttps ? (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayBackendHttpConfiguration.DefinitionStages.WithAttach)withCreate.defineBackendHttpConfiguration(backendConfigId).withPort(443)).withHttps().withCookieBasedAffinity().attach() : (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayBackendHttpConfiguration.DefinitionStages.WithAttach)withCreate.defineBackendHttpConfiguration(backendConfigId).withPort(80)).withCookieBasedAffinity().attach();
                for (String privateIp : resource.privateIps) {
                    withCreate = (ApplicationGateway.DefinitionStages.WithCreate)withCreate.defineBackend(resource.id).withIPAddress(privateIp).attach();
                }
            }
            return withCreate;
        }

        private ApplicationGateway.DefinitionStages.WithCreate setupCertificate(ApplicationGateway.DefinitionStages.WithCreate withCreate) {
            return this.certificateConfiguration.keyVaultSecretId.map(keyVaultSecretId -> (ApplicationGateway.DefinitionStages.WithCreate)withCreate.defineSslCertificate(this.certificateConfiguration.name).withKeyVaultSecretId(keyVaultSecretId).attach()).orElse(withCreate);
        }

        private ApplicationGateway.DefinitionStages.WithCreate setupIp(ApplicationGateway.DefinitionStages.WithCreate withCreate) {
            return (ApplicationGateway.DefinitionStages.WithCreate)withCreate.withExistingPublicIpAddress(this.publicIpId);
        }

        private ApplicationGateway createGateway(ApplicationGateway.DefinitionStages.WithCreate withCreate) {
            ManagedServiceIdentity managedServiceIdentity = new ManagedServiceIdentity().withType(ResourceIdentityType.USER_ASSIGNED).withUserAssignedIdentities(Map.of(this.managedIdentityId, new ManagedServiceIdentityUserAssignedIdentities()));
            logger.info((Object)("Creating gateway of tier '" + String.valueOf((Object)this.loadBalancerTier) + "'"));
            switch (this.loadBalancerTier) {
                case WAF_V2: {
                    withCreate = withCreate.withTier(ApplicationGatewayTier.WAF_V2).withSize(ApplicationGatewaySkuName.WAF_V2).withWebApplicationFirewall(true, ApplicationGatewayFirewallMode.PREVENTION);
                    break;
                }
                default: {
                    withCreate = withCreate.withTier(ApplicationGatewayTier.STANDARD_V2).withSize(ApplicationGatewaySkuName.STANDARD_V2);
                }
            }
            return (ApplicationGateway)((ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGateway.DefinitionStages.WithCreate)withCreate.withInstanceCount(1).withIdentity(managedServiceIdentity).withTags(this.tags)).withExistingSubnet(this.virtualNetworkId, this.subnetName)).create();
        }
    }

    public record Resource(String id, String fqdn, Set<String> privateIps) {
    }

    private static interface Action {
        public void apply(ApplicationGateway.Update var1);

        public StatusCheckResult buildStatusCheckResult();

        default public InfoMessage buildMessage(String message, Object ... args) {
            return new InfoMessage(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)AzureCloudLoadBalancerService.LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, String.format(message, args));
        }
    }

    private record CreateBackendAction(Resource resource) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            String backendId = this.resource.id;
            ApplicationGatewayBackend.UpdateDefinitionStages.Blank withAttach = update.defineBackend(backendId);
            this.resource.privateIps.forEach(arg_0 -> ((ApplicationGatewayBackend.UpdateDefinitionStages.WithAttach)withAttach).withIPAddress(arg_0));
            withAttach.attach();
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Backend Pool %s is not defined.", this.resource.id));
        }
    }

    private record UpdateBackendAction(Resource resource, Set<String> currentIps) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            String backendId = this.resource.id;
            ApplicationGatewayBackend.Update updateBackend = update.updateBackend(backendId);
            Set<String> desiredIps = this.resource.privateIps;
            this.currentIps.stream().filter(currentIp -> !desiredIps.contains(currentIp)).forEach(arg_0 -> ((ApplicationGatewayBackend.Update)updateBackend).withoutIPAddress(arg_0));
            desiredIps.stream().filter(desiredIp -> !this.currentIps.contains(desiredIp)).forEach(arg_0 -> ((ApplicationGatewayBackend.Update)updateBackend).withIPAddress(arg_0));
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            String backendId = this.resource.id;
            Set<String> desiredIps = this.resource.privateIps;
            List<InfoMessage> infoMessageList = Stream.of(this.currentIps.stream().filter(currentIp -> !desiredIps.contains(currentIp)).map(ipToDeleted -> this.buildMessage("IP %s in Backend Pool %s should be removed.", ipToDeleted, backendId)), desiredIps.stream().filter(desiredIp -> !this.currentIps.contains(desiredIp)).map(ipToBeAdded -> this.buildMessage("IP %s should be added to Backend Pool %s.", ipToBeAdded, backendId))).flatMap(Function.identity()).toList();
            return StatusCheckResult.update(infoMessageList);
        }
    }

    private record DeleteBackendAction(String backendId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            update.withoutBackend(this.backendId);
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Backend Pool %s should be deleted.", this.backendId));
        }
    }

    private record DeleteRuleAction(String ruleId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            update.withoutRequestRoutingRule(this.ruleId);
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Routing Rule %s should be deleted", this.ruleId));
        }
    }

    private record CreateBackendConfigAction(Resource resource, boolean areNodeHttps) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            String backendConfigId = this.resource.id;
            if (this.areNodeHttps) {
                ((ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.WithAttach)update.defineBackendHttpConfiguration(backendConfigId).withPort(443)).withCookieBasedAffinity().withHttps().attach();
            } else {
                ((ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.WithAttach)update.defineBackendHttpConfiguration(backendConfigId).withPort(80)).withCookieBasedAffinity().attach();
            }
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Backend configuration %s is not defined.", this.resource.id));
        }
    }

    private record UpdateBackendConfigAction(ApplicationGatewayBackendHttpConfiguration backendHttpConfiguration, Resource resource, boolean areNodesHttps) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            if (this.buildStatusCheckResult().messages.stream().findAny().isEmpty()) {
                return;
            }
            String backendConfigId = this.resource.id;
            ApplicationGatewayBackendHttpConfiguration.Update updateBackendConfig = update.updateBackendHttpConfiguration(backendConfigId);
            if (this.areNodesHttps) {
                ((ApplicationGatewayBackendHttpConfiguration.Update)updateBackendConfig.withPort(443)).withCookieBasedAffinity().withHttps();
            } else {
                ((ApplicationGatewayBackendHttpConfiguration.Update)updateBackendConfig.withPort(80)).withCookieBasedAffinity().withHttp();
            }
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            String backendConfigId = this.resource.id;
            int desiredPort = this.areNodesHttps ? 443 : 80;
            ApplicationGatewayProtocol desiredProtocol = this.areNodesHttps ? ApplicationGatewayProtocol.HTTPS : ApplicationGatewayProtocol.HTTP;
            List<InfoMessage> infoMessageList = Stream.of(desiredPort == this.backendHttpConfiguration.port() ? Stream.empty() : Stream.of(this.buildMessage("Backend Configuration %s has port %s instead of %s.", backendConfigId, this.backendHttpConfiguration.port(), desiredPort)), desiredProtocol == this.backendHttpConfiguration.protocol() ? Stream.empty() : Stream.of(this.buildMessage("Backend Configuration %s has protocol %s instead of %s.", backendConfigId, this.backendHttpConfiguration.protocol(), desiredProtocol))).flatMap(Function.identity()).toList();
            return StatusCheckResult.update(infoMessageList);
        }
    }

    private record DeleteBackendConfigAction(String backendConfigId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            update.withoutBackendHttpConfiguration(this.backendConfigId);
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Backend Configuration %s should be deleted.", this.backendConfigId));
        }
    }

    private record CreateListenerAction(Resource resource, Optional<String> certificateNameOptional) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            String listenerId = this.resource.id;
            this.certificateNameOptional.ifPresentOrElse(certificateName -> ((ApplicationGatewayListener.UpdateDefinitionStages.WithAttach)((ApplicationGatewayListener.UpdateDefinitionStages.WithAttach)update.defineListener(listenerId).withPublicFrontend().withFrontendPort(443).withHttps().withSslCertificate(certificateName)).withHostname(this.resource.fqdn)).attach(), () -> ((ApplicationGatewayListener.UpdateDefinitionStages.WithAttach)update.defineListener(listenerId).withPublicFrontend().withFrontendPort(80).withHttp().withHostname(this.resource.fqdn)).attach());
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Listener %s is not defined.", this.resource.id));
        }
    }

    private record UpdateListenerAction(ApplicationGatewayListener listener, Resource resource, Optional<String> certificateNameOptional) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            if (this.buildStatusCheckResult().isNoAction()) {
                return;
            }
            String listenerId = this.resource.id;
            ApplicationGatewayListener.Update updateListener = update.updateListener(listenerId);
            this.certificateNameOptional.ifPresentOrElse(certificateName -> ((ApplicationGatewayListener.Update)updateListener.withPublicFrontend().withFrontendPort(443).withHttps().withSslCertificate(certificateName)).withHostname(this.resource.fqdn), () -> updateListener.withPublicFrontend().withFrontendPort(80).withHttp().withHostname(this.resource.fqdn));
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            String listenerId = this.resource.id;
            int desiredPort = this.certificateNameOptional.isEmpty() ? 80 : 443;
            Optional<String> currentCertificateNameOptional = Optional.ofNullable((ApplicationGatewaySslCertificate)this.listener.sslCertificate()).map(HasName::name);
            String desiredHostname = this.resource.fqdn;
            ApplicationGatewayProtocol desiredProtocol = this.certificateNameOptional.isEmpty() ? ApplicationGatewayProtocol.HTTP : ApplicationGatewayProtocol.HTTPS;
            List<InfoMessage> infoMessageList = Stream.of(desiredPort == this.listener.frontendPortNumber() ? Stream.empty() : Stream.of(this.buildMessage("Listener %s has port %s instead of %s.", listenerId, this.listener.frontendPortNumber(), desiredPort)), desiredProtocol == this.listener.protocol() ? Stream.empty() : Stream.of(this.buildMessage("Listener %s has protocol %s instead of %s.", listenerId, this.listener.protocol(), desiredProtocol)), this.certificateNameOptional.equals(currentCertificateNameOptional) ? Stream.empty() : Stream.of(this.buildMessage("Listener %s has certificate %s instead of %s.", listenerId, currentCertificateNameOptional.orElse("None"), this.certificateNameOptional.orElse("None"))), desiredHostname.equals(this.listener.hostname()) ? Stream.empty() : Stream.of(this.buildMessage("Listener %s has hostname %s instead of %s.", listenerId, this.listener.hostname(), desiredHostname))).flatMap(Function.identity()).toList();
            return StatusCheckResult.update(infoMessageList);
        }
    }

    private record DeleteListenerAction(String listenerId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            update.withoutListener(this.listenerId);
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Listener %s should be removed.", this.listenerId));
        }
    }

    private record AssignCertificateAction(String certificateName, String keyVaultSecretId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            update.defineSslCertificate(this.certificateName).withKeyVaultSecretId(this.keyVaultSecretId).attach();
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Certificate %s is not assigned.", this.certificateName));
        }
    }

    private record UpdateCertificateAction(ApplicationGatewaySslCertificate applicationGatewaySslCertificate, String certificateName, String keyVaultSecretId) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            this.buildStatusCheckResult().messages.stream().findAny().ifPresent(infoMessage -> {
                throw new IllegalStateException(infoMessage.details);
            });
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return !this.applicationGatewaySslCertificate.keyVaultSecretId().equals(this.keyVaultSecretId) ? StatusCheckResult.reprovision(this.buildMessage("This can only be fixed via reprovisioning, not via update: certificate %s is not associate with secret id %s.", this.certificateName, this.keyVaultSecretId)) : StatusCheckResult.noAction();
        }
    }

    public record BackendWrapper() {
    }

    private record CreateRuleAction(Resource resource) implements Action
    {
        @Override
        public void apply(ApplicationGateway.Update update) {
            String ruleId = this.resource.id;
            String listenerId = this.resource.id;
            String backendConfigurationId = this.resource.id;
            String backendId = this.resource.id;
            update.defineRequestRoutingRule(ruleId).fromListener(listenerId).toBackendHttpConfiguration(backendConfigurationId).toBackend(backendId).attach();
        }

        @Override
        public StatusCheckResult buildStatusCheckResult() {
            return StatusCheckResult.update(this.buildMessage("Routing Rule %s is not defined.", this.resource.id));
        }
    }

    public static enum ReconciliationAction {
        NO_ACTION(0),
        UPDATE(1),
        REPROVISION(2);

        final int priority;

        private ReconciliationAction(int priority) {
            this.priority = priority;
        }

        static ReconciliationAction returnHighestPriority(ReconciliationAction reconciliationAction1, ReconciliationAction reconciliationAction2) {
            if (reconciliationAction1.priority > reconciliationAction2.priority) {
                return reconciliationAction1;
            }
            return reconciliationAction2;
        }
    }
}

