/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.Compute;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.ComputeRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Operation;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Zone;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.FMSettings;
import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GCPUtils {
    public static String getRegionOfZone(String projectId, String zone, Compute apiClient) throws InterruptedException, IOException, GeneralSecurityException {
        Zone zoneInfo = (Zone)apiClient.zones().get(projectId, zone).execute();
        String regionSelfLink = zoneInfo.getRegion();
        Pattern regionSelfLinkPattern = Pattern.compile(".*/([^/]+)/?");
        Matcher regionSelfLinkMatcher = regionSelfLinkPattern.matcher(regionSelfLink);
        if (regionSelfLinkMatcher.matches()) {
            return regionSelfLinkMatcher.group(1);
        }
        throw new IllegalArgumentException("Unable to find region for zone " + zone);
    }

    private static String getLastWordFromUrl(String url) {
        if (url != null) {
            String[] bits = url.split("/");
            url = bits[bits.length - 1];
        }
        return url;
    }

    public static Operation waitForOperation(ComputeRequest<Operation> computeRequest, String projectId, Compute apiClient) throws InterruptedException, IOException {
        Operation operation = (Operation)computeRequest.execute();
        String zone = GCPUtils.getLastWordFromUrl(operation.getZone());
        String region = GCPUtils.getLastWordFromUrl(operation.getRegion());
        while (operation != null && !operation.getStatus().equalsIgnoreCase("DONE")) {
            Thread.sleep(5000L);
            operation = GCPUtils.getRefresh(zone, region, projectId, apiClient, operation.getName());
        }
        return operation;
    }

    public static Operation waitForOperationOrThrow(ComputeRequest<Operation> computeRequest, String projectId, Compute apiClient) throws InterruptedException, IOException {
        Operation operation = GCPUtils.waitForOperation(computeRequest, projectId, apiClient);
        if (operation != null) {
            GCPUtils.throwIfError(operation);
        }
        return operation;
    }

    private static Operation getRefresh(String zone, String region, String projectId, Compute apiClient, String operation) throws IOException {
        if (StringUtils.isNotBlank((String)zone)) {
            Compute.ZoneOperations.Get get = apiClient.zoneOperations().get(projectId, zone, operation);
            return (Operation)get.execute();
        }
        if (StringUtils.isNotBlank((String)region)) {
            Compute.RegionOperations.Get get = apiClient.regionOperations().get(projectId, region, operation);
            return (Operation)get.execute();
        }
        Compute.GlobalOperations.Get get = apiClient.globalOperations().get(projectId, operation);
        return (Operation)get.execute();
    }

    private static void throwIfError(Operation operation) throws IOException {
        if (operation.getError() != null && operation.getError().getErrors() != null && !operation.getError().getErrors().isEmpty()) {
            List errors = operation.getError().getErrors();
            if (errors.size() == 1) {
                Operation.Error.Errors error2 = (Operation.Error.Errors)errors.get(0);
                throw new IOException("Operation failed: " + error2.getCode() + ": " + error2.getMessage());
            }
            throw new IOException("Operation failed: " + errors.stream().map(error -> " " + error.getCode() + ": " + error.getMessage()).collect(Collectors.joining(" | ")));
        }
    }

    public static String sanitizeLabel(String v) {
        if (StringUtils.isEmpty((String)v)) {
            return "";
        }
        return v.toLowerCase().replaceAll("[^a-z0-9_-]", "_");
    }

    public static String sanitizeKey(String v) {
        if (StringUtils.isEmpty((String)v)) {
            return "";
        }
        v = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, v);
        v = v.substring(0, Math.min(v.length(), 62));
        v = v.replace(":", "-");
        return v.toLowerCase().replaceAll("[^a-z0-9_-]", "_");
    }

    public static Map<String, String> fromCloudTags(CloudTagList tags) {
        return tags.stream().collect(Collectors.toMap(t -> GCPUtils.sanitizeKey(t.key), t -> GCPUtils.sanitizeLabel(t.value)));
    }

    public static String getInstanceProjectId(PhysicalInstance pi, FMSettings settings) {
        return GCPUtils.getInstanceProjectId(pi.getLogicalInstance(), settings);
    }

    public static String getInstanceProjectId(LogicalInstance li, FMSettings settings) {
        return GCPUtils.getInstanceProjectId(li.getVirtualNetwork(), li.getTenant(), settings);
    }

    public static String getInstanceProjectId(PhysicalInstance pi, Tenant tenant, FMSettings settings) {
        return GCPUtils.getInstanceProjectId(pi.getLogicalInstance(), tenant, settings);
    }

    public static String getInstanceProjectId(LogicalInstance li, Tenant tenant, FMSettings settings) {
        return GCPUtils.getInstanceProjectId(li.getVirtualNetwork(), tenant, settings);
    }

    public static String getInstanceProjectId(VirtualNetwork vn, Tenant tenant, FMSettings settings) {
        if (StringUtils.isNotBlank((String)vn.getGcpProjectIdForCreatedResources())) {
            return vn.getGcpProjectIdForCreatedResources();
        }
        if (StringUtils.isNotBlank((String)vn.getGcpProjectId())) {
            return vn.getGcpProjectId();
        }
        if (StringUtils.isNotBlank((String)vn.getCloudAccountOrVirtualCloudAccount().getGcpProjectId())) {
            return vn.getCloudAccountOrVirtualCloudAccount().getGcpProjectId();
        }
        return settings.gcpSettings.projectId;
    }

    public static String getNetworkProjectId(VirtualNetwork vn, Tenant tenant, FMSettings settings) {
        return GCPUtils.getNetworkProjectId(vn.getGcpProjectId(), tenant, settings);
    }

    public static String getNetworkProjectId(String projectId, Tenant tenant, FMSettings settings) {
        if (StringUtils.isNotBlank((String)projectId)) {
            return projectId;
        }
        if (StringUtils.isNotBlank((String)tenant.getVirtualCloudAccount(settings).getGcpProjectId())) {
            return tenant.getVirtualCloudAccount(settings).getGcpProjectId();
        }
        return settings.gcpSettings.projectId;
    }

    public static interface OperationRefresh {
        public Operation get(String var1) throws IOException;
    }
}

