/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model;

import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public class Utils {
    private Utils() {
    }

    public static <T> T getConfiguration(String configuration, Class<T> expectedConfigurationClass) {
        return (T)JSON.parse((String)configuration, expectedConfigurationClass);
    }

    public static double computePercentage(long numerator, long denominator) {
        return (double)numerator / (double)denominator * 100.0;
    }

    public static Optional<Double> computePercentage(Optional<Long> optionalNumerator, Optional<Long> optionalDenominator) {
        return optionalNumerator.flatMap(numerator -> optionalDenominator.flatMap(denominator -> denominator == 0L ? Optional.empty() : Optional.of(Utils.computePercentage(numerator, denominator))));
    }

    public static int convertMinutesInMilliseconds(int minutes) {
        return Utils.convertSecondsInMilliseconds(minutes * 60);
    }

    public static int convertSecondsInMilliseconds(int seconds) {
        return seconds * 1000;
    }

    public static Optional<AgentAPIController.HeartbeatState> parseHeartbeatState(Optional<String> optionalHeartbeatState) {
        return optionalHeartbeatState.map(heartbeatState -> (AgentAPIController.HeartbeatState)JSON.parse((String)heartbeatState, AgentAPIController.HeartbeatState.class));
    }

    public static String toPrintedTimestamp(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZonedDateTime dateTime = instant.atZone(ZoneId.systemDefault());
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static Optional<String> toPrintedDuration(Optional<Long> timestamp1, Optional<Long> timestamp2) {
        if (timestamp1.isEmpty() || timestamp2.isEmpty()) {
            return Optional.empty();
        }
        Duration duration = Duration.ofMillis(timestamp1.get() - timestamp2.get());
        long days = duration.toDays();
        long hours = duration.minusDays(days).toHours();
        long minutes = duration.minusDays(days).minusHours(hours).toMinutes();
        long seconds = duration.minusDays(days).minusHours(hours).minusMinutes(minutes).getSeconds();
        if (days > 0L) {
            return Optional.of(String.format("%dd %dh", days, hours));
        }
        if (hours > 0L) {
            return Optional.of(String.format("%dh %dm", hours, minutes));
        }
        if (minutes > 0L) {
            return Optional.of(String.format("%dm %ds", minutes, seconds));
        }
        return Optional.of(String.format("%ds", seconds));
    }
}

