/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts.checkers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.server.alerts.CheckResult;
import com.dataiku.fm.server.alerts.CheckResultStatus;
import com.dataiku.fm.server.alerts.checkers.LogicalInstanceChecker;

public class LogicalInstanceOSDiskConsumptionV1Checker
extends LogicalInstanceChecker {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checker.logicalInstanceOsDiskConsumptionV1");
    private static final String CHECK_RESULT_STANDARD_MESSAGE = "Instance %s OS disk consumption is at %.2f%%, %s %s%% threshold";
    private static final String CHECK_TYPE_DESCRIPTION = "OS disk consumption";

    @Override
    public CheckResult check(String configurationAsString, LogicalInstance logicalInstance) {
        String logicalInstanceLabel = logicalInstance.getLabel();
        Configuration configuration = (Configuration)JSON.parse((String)configurationAsString, Configuration.class);
        return this.getDiskUsagePercentage(logicalInstance, heartbeatState -> heartbeatState.osBytesUsed, heartbeatState -> heartbeatState.osBytesTotal).map(osDiskUsagePercentage -> {
            logger.debugV("Data disk usage percentage: %s ; Threshold: %s", new Object[]{osDiskUsagePercentage, configuration.threshold});
            boolean checkStatus = osDiskUsagePercentage <= (double)configuration.threshold;
            String message = String.format(CHECK_RESULT_STANDARD_MESSAGE, logicalInstanceLabel, osDiskUsagePercentage, checkStatus ? "below" : "above", configuration.threshold);
            return new CheckResult(checkStatus ? CheckResultStatus.SUCCESS : CheckResultStatus.FAILURE, logicalInstanceLabel, message);
        }).orElseGet(() -> {
            logger.warnV("Missing data from %s %s to compute %s", new Object[]{"instance", logicalInstanceLabel, CHECK_TYPE_DESCRIPTION});
            return new CheckResult(CheckResultStatus.INCONCLUSIVE, logicalInstanceLabel, String.format("Missing data from %s %s to compute %s", "instance", logicalInstanceLabel, CHECK_TYPE_DESCRIPTION));
        });
    }

    @Override
    public Class<?> getConfigurationClass() {
        return Configuration.class;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.LOGICAL_INSTANCE_OS_DISK_CONSUMPTION;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class Configuration {
        private int threshold;

        private Configuration() {
        }

        public int getThreshold() {
            return this.threshold;
        }
    }
}

