/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.Diagnosis;
import com.dataiku.fm.server.core.DiagnosisService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MaintenanceController
extends DIPInternalControllerBase {
    private static final String MAX_NUMBER_DIAGNOSES = "20";
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private DiagnosisService diagnosisService;

    @RequestMapping(value={"/api/ui/maintenance/diagnoses"}, method={RequestMethod.GET})
    public void getDiagnoses(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="20") Integer limit) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        MaintenanceController.writeJSON((HttpServletResponse)resp, this.diagnosisService.getDiagnoses().values().stream().sorted(Comparator.reverseOrder()).limit(limit.intValue()).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/api/ui/maintenance/diagnoses"}, method={RequestMethod.POST})
    public void startDiagnosis(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        MaintenanceController.writeJSON((HttpServletResponse)resp, this.diagnosisService.startDiagnosis(authCtx));
    }

    @RequestMapping(value={"/api/ui/maintenance/diagnoses/{diagnosisName}"}, method={RequestMethod.GET})
    public void getDiagnosis(HttpServletRequest req, HttpServletResponse resp, @PathVariable String diagnosisName) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Diagnosis diagnosis = this.diagnosisService.checkDiagnosisExist(diagnosisName);
        MaintenanceController.writeJSON((HttpServletResponse)resp, (Object)diagnosis);
    }

    @RequestMapping(value={"/api/ui/maintenance/diagnoses/{diagnosisName}/zip"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void downloadDiagnosis(HttpServletRequest req, HttpServletResponse resp, @PathVariable String diagnosisName) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserNoXSRF(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Diagnosis diagnosis = this.diagnosisService.checkDiagnosisExist(diagnosisName);
        String mimeType = DKUtils.probeContentTypeWithFallback((File)diagnosis.getFile());
        this.writeFileForDownload(resp, diagnosis.getFile(), mimeType, diagnosis.getFile().getName());
    }

    @RequestMapping(value={"/api/ui/maintenance/diagnoses/{diagnosisName}"}, method={RequestMethod.DELETE})
    public void deleteDiagnosis(HttpServletRequest req, HttpServletResponse resp, @PathVariable String diagnosisName) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Diagnosis diagnosis = this.diagnosisService.checkDiagnosisExist(diagnosisName);
        if (!diagnosis.getFile().delete()) {
            throw new IllegalArgumentException("Couldn't delete diagnosis.");
        }
        MaintenanceController.writeJSON((HttpServletResponse)resp, (Object)diagnosis);
    }
}

