/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudCredentialsDTO;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.security.FMPermissionsService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TenantCredentialsService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private CloudCryptoService cloudCryptoService;
    @Autowired
    private CloudAccountsService accountService;
    @Autowired
    private InstanceSettingsTemplateCRUDService istService;
    @Autowired
    private InstancesCRUDService instancesService;

    public CloudCredentialsDTO getCloudCredentialsDTO(String tenantId) throws Exception {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        CloudCredentialsDTO cloudCredentialsDTO = new CloudCredentialsDTO();
        cloudCredentialsDTO.accountId = tenant.getId();
        cloudCredentialsDTO.accountLabel = tenant.getLabel();
        CloudAccount virtualCloudAccount = tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        if (FMApp.getFMSettingsUnsafe().cloud == Cloud.AWS) {
            cloudCredentialsDTO.awsAuthenticationMode = virtualCloudAccount.getAwsAuthenticationMode();
            cloudCredentialsDTO.awsIAMRoleExternalId = virtualCloudAccount.getAwsIAMRoleExternalId();
            cloudCredentialsDTO.awsIAMRoleARN = virtualCloudAccount.getAwsIAMRoleARN();
            cloudCredentialsDTO.awsAccessKeyId = virtualCloudAccount.getAwsAccessKeyId();
            cloudCredentialsDTO.awsCMKId = tenant.getAwsCMKId();
            cloudCredentialsDTO.accountAuthenticationMode = virtualCloudAccount.getAwsAuthenticationMode().name();
        }
        if (FMApp.getFMSettingsUnsafe().cloud == Cloud.AZURE) {
            cloudCredentialsDTO.azureEnvironment = virtualCloudAccount.getAzureEnvironment();
            cloudCredentialsDTO.azureSubscription = virtualCloudAccount.getAzureSubscription();
            cloudCredentialsDTO.azureTenantId = virtualCloudAccount.getAzureTenantId();
            cloudCredentialsDTO.azureFMAppClientId = FMApp.getFMSettingsUnsafe().azureSettings.clientId;
            cloudCredentialsDTO.azureKeyVaultId = tenant.getAzureKeyVaultId();
            cloudCredentialsDTO.azureKeyName = tenant.getAzureKeyName();
            cloudCredentialsDTO.azureKeyVersion = tenant.getAzureKeyVersion();
            cloudCredentialsDTO.accountAuthenticationMode = virtualCloudAccount.getAzureAuthenticationMode().name();
        }
        if (FMApp.getFMSettingsUnsafe().cloud == Cloud.GCP) {
            cloudCredentialsDTO.gcpServiceAccountKey = virtualCloudAccount.getGcpServiceAccountKeyOrKeyPath();
            cloudCredentialsDTO.gcpProjectId = virtualCloudAccount.getGcpProjectId();
            cloudCredentialsDTO.gcpLocationId = tenant.getGcpLocationId();
            cloudCredentialsDTO.gcpKeyRing = tenant.getGcpKeyRing();
            cloudCredentialsDTO.gcpCryptoKey = tenant.getGcpCryptoKey();
            cloudCredentialsDTO.gcpCryptoKeyVersion = tenant.getGcpCryptoKeyVersion();
            cloudCredentialsDTO.accountAuthenticationMode = virtualCloudAccount.getGcpAuthenticationMode().name();
        }
        cloudCredentialsDTO.licenseMode = tenant.getLicenseMode();
        cloudCredentialsDTO.license = tenant.getLicense();
        cloudCredentialsDTO.licenseToken = tenant.getLicenseToken();
        cloudCredentialsDTO.encryptionEnabled = this.cloudCryptoService.isAbleToEncryptUsingTenantMasterKey();
        return cloudCredentialsDTO;
    }

    public InfoMessage.InfoMessages updateCloudCredentials(AuthCtx authCtx, String tenantId, CloudCredentialsDTO credentials) throws Exception {
        InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
        Tenant current = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", tenantId);
        Tenant updated = new Tenant();
        updated.setAuthenticationFromVirtualCloudAccount(current.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()));
        boolean encryptionChanged = this.encryptionChanged(current, credentials);
        this.toTenant(updated, credentials);
        if (this.cloudCryptoService.isAbleToEncrypt(updated)) {
            try {
                this.cloudCryptoService.checkEncryption(updated);
            }
            catch (Exception exc) {
                result.withError((InfoMessage.MessageCode)FMServerCodes.ERR_ENCRYPTION, exc.getMessage());
            }
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.permissionsService.checkTenantAdmin(authCtx, tenantId);
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            if (encryptionChanged) {
                this.updateAccountSecrets(rwt, tenant, updated);
                this.updateInstanceSettingsTemplates(rwt, tenant, updated);
                this.updateInstances(rwt, tenant, updated);
            }
            this.toTenant(tenant, credentials);
            rwt.getThreadEM().persist((Object)tenant);
            rwt.commit();
        }
        return result;
    }

    private void updateAccountSecrets(DatabaseAccessService.ReadWriteTransaction rwt, Tenant tenant, Tenant updated) {
        List accounts = this.dbService.getThreadEM().createQuery("SELECT account from cloudaccount account where account.tenant = ?1", CloudAccount.class).setParameter(1, (Object)tenant).getResultList();
        for (CloudAccount account : accounts) {
            if (!this.accountService.updateEncryption(account, tenant, updated)) continue;
            rwt.getThreadEM().persist((Object)account);
        }
    }

    private void updateInstanceSettingsTemplates(DatabaseAccessService.ReadWriteTransaction rwt, Tenant tenant, Tenant updated) {
        List templates = this.dbService.getThreadEM().createQuery("SELECT ist from instancesettingstemplate ist where ist.tenant = ?1", InstanceSettingsTemplate.class).setParameter(1, (Object)tenant).getResultList();
        for (InstanceSettingsTemplate template : templates) {
            if (!this.istService.updateEncryption(template, tenant, updated)) continue;
            rwt.getThreadEM().persist((Object)template);
        }
    }

    private void updateInstances(DatabaseAccessService.ReadWriteTransaction rwt, Tenant tenant, Tenant updated) {
        List instances = this.dbService.getThreadEM().createQuery("SELECT li from logicalinstance li where li.tenant = ?1", LogicalInstance.class).setParameter(1, (Object)tenant).getResultList();
        for (LogicalInstance instance : instances) {
            if (!this.instancesService.updateEncryption(instance, tenant, updated)) continue;
            rwt.getThreadEM().persist((Object)instance);
        }
    }

    private void toTenant(Tenant tenant, CloudCredentialsDTO credentials) {
        CloudAccount cloudAccount;
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        if (settings.cloud == Cloud.AWS) {
            cloudAccount = tenant.getVirtualCloudAccount(settings);
            cloudAccount.setAwsAuthenticationMode(credentials.awsAuthenticationMode);
            cloudAccount.setAwsIAMRoleExternalId(credentials.awsIAMRoleExternalId);
            cloudAccount.setAwsIAMRoleARN(credentials.awsIAMRoleARN);
            cloudAccount.setAwsAccessKeyId(credentials.awsAccessKeyId);
            cloudAccount.setAwsSecretAccessKey(credentials.awsSecretAccessKey);
            tenant.setAuthenticationFromVirtualCloudAccount(cloudAccount);
            tenant.setAwsCMKId((String)StringUtils.defaultIfEmpty((CharSequence)credentials.awsCMKId, null));
        }
        if (settings.cloud == Cloud.AZURE) {
            cloudAccount = tenant.getVirtualCloudAccount(settings);
            cloudAccount.setAzureEnvironment(credentials.azureEnvironment);
            cloudAccount.setAzureSubscription(credentials.azureSubscription);
            cloudAccount.setAzureTenantId(credentials.azureTenantId);
            cloudAccount.setAwsAccessKeyId(credentials.awsAccessKeyId);
            cloudAccount.setAwsSecretAccessKey(credentials.awsSecretAccessKey);
            tenant.setAuthenticationFromVirtualCloudAccount(cloudAccount);
            tenant.setAzureKeyVaultId((String)StringUtils.defaultIfEmpty((CharSequence)credentials.azureKeyVaultId, null));
            tenant.setAzureKeyName((String)StringUtils.defaultIfEmpty((CharSequence)credentials.azureKeyName, null));
            tenant.setAzureKeyVersion((String)StringUtils.defaultIfEmpty((CharSequence)credentials.azureKeyVersion, null));
        }
        if (settings.cloud == Cloud.GCP) {
            cloudAccount = tenant.getVirtualCloudAccount(settings);
            cloudAccount.setGcpProjectId(credentials.gcpProjectId);
            cloudAccount.setGcpServiceAccountKey(credentials.gcpServiceAccountKey);
            tenant.setAuthenticationFromVirtualCloudAccount(cloudAccount);
            tenant.setGcpLocationId((String)StringUtils.defaultIfEmpty((CharSequence)credentials.gcpLocationId, null));
            tenant.setGcpKeyRing((String)StringUtils.defaultIfEmpty((CharSequence)credentials.gcpKeyRing, null));
            tenant.setGcpCryptoKey((String)StringUtils.defaultIfEmpty((CharSequence)credentials.gcpCryptoKey, null));
            tenant.setGcpCryptoKeyVersion((String)StringUtils.defaultIfEmpty((CharSequence)credentials.gcpCryptoKeyVersion, null));
        }
        tenant.setLicenseMode(credentials.licenseMode);
        tenant.setLicense(credentials.license);
        tenant.setLicenseToken(credentials.licenseToken);
    }

    private boolean encryptionChanged(Tenant tenant, CloudCredentialsDTO credentials) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        boolean encryptionChanged = false;
        if (settings.cloud == Cloud.AWS) {
            return !Objects.equals(tenant.getAwsCMKId(), StringUtils.defaultIfEmpty((CharSequence)credentials.awsCMKId, null));
        }
        if (settings.cloud == Cloud.AZURE) {
            return !Objects.equals(tenant.getAzureKeyVaultId(), StringUtils.defaultIfEmpty((CharSequence)credentials.azureKeyVaultId, null)) || !Objects.equals(tenant.getAzureKeyName(), StringUtils.defaultIfEmpty((CharSequence)credentials.azureKeyName, null)) || !Objects.equals(tenant.getAzureKeyVersion(), StringUtils.defaultIfEmpty((CharSequence)credentials.azureKeyVersion, null));
        }
        if (settings.cloud == Cloud.GCP) {
            return !Objects.equals(tenant.getGcpLocationId(), StringUtils.defaultIfEmpty((CharSequence)credentials.gcpLocationId, null)) || !Objects.equals(tenant.getGcpKeyRing(), StringUtils.defaultIfEmpty((CharSequence)credentials.gcpKeyRing, null)) || !Objects.equals(tenant.getGcpCryptoKey(), StringUtils.defaultIfEmpty((CharSequence)credentials.gcpCryptoKey, null)) || !Objects.equals(tenant.getGcpCryptoKeyVersion(), StringUtils.defaultIfEmpty((CharSequence)credentials.gcpCryptoKeyVersion, null));
        }
        return encryptionChanged;
    }

    public CloudTagList getCloudTags(String tenantId) throws Exception {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        return CloudTagList.fromJSON(tenant.getCloudTags());
    }

    public void updateCloudTags(AuthCtx authCtx, String tenantId, CloudTagList tags) throws Exception {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.permissionsService.checkTenantAdmin(authCtx, tenantId);
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            tenant.setCloudTags(CloudTagList.toJSON(tags));
            rwt.getThreadEM().persist((Object)tenant);
            rwt.commit();
        }
    }
}

