/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.NodeType;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudCredentialsDTO;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.model.published.ProtoLoadBalancer;
import com.dataiku.fm.model.published.ProtoLoadBalancerNodeMapping;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.model.published.PublicProtoLogicalInstance;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.core.TenantCredentialsService;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.CreationDataUtils;
import com.dataiku.fm.server.instances.InstanceService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BlueprintsService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FutureServiceBase futureService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private VirtualNetworksService vnService;
    @Autowired
    private InstanceSettingsTemplateCRUDService istService;
    @Autowired
    private TenantCredentialsService tenantService;
    @Autowired
    private LoadBalancersCRUDService loadBalancersCRUDService;
    @Autowired
    private InstanceService instanceService;
    private static final String INDEX_SUFFIX = "-0";

    public FutureResponse<InfoMessage.InfoMessages> deploy(FMAuthCtx authCtx, BlueprintDeploymentRequest request) throws Exception {
        DeployThread dt = new DeployThread(authCtx, request);
        this.checkVirtualNetworkUnicity(authCtx.getTenantId(), dt.fleetNameSlugified);
        this.checkInstanceUnicity(authCtx.getTenantId(), dt.fleetNameSlugified, request.type);
        this.checkInstanceSettingsTemplateUnicity(authCtx.getTenantId(), dt.fleetNameSlugified);
        return this.futureService.runFuture((FutureThreadBase)dt, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    private void checkVirtualNetworkUnicity(String tenantId, String fleetNameSlugified) throws CodedException {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        long countExistingVNWithSameId = this.vnService.list(tenant).stream().map(e -> e.id).filter(e -> e.equalsIgnoreCase(this.getVirtualNetworkName(fleetNameSlugified))).count();
        if (countExistingVNWithSameId > 0L) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_FLEET_LABEL_DUPLICATE_RESOURCES, "The virtual network named '" + this.getVirtualNetworkName(fleetNameSlugified) + "' already exists. Please choose a different fleet name.");
        }
    }

    private void checkInstanceUnicity(String tenantId, String fleetNameSlugified, BlueprintType blueprintType) throws CodedException {
        Map<NodeType, String> names = this.getInstanceNamesFromFleetNameAndBlueprintType(fleetNameSlugified, blueprintType);
        List existingInstancesWithSameLabel = this.instancesCRUDService.listInternal(tenantId).stream().map(e -> e.getLabel()).filter(names.values()::contains).collect(Collectors.toList());
        if (existingInstancesWithSameLabel.size() > 0) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_FLEET_LABEL_DUPLICATE_RESOURCES, "The instance(s) with label '" + String.join((CharSequence)"', '", existingInstancesWithSameLabel) + "' already exist(s). Please choose a different fleet name.");
        }
    }

    private void checkInstanceSettingsTemplateUnicity(String tenantId, String fleetNameSlugified) throws CodedException {
        List existingISTWithSameId = this.istService.list(tenantId).stream().map(e -> e.id).filter(e -> e.equalsIgnoreCase(this.getISTName("main", fleetNameSlugified)) || e.equalsIgnoreCase(this.getISTName("admin", fleetNameSlugified))).collect(Collectors.toList());
        if (existingISTWithSameId.size() > 0) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_FLEET_LABEL_DUPLICATE_RESOURCES, "The instance settings template(s) named '" + String.join((CharSequence)"', '", existingISTWithSameId) + "' already exist(s). Please choose a different fleet name.");
        }
    }

    private String getVirtualNetworkName(String fleetNameSlugified) {
        return "vn-" + fleetNameSlugified;
    }

    private String getISTName(String type, String fleetNameSlugified) {
        return "ist-" + type + "-" + fleetNameSlugified;
    }

    private Map<NodeType, String> getInstanceNamesFromFleetNameAndBlueprintType(String fleetNameSlugified, BlueprintType type) {
        HashMap<NodeType, String> names = new HashMap<NodeType, String>();
        switch (type) {
            case MINIMAL_DESIGN: 
            case ELASTIC_DESIGN: {
                names.put(NodeType.DESIGN, "design-" + fleetNameSlugified);
                break;
            }
            case ELASTIC_FLEET: {
                names.put(NodeType.DESIGN, "design-" + fleetNameSlugified + INDEX_SUFFIX);
                names.put(NodeType.AUTOMATION, "execution-" + fleetNameSlugified + INDEX_SUFFIX);
                names.put(NodeType.DEPLOYER, "deployer-" + fleetNameSlugified);
                break;
            }
            case FULL_FEATURED: {
                names.put(NodeType.DESIGN, "design-" + fleetNameSlugified + INDEX_SUFFIX);
                names.put(NodeType.AUTOMATION, "execution-" + fleetNameSlugified + INDEX_SUFFIX);
                names.put(NodeType.DEPLOYER, "deployer-" + fleetNameSlugified);
                names.put(NodeType.ADMIN, "admin-" + fleetNameSlugified);
            }
        }
        return names;
    }

    public class DeployThread
    extends SimpleFMFutureThread<InfoMessage.InfoMessages> {
        private final BlueprintDeploymentRequest request;
        private final String fleetNameSlugified;
        private final String vnID;
        private final String mainISTId;
        private final String adminISTId;

        public DeployThread(FMAuthCtx owner, BlueprintDeploymentRequest request) {
            super(BlueprintsService.this.dbService, owner, "bp");
            this.request = request;
            this.fleetNameSlugified = FMApp.getFMSettingsUnsafe().cloud == Cloud.GCP ? request.name.replaceAll("[^A-Za-z0-9]", "-") : request.name.replaceAll("[^A-Za-z0-9]", "_");
            this.vnID = StringUtils.defaultIfEmpty((String)request.settings.reuseVirtualNetwork, (String)BlueprintsService.this.getVirtualNetworkName(this.fleetNameSlugified));
            this.mainISTId = BlueprintsService.this.getISTName("main", this.fleetNameSlugified);
            this.adminISTId = BlueprintsService.this.getISTName("admin", this.fleetNameSlugified);
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            this.deploy(FMApp.getFMSettingsUnsafe().cloud);
            return ret;
        }

        private void deploy(Cloud cloud) throws Exception {
            if (StringUtils.isNotBlank((String)this.request.settings.licenseToken)) {
                CloudCredentialsDTO dto = BlueprintsService.this.tenantService.getCloudCredentialsDTO(this.owner.getTenantId());
                dto.licenseMode = Tenant.LicenseMode.AUTO_UPDATE;
                dto.licenseToken = this.request.settings.licenseToken;
                BlueprintsService.this.tenantService.updateCloudCredentials(this.owner, this.owner.getTenantId(), dto);
            }
            if (StringUtils.isEmpty((String)this.request.settings.reuseVirtualNetwork)) {
                this.setupVN(cloud, this.request.type, this.request.settings);
            } else {
                VirtualNetwork vn = BlueprintsService.this.dbService.getSingleResult(VirtualNetwork.class, "SELECT vn from virtualnetwork vn where vn.id=?1", this.request.settings.reuseVirtualNetwork);
                List<LogicalInstance> instanceList = BlueprintsService.this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.virtualNetwork=?1", vn);
                if (instanceList.size() > 0) {
                    throw new IllegalStateException("Network '" + this.request.settings.reuseVirtualNetwork + "' is already used by some instances.");
                }
                this.updateVN(cloud, this.request.type, this.request.settings.reuseVirtualNetwork);
            }
            this.createDesignAutomationIST();
            HashMap<NodeType, String> instanceIds = new HashMap<NodeType, String>();
            Map<NodeType, String> names = BlueprintsService.this.getInstanceNamesFromFleetNameAndBlueprintType(this.fleetNameSlugified, this.request.type);
            switch (this.request.type) {
                case MINIMAL_DESIGN: 
                case ELASTIC_DESIGN: {
                    PublicProtoLogicalInstance designNode = this.newInstance(this.mainISTId, NodeType.DESIGN.getRef(), names.get((Object)NodeType.DESIGN), this.request.settings.azureAvailabilityZone, this.request.settings.azureDesignDataVolumeName, this.request.settings.gcpDesignDataVolumeName, this.request.settings.designHostnameMapping);
                    PublicLogicalInstance designNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), designNode);
                    instanceIds.put(NodeType.DESIGN, designNodeInstance.id);
                    break;
                }
                case ELASTIC_FLEET: {
                    PublicProtoLogicalInstance designNode = this.newInstance(this.mainISTId, NodeType.DESIGN.getRef(), names.get((Object)NodeType.DESIGN), this.request.settings.azureAvailabilityZone, this.request.settings.azureDesignDataVolumeName, this.request.settings.gcpDesignDataVolumeName, this.request.settings.designHostnameMapping);
                    PublicLogicalInstance designNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), designNode);
                    instanceIds.put(NodeType.DESIGN, designNodeInstance.id);
                    PublicProtoLogicalInstance executionNode = this.newInstance(this.mainISTId, NodeType.AUTOMATION.getRef(), names.get((Object)NodeType.AUTOMATION), this.request.settings.azureAvailabilityZone, this.request.settings.azureAutomationDataVolumeName, this.request.settings.gcpAutomationDataVolumeName, this.request.settings.automationHostnameMapping);
                    PublicLogicalInstance automationNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), executionNode);
                    instanceIds.put(NodeType.AUTOMATION, automationNodeInstance.id);
                    PublicProtoLogicalInstance deployerNode = this.newInstance(this.mainISTId, NodeType.DEPLOYER.getRef(), names.get((Object)NodeType.DEPLOYER), this.request.settings.azureAvailabilityZone, this.request.settings.azureDeployerDataVolumeName, this.request.settings.gcpDeployerDataVolumeName, this.request.settings.deployerHostnameMapping);
                    PublicLogicalInstance deployerNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), deployerNode);
                    instanceIds.put(NodeType.DEPLOYER, deployerNodeInstance.id);
                    break;
                }
                case FULL_FEATURED: {
                    PublicProtoLogicalInstance designNode = this.newInstance(this.mainISTId, NodeType.DESIGN.getRef(), names.get((Object)NodeType.DESIGN), this.request.settings.azureAvailabilityZone, this.request.settings.azureDesignDataVolumeName, this.request.settings.gcpDesignDataVolumeName, this.request.settings.designHostnameMapping);
                    PublicLogicalInstance designNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), designNode);
                    instanceIds.put(NodeType.DESIGN, designNodeInstance.id);
                    PublicProtoLogicalInstance executionNode = this.newInstance(this.mainISTId, NodeType.AUTOMATION.getRef(), names.get((Object)NodeType.AUTOMATION), this.request.settings.azureAvailabilityZone, this.request.settings.azureAutomationDataVolumeName, this.request.settings.gcpAutomationDataVolumeName, this.request.settings.automationHostnameMapping);
                    PublicLogicalInstance automationNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), executionNode);
                    instanceIds.put(NodeType.AUTOMATION, automationNodeInstance.id);
                    PublicProtoLogicalInstance deployerNode = this.newInstance(this.mainISTId, NodeType.DEPLOYER.getRef(), names.get((Object)NodeType.DEPLOYER), this.request.settings.azureAvailabilityZone, this.request.settings.azureDeployerDataVolumeName, this.request.settings.gcpDeployerDataVolumeName, this.request.settings.deployerHostnameMapping);
                    PublicLogicalInstance deployerNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), deployerNode);
                    instanceIds.put(NodeType.DEPLOYER, deployerNodeInstance.id);
                    this.createAdminIST();
                    PublicProtoLogicalInstance adminNode = this.newInstance(this.adminISTId, NodeType.DESIGN.getRef(), names.get((Object)NodeType.ADMIN), this.request.settings.azureAvailabilityZone, this.request.settings.azureAdminDataVolumeName, this.request.settings.gcpAdminDataVolumeName, this.request.settings.adminHostnameMapping);
                    PublicLogicalInstance adminNodeInstance = BlueprintsService.this.instanceService.create(this.owner.getTenantId(), adminNode);
                    instanceIds.put(NodeType.ADMIN, adminNodeInstance.id);
                    break;
                }
            }
            if (this.request.settings.deployLoadBalancer) {
                ProtoLoadBalancer loadBalancer = new ProtoLoadBalancer();
                loadBalancer.name = this.request.name;
                loadBalancer.virtualNetworkId = this.vnID;
                loadBalancer.fmTags = Stream.of("fleet-" + this.request.name).collect(Collectors.toList());
                loadBalancer.cloudTags = this.request.settings.cloudTags;
                if (this.request.settings.dnsStrategy != VirtualNetwork.DNSStrategy.NONE && cloud == Cloud.AWS) {
                    loadBalancer.certificateMode = CertificateMode.AWS_CERTIFICATE_MANAGER;
                }
                switch (this.request.type) {
                    case FULL_FEATURED: {
                        loadBalancer.nodes.add(new ProtoLoadBalancerNodeMapping(this.request.settings.adminHostnameMapping, (String)instanceIds.get((Object)NodeType.ADMIN)));
                    }
                    case ELASTIC_FLEET: {
                        loadBalancer.nodes.add(new ProtoLoadBalancerNodeMapping(this.request.settings.deployerHostnameMapping, (String)instanceIds.get((Object)NodeType.DEPLOYER)));
                        loadBalancer.nodes.add(new ProtoLoadBalancerNodeMapping(this.request.settings.automationHostnameMapping, (String)instanceIds.get((Object)NodeType.AUTOMATION)));
                    }
                    case MINIMAL_DESIGN: 
                    case ELASTIC_DESIGN: {
                        loadBalancer.nodes.add(new ProtoLoadBalancerNodeMapping(this.request.settings.designHostnameMapping, (String)instanceIds.get((Object)NodeType.DESIGN)));
                    }
                }
                BlueprintsService.this.loadBalancersCRUDService.create(this.owner.getTenantId(), loadBalancer);
            }
        }

        private PublicProtoLogicalInstance newInstance(String istId, String nodeType, String label, String azureAvailabilityZone, String azureDataVolumeName, String gcpDataVolumeName, String hostname) {
            CreationDataUtils.InstanceCreationData icd = CreationDataUtils.getInstanceCreationData(this.owner.getTenantId());
            PublicProtoLogicalInstance pli = new PublicProtoLogicalInstance();
            pli.label = label;
            pli.cloudTags = this.request.settings.cloudTags;
            pli.fmTags = Stream.of("fleet-" + this.request.name).collect(Collectors.toList());
            pli.virtualNetworkId = this.vnID;
            pli.instanceSettingsTemplateId = istId;
            pli.cloudInstanceType = icd.defaultCloudInstanceType;
            pli.imageId = icd.defaultImageId;
            pli.dataVolumeType = icd.defaultDataVolumeType;
            pli.dataVolumeSizeGB = icd.defaultDataVolumeSizeGB;
            pli.dataVolumeSizeMaxGB = icd.defaultDataVolumeSizeMaxGB;
            pli.dataVolumeIOPS = icd.defaultDataVolumeIOPS;
            pli.rootVolumeSizeGB = icd.defaultRootVolumeSizeGB;
            pli.dssNodeType = nodeType;
            if (hostname != null) {
                pli.additionalDomainNamesForCertificate = Arrays.asList(hostname);
            }
            pli.volumesEncryption = icd.defaultVolumesEncryptionMode;
            pli.azureAvailabilityZone = azureAvailabilityZone;
            pli.azureDataVolumeName = azureDataVolumeName;
            pli.gcpDataVolumeName = gcpDataVolumeName;
            return pli;
        }

        private void createDesignAutomationIST() {
            InstanceSettingsTemplateDTO ist = new InstanceSettingsTemplateDTO();
            ist.forcedID = this.mainISTId;
            ist.label = "Main IST for design/automation/deployer nodes, for fleet " + this.request.name;
            ist = BlueprintsService.this.istService.create(this.owner, this.owner.getTenantId(), ist);
            ist.setupActions = new SetupAction.SetupActionList();
            if (this.request.type != BlueprintType.MINIMAL_DESIGN) {
                SetupAction k8s = new SetupAction(SetupAction.SetupActionType.SETUP_K8S_AND_SPARK);
                ist.setupActions.add(k8s);
            }
            if (StringUtils.isNotBlank((String)this.request.settings.awsIAMRoleARN)) {
                ist.runtimeInstanceProfileArn = this.request.settings.awsIAMRoleARN;
                ist.restrictAwsMetadataServerAccess = true;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.awsKeyPairName)) {
                ist.awsKeyPairName = this.request.settings.awsKeyPairName;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.azureSshKey)) {
                ist.azureSshKey = this.request.settings.azureSshKey;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.managedIdentity)) {
                ist.runtimeManagedIdentity = this.request.settings.managedIdentity;
                ist.restrictAzureMetadataServerAccess = true;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.serviceAccount)) {
                ist.startupServiceAccount = this.request.settings.serviceAccount;
                ist.restrictGcpMetadataServerAccess = true;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.gcpSshKey)) {
                ist.gcpSshKey = this.request.settings.gcpSshKey;
            }
            BlueprintsService.this.istService.update(this.owner, this.owner.getTenantId(), ist);
        }

        private void createAdminIST() {
            InstanceSettingsTemplateDTO ist = new InstanceSettingsTemplateDTO();
            ist.forcedID = this.adminISTId;
            ist.label = "IST for admin node, for fleet " + this.request.name;
            ist = BlueprintsService.this.istService.create(this.owner, this.owner.getTenantId(), ist);
            ist.setupActions = new SetupAction.SetupActionList();
            if (this.request.type != BlueprintType.MINIMAL_DESIGN) {
                SetupAction k8s = new SetupAction(SetupAction.SetupActionType.SETUP_K8S_AND_SPARK);
                ist.setupActions.add(k8s);
            }
            if (StringUtils.isNotBlank((String)this.request.settings.awsIAMRoleARN)) {
                ist.runtimeInstanceProfileArn = this.request.settings.awsIAMRoleARN;
                ist.restrictAwsMetadataServerAccess = true;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.awsKeyPairName)) {
                ist.awsKeyPairName = this.request.settings.awsKeyPairName;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.azureSshKey)) {
                ist.azureSshKey = this.request.settings.azureSshKey;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.gcpSshKey)) {
                ist.gcpSshKey = this.request.settings.gcpSshKey;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.managedIdentity)) {
                ist.runtimeManagedIdentity = this.request.settings.managedIdentity;
                ist.restrictAzureMetadataServerAccess = true;
            }
            if (StringUtils.isNotBlank((String)this.request.settings.serviceAccount)) {
                ist.startupServiceAccount = this.request.settings.serviceAccount;
                ist.restrictGcpMetadataServerAccess = true;
            }
            BlueprintsService.this.istService.update(this.owner, this.owner.getTenantId(), ist);
        }

        private void updateVN(Cloud cloud, BlueprintType type, String vnIdentifier) throws Exception {
            Tenant tenant = (Tenant)BlueprintsService.this.dbService.getThreadEM().find(Tenant.class, (Object)this.owner.getTenantId());
            assert (tenant != null);
            VirtualNetworkSettingsDTO vn = BlueprintsService.this.vnService.getVirtualNetworkDTO(tenant, vnIdentifier);
            this.setupNodeDirectory(vn, type);
            BlueprintsService.this.vnService.saveVirtualNetwork(this.owner, tenant, vn.id, vn);
        }

        private VirtualNetworkSettingsDTO setupVN(Cloud cloud, BlueprintType type, BlueprintSettings settings) throws Exception {
            Tenant tenant = (Tenant)BlueprintsService.this.dbService.getThreadEM().find(Tenant.class, (Object)this.owner.getTenantId());
            assert (tenant != null);
            ProtoVirtualNetworkDTO protoVN = BlueprintsService.this.vnService.getDefaultCreationValues(tenant);
            protoVN.forcedID = this.vnID;
            protoVN.label = "Virtual Network for fleet " + this.request.name;
            protoVN.cloudTags = this.request.settings.cloudTags;
            protoVN.azureRgNameForCreatedResources = settings.azureRgNameForCreatedResources;
            protoVN.azureSecondSubnetId = settings.azureSecondSubnet;
            protoVN.awsSecondSubnetId = settings.awsSecondSubnet;
            this.enrichProtoVirtualNetwork(protoVN, cloud);
            VirtualNetworkSettingsDTO vn = BlueprintsService.this.vnService.createVirtualNetwork(this.owner.getTenantId(), protoVN, new DKUtils.SmartLogTailBuilder());
            vn.dnsStrategy = settings.dnsStrategy;
            vn.awsRoute53PrivateIPZoneId = settings.awsRoute53PrivateIPZoneId;
            vn.awsRoute53PublicIPZoneId = settings.awsRoute53PublicIPZoneId;
            vn.azureDnsZoneId = settings.azureDnsZoneId;
            vn.gcpCloudDnsPrivateIPZoneId = settings.gcpCloudDnsPrivateIPZoneId;
            vn.gcpCloudDnsPublicIPZoneId = settings.gcpCloudDnsPublicIPZoneId;
            vn.httpsStrategy = settings.deployLoadBalancer ? VirtualNetwork.HTTPSStrategy.NONE : VirtualNetwork.HTTPSStrategy.SELF_SIGNED;
            vn.managedNodesDirectory = true;
            boolean withDeployer = type == BlueprintType.ELASTIC_FLEET || type == BlueprintType.FULL_FEATURED;
            vn.nodesDirectoryDeployerMode = withDeployer ? VirtualNetwork.NodesDirectoryDeployerMode.CENTRAL_DEPLOYER : VirtualNetwork.NodesDirectoryDeployerMode.EACH_DESIGN_NODE;
            switch (type) {
                case MINIMAL_DESIGN: 
                case ELASTIC_DESIGN: {
                    vn.eventServerNodeLabel = "design-" + this.fleetNameSlugified;
                    break;
                }
                case ELASTIC_FLEET: {
                    vn.eventServerNodeLabel = "design-" + this.fleetNameSlugified + BlueprintsService.INDEX_SUFFIX;
                    break;
                }
                case FULL_FEATURED: {
                    vn.eventServerNodeLabel = "admin-" + this.fleetNameSlugified;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown blueprint type, I don't know where to setup the Event Server");
                }
            }
            this.enrichVirtualNetworkSettings(settings, vn, cloud);
            if (cloud == Cloud.GCP && StringUtils.isNotBlank((String)settings.gcpProjectIdForCreatedResources)) {
                vn.gcpProjectIdForCreatedResources = settings.gcpProjectIdForCreatedResources;
            }
            BlueprintsService.this.vnService.saveVirtualNetwork(this.owner, tenant, vn.id, vn);
            return vn;
        }

        private void setupNodeDirectory(VirtualNetworkSettingsDTO vn, BlueprintType type) {
            vn.managedNodesDirectory = true;
            boolean withDeployer = type == BlueprintType.ELASTIC_FLEET || type == BlueprintType.FULL_FEATURED;
            vn.nodesDirectoryDeployerMode = withDeployer ? VirtualNetwork.NodesDirectoryDeployerMode.CENTRAL_DEPLOYER : VirtualNetwork.NodesDirectoryDeployerMode.EACH_DESIGN_NODE;
            vn.eventServerNodeLabel = type == BlueprintType.FULL_FEATURED ? "admin-" + this.fleetNameSlugified : null;
        }

        private void enrichVirtualNetworkSettings(BlueprintSettings settings, VirtualNetworkSettingsDTO vn, Cloud cloud) {
            switch (cloud) {
                case AWS: {
                    vn.awsAssignPublicIP = !settings.deployLoadBalancer;
                    break;
                }
                case AZURE: {
                    vn.azureAssignPublicIP = !settings.deployLoadBalancer;
                    break;
                }
                case GCP: {
                    vn.gcpAssignPublicIP = !settings.deployLoadBalancer;
                }
            }
        }

        private void enrichProtoVirtualNetwork(ProtoVirtualNetworkDTO protoVN, Cloud cloud) {
            switch (cloud) {
                case AWS: {
                    protoVN.awsAutoCreateSecurityGroups = true;
                    break;
                }
                case AZURE: {
                    break;
                }
            }
            protoVN.autoCreatePeerings = true;
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    public static class BlueprintDeploymentRequest {
        public String name;
        public BlueprintType type;
        public BlueprintSettings settings;
    }

    public static enum BlueprintType {
        MINIMAL_DESIGN,
        ELASTIC_DESIGN,
        ELASTIC_FLEET,
        FULL_FEATURED;

    }

    public static class BlueprintSettings {
        public String licenseToken;
        private VirtualNetwork.DNSStrategy dnsStrategy;
        private String awsRoute53PrivateIPZoneId;
        private String awsRoute53PublicIPZoneId;
        private String azureDnsZoneId;
        private String gcpCloudDnsPrivateIPZoneId;
        private String gcpCloudDnsPublicIPZoneId;
        public boolean deployLoadBalancer = false;
        public String azureSecondSubnet;
        public String awsSecondSubnet;
        public String designHostnameMapping;
        public String automationHostnameMapping;
        public String deployerHostnameMapping;
        public String adminHostnameMapping;
        public String reuseVirtualNetwork;
        public String awsKeyPairName;
        public String awsIAMRoleARN;
        public String azureRgNameForCreatedResources;
        public String azureAvailabilityZone;
        public String azureSshKey;
        public String managedIdentity;
        public String azureDesignDataVolumeName;
        public String azureAdminDataVolumeName;
        public String azureAutomationDataVolumeName;
        public String azureDeployerDataVolumeName;
        public String serviceAccount;
        public String gcpProjectIdForCreatedResources;
        public String gcpDesignDataVolumeName;
        public String gcpAdminDataVolumeName;
        public String gcpAutomationDataVolumeName;
        public String gcpDeployerDataVolumeName;
        public String gcpSshKey;
        public CloudTagList cloudTags = new CloudTagList();
    }
}

