/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.licensing;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthorizationMatrixBase;
import com.dataiku.dip.server.services.licensing.LicenseLimitsParser;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.SublicenseEnforcer;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.model.published.SublicenseDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstanceService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.instances.SublicenseCRUDService;
import com.dataiku.fm.server.instances.UnsupportedAgentCommandException;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CentralLicensingStatusService {
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private InstanceAgentActionsQueueService queueService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private SublicenseCRUDService sublicensesCRUDService;
    @Autowired
    private PhysicalInstanceProvisioningService physicalInstancesService;
    @Autowired
    private InstanceService instanceService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.licensing");

    public GlobalLicensingStatus getGlobalLicensingSummary(String tenantId) {
        GlobalLicensingStatus ret = new GlobalLicensingStatus();
        ret.sublicenses = this.sublicensesCRUDService.list(tenantId);
        List<PublicLogicalInstance> instances = this.instanceService.list(tenantId);
        for (PublicLogicalInstance pli : instances) {
            InstanceLicensingStatus instanceLicensingSummary = new InstanceLicensingStatus();
            instanceLicensingSummary.instanceId = pli.id;
            instanceLicensingSummary.instanceLabel = pli.label;
            ret.perInstance.add(instanceLicensingSummary);
            instanceLicensingSummary.status = new LimitsStatusComputer.LicenseLimitsStatus();
            try {
                InstancesCRUDService.InstanceLicense instanceLicense = this.instancesCRUDService.getLicense(tenantId, pli.id);
                instanceLicensingSummary.usesSublicense = instanceLicense.usesSublicense;
                instanceLicensingSummary.sublicenseId = instanceLicense.sublicenseId;
                instanceLicensingSummary.sublicenseLabel = instanceLicense.sublicenseLabel;
                if (!StringUtils.isNotBlank((String)instanceLicense.license)) continue;
                License instanceLicenseObj = (License)JSON.parse((String)instanceLicense.license, License.class);
                LicenseStatusService.LicensingStatus ls = this.buildLicensingStatus(instanceLicenseObj);
                LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)instanceLicensingSummary.status);
                new SublicenseEnforcer(instanceLicenseObj.sublicense).restrict(instanceLicensingSummary.status);
            }
            catch (Exception e) {
                logger.info((Object)("Failed to get data from instance " + pli.id), (Throwable)e);
            }
        }
        ret.globalStatus = new LimitsStatusComputer.LicenseLimitsStatus();
        Tenant t = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (t != null);
        String globalLicense = t.getLicense();
        if (StringUtils.isBlank((String)globalLicense)) {
            ret.globalStatus = null;
        } else {
            License globalLicenseObj = (License)JSON.parse((String)globalLicense, License.class);
            LicenseStatusService.LicensingStatus ls = this.buildLicensingStatus(globalLicenseObj);
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)ret.globalStatus);
        }
        return ret;
    }

    public FutureResponse<GlobalLicensingStatus> getGlobalLicensingStatus(FMAuthCtx authCtx) throws Exception {
        return this.futureService.runFuture(new GlobalLicensingStatusThread(this.dbService, authCtx, "?"), 0L, (TypeToken)new TypeToken<FutureResponse<GlobalLicensingStatus>>(){});
    }

    private LicenseStatusService.LicensingStatus buildLicensingStatus(License license) {
        LicenseStatusService.LicensingStatus ls = new LicenseStatusService.LicensingStatus();
        ls.valid = true;
        ls.licenseContent = (License.Content)JSON.deepCopy((Object)license.content);
        if (license.sublicense != null) {
            ls.sublicense = (JsonObject)JSON.deepCopy((Object)license.sublicense);
        }
        ls.properties = ls.licenseContent.properties != null ? new Params(ls.licenseContent.properties) : new Params();
        ls.community = "true".equals(ls.licenseContent.communityEdition);
        return ls;
    }

    public static class GlobalLicensingStatus {
        public boolean hasUsageData = false;
        public boolean hasCompleteUsageData = false;
        public List<InstanceLicensingStatus> perInstance = new ArrayList<InstanceLicensingStatus>();
        public LimitsStatusComputer.LicenseLimitsStatus globalStatus;
        public List<SublicenseDTO> sublicenses = new ArrayList<SublicenseDTO>();
    }

    public static class InstanceLicensingStatus {
        String instanceId;
        String instanceLabel;
        boolean usesSublicense;
        String sublicenseId;
        String sublicenseLabel;
        SerializedError error;
        LimitsStatusComputer.LicenseLimitsStatus status;
        PerUserAuthorizationMatrix authorizationMatrix;
    }

    class GlobalLicensingStatusThread
    extends SimpleFMFutureThread<GlobalLicensingStatus> {
        public GlobalLicensingStatusThread(DatabaseAccessService dbService, FMAuthCtx owner, String prefix) {
            super(dbService, owner, prefix);
        }

        @Override
        protected GlobalLicensingStatus compute() throws Exception {
            GlobalLicensingStatus ret = new GlobalLicensingStatus();
            ret.hasUsageData = true;
            ret.hasCompleteUsageData = true;
            List<PublicLogicalInstance> instances = CentralLicensingStatusService.this.instanceService.list(this.owner.getTenantId());
            ret.sublicenses = CentralLicensingStatusService.this.sublicensesCRUDService.list(this.owner.getTenantId());
            HashMap allProfilesPerUser = new HashMap();
            HashMap allTrialProfilesPerUser = new HashMap();
            try (FutureProgress.AutocloseableFutureProgressState fps = FutureProgress.pushAutoCloseableState((String)"Fetching usage data from instances", (double)instances.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                for (PublicLogicalInstance pli : instances) {
                    logger.info((Object)("Starting to work on instance " + pli.id + " (" + pli.label + ")"));
                    FutureProgress.getState().increment(1.0);
                    if (this.isAborted()) {
                        logger.info((Object)"Usage fetch aborted, skipping remaining instances");
                        break;
                    }
                    InstanceLicensingStatus instanceLicensingStatus = new InstanceLicensingStatus();
                    instanceLicensingStatus.instanceId = pli.id;
                    instanceLicensingStatus.instanceLabel = pli.label;
                    ret.perInstance.add(instanceLicensingStatus);
                    instanceLicensingStatus.status = new LimitsStatusComputer.LicenseLimitsStatus();
                    try (FutureProgress.AutocloseableFutureProgressState fps2 = FutureProgress.pushAutoCloseableState((String)("Fetching usage data from " + pli.label));){
                        InstancesCRUDService.InstanceLicense instanceLicense = CentralLicensingStatusService.this.instancesCRUDService.getLicense(this.owner.getTenantId(), pli.id);
                        instanceLicensingStatus.usesSublicense = instanceLicense.usesSublicense;
                        instanceLicensingStatus.sublicenseId = instanceLicense.sublicenseId;
                        instanceLicensingStatus.sublicenseLabel = instanceLicense.sublicenseLabel;
                        if (StringUtils.isBlank((String)instanceLicense.license)) {
                            throw new Exception("Instance license is undefined");
                        }
                        License license = (License)JSON.parse((String)instanceLicense.license, License.class);
                        LicenseStatusService.LicensingStatus licensingStatus = CentralLicensingStatusService.this.buildLicensingStatus(license);
                        LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)licensingStatus, (LimitsStatusComputer.LicenseLimitsStatus)instanceLicensingStatus.status);
                        new SublicenseEnforcer(license.sublicense).restrict(instanceLicensingStatus.status);
                        LogicalInstance li = CentralLicensingStatusService.this.instancesCRUDService.getInternal(this.owner.getTenantId(), pli.id);
                        PhysicalInstance pi = CentralLicensingStatusService.this.physicalInstancesService.getPhysicalInstance(li);
                        if (pi == null) {
                            logger.info((Object)("Instance " + pli.id + "  is not provisioned, skipping"));
                            throw new Exception("Instance is not provisioned, cannot fetch usage details");
                        }
                        if (pi.getLifecycleStage() != PhysicalInstance.LifecycleStage.RUNNING) {
                            logger.info((Object)("Instance " + pli.id + "  is not running, skipping"));
                            throw new Exception("Instance is not fully running, cannot fetch usage details");
                        }
                        logger.info((Object)("Instance " + pli.id + " has physical instance " + pi.getId() + " aws=" + pi.getAwsEC2InstanceId()));
                        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
                        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
                        ac.type = InstanceAgentActionsQueueService.AgentCommandType.GET_USER_INFO;
                        FutureResponse<JsonObject> initial = CentralLicensingStatusService.this.queueService.enqueueAndStartWaitWithTimeout(this.owner, pli.id, ac, 30000L);
                        FutureResponse finalResp = CentralLicensingStatusService.this.futureService.waitForFinalResponse(initial);
                        UserInfoCommandResult instanceUsers = (UserInfoCommandResult)JSON.parse((String)JSON.json((Object)finalResp.result), UserInfoCommandResult.class);
                        if (instanceUsers == null) {
                            logger.info((Object)("Instance " + pli.id + " did not return licensing info"));
                            throw new UnsupportedAgentCommandException(pli.dssNodeType);
                        }
                        instanceLicensingStatus.authorizationMatrix = instanceUsers.authorizationMatrix;
                        ArrayList userProfilesOnInstance = new ArrayList();
                        ArrayList trialProfilesOnInstance = new ArrayList();
                        instanceUsers.userProfilesAndActivity.stream().forEach(iu -> {
                            if (iu.hasValidTrialToken) {
                                ArrayList<String> iuProfiles = (ArrayList<String>)allTrialProfilesPerUser.get(iu.login);
                                if (iuProfiles == null) {
                                    iuProfiles = new ArrayList<String>();
                                    allTrialProfilesPerUser.put(iu.login, iuProfiles);
                                }
                                iuProfiles.add(iu.userProfile);
                                trialProfilesOnInstance.add(iu.userProfile);
                                instanceLicensingStatus.authorizationMatrix.perUser.users.stream().filter(pu -> pu.login.equals(iu.login)).findFirst().ifPresent(matrixUser -> {
                                    matrixUser.profile = iu.userProfile;
                                    matrixUser.lastSessionActivity = iu.lastSessionActivity;
                                });
                            } else {
                                ArrayList<String> iuProfiles = (ArrayList<String>)allProfilesPerUser.get(iu.login);
                                if (iuProfiles == null) {
                                    iuProfiles = new ArrayList<String>();
                                    allProfilesPerUser.put(iu.login, iuProfiles);
                                }
                                iuProfiles.add(iu.userProfile);
                                userProfilesOnInstance.add(iu.userProfile);
                                instanceLicensingStatus.authorizationMatrix.perUser.users.stream().filter(pu -> pu.login.equals(iu.login)).findFirst().ifPresent(matrixUser -> {
                                    matrixUser.profile = iu.userProfile;
                                    matrixUser.lastSessionActivity = iu.lastSessionActivity;
                                });
                            }
                        });
                        LimitsStatusComputer lsc = new LimitsStatusComputer();
                        instanceLicensingStatus.status.profileLimits = lsc.getLimitsStatus(instanceLicensingStatus.status.licensedProfiles.values(), instanceLicensingStatus.status.fallbackProfile, userProfilesOnInstance, trialProfilesOnInstance);
                    }
                    catch (Exception e) {
                        logger.info((Object)("Failed to get data from instance " + pli.id), (Throwable)e);
                        ret.hasCompleteUsageData = false;
                        if (e.getMessage().contains("local variable 'ret' referenced before assignment") || e.getMessage().contains("Not Found: /dip/publicapi/admin/users-activity")) {
                            logger.info((Object)"Found the error message that indicates the agent is too old for the get_user_info command");
                            instanceLicensingStatus.error = new SerializedError((Throwable)new UnsupportedAgentCommandException(pli.dssNodeType), false);
                        }
                        instanceLicensingStatus.error = new SerializedError((Throwable)e, false);
                    }
                    logger.info((Object)("Done working on instance " + pli.id + " (" + pli.label + ")"));
                }
            }
            logger.info((Object)"Computing global status");
            ret.globalStatus = new LimitsStatusComputer.LicenseLimitsStatus();
            Tenant t = (Tenant)CentralLicensingStatusService.this.dbService.getThreadEM().find(Tenant.class, (Object)this.owner.getTenantId());
            assert (t != null);
            String globalLicense = t.getLicense();
            if (StringUtils.isBlank((String)globalLicense)) {
                throw new Exception("Global license is undefined");
            }
            License globalLicenseObj = (License)JSON.parse((String)globalLicense, License.class);
            LicenseStatusService.LicensingStatus ls = CentralLicensingStatusService.this.buildLicensingStatus(globalLicenseObj);
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)ret.globalStatus);
            ArrayList<String> dedupedGlobalProfiles = new ArrayList<String>();
            for (Map.Entry entry : allProfilesPerUser.entrySet()) {
                String string = new LimitsStatusComputer().getHighestProfile(ret.globalStatus.licensedProfiles.values(), (Collection)entry.getValue(), ret.globalStatus.fallbackProfile);
                logger.info((Object)("For user " + (String)entry.getKey() + " from source profiles " + JSON.json(entry.getValue()) + " kept profile " + string));
                dedupedGlobalProfiles.add(string);
            }
            ArrayList<String> dedupedTrialGlobalProfiles = new ArrayList<String>();
            for (Map.Entry entry : allTrialProfilesPerUser.entrySet()) {
                String highestTrialProfileForUser = new LimitsStatusComputer().getHighestProfile(ret.globalStatus.licensedProfiles.values(), (Collection)entry.getValue(), ret.globalStatus.fallbackProfile);
                logger.info((Object)("For user " + (String)entry.getKey() + " from trial source profiles " + JSON.json(entry.getValue()) + " kept profile " + highestTrialProfileForUser));
                dedupedTrialGlobalProfiles.add(highestTrialProfileForUser);
            }
            LimitsStatusComputer limitsStatusComputer = new LimitsStatusComputer();
            ret.globalStatus.profileLimits = limitsStatusComputer.getLimitsStatus(ret.globalStatus.licensedProfiles.values(), ret.globalStatus.fallbackProfile, dedupedGlobalProfiles, dedupedTrialGlobalProfiles);
            return ret;
        }

        public FuturePayload getPayload() {
            return null;
        }
    }

    static class UserInfoCommandResult {
        PerUserAuthorizationMatrix authorizationMatrix;
        List<GetAssignedUserProfilesCommandUser> userProfilesAndActivity = new ArrayList<GetAssignedUserProfilesCommandUser>();

        UserInfoCommandResult() {
        }
    }

    static class PerUserAuthorizationMatrix {
        PerUser perUser = new PerUser();

        PerUserAuthorizationMatrix() {
        }

        static class PerUser
        extends AuthorizationMatrixBase {
            public List<FMMatrixUser> users = new ArrayList<FMMatrixUser>();

            PerUser() {
            }
        }

        static class FMMatrixUser {
            public String login;
            public String displayName;
            public String email;
            public String profile;
            public String lastSessionActivity;

            FMMatrixUser() {
            }
        }
    }

    static class GetAssignedUserProfilesCommandUser {
        String login;
        String userProfile;
        String lastSessionActivity;
        boolean hasValidTrialToken;

        GetAssignedUserProfilesCommandUser() {
        }
    }
}

