/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.security.sso.FMSSOService;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import com.dataiku.fm.server.settings.SettingsDAO;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIIAMController
extends PublicAPIControllerBase {
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SettingsDAO settingsDAO;
    @Autowired
    private FMSSOService ssoService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/iam/sso-settings"}, method={RequestMethod.GET})
    public void getSSOSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)fmSettings.ssoSettings);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/iam/sso-settings"}, method={RequestMethod.PUT})
    public void updateSSOSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        SSOSettings ssoSettings = (SSOSettings)this.getRequestBodyAs(req, SSOSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            FMSettings fmSettings = this.settingsDAO.read();
            fmSettings.ssoSettings = ssoSettings;
            this.settingsDAO.save(fmSettings);
            t.commit("Save the SSO settings");
        }
        this.ssoService.applySettings();
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)ssoSettings);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/iam/ldap-settings"}, method={RequestMethod.GET})
    public void getLDAPSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)fmSettings.ldapSettings);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/iam/ldap-settings"}, method={RequestMethod.PUT})
    public void updateLDAPSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        LdapSettings ldapSettings = (LdapSettings)this.getRequestBodyAs(req, LdapSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            FMSettings fmSettings = this.settingsDAO.read();
            fmSettings.ldapSettings = ldapSettings;
            this.settingsDAO.save(fmSettings);
            t.commit("Save the LDAP settings");
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)ldapSettings);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/iam/azure-ad-settings"}, method={RequestMethod.GET})
    public void getAzureADSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)fmSettings.azureADSettings);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/iam/azure-ad-settings"}, method={RequestMethod.PUT})
    public void updateAzureADSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        AzureADSettings azureADSettings = (AzureADSettings)this.getRequestBodyAs(req, AzureADSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            FMSettings fmSettings = this.settingsDAO.read();
            fmSettings.azureADSettings = azureADSettings;
            this.settingsDAO.save(fmSettings);
            t.commit("Save the Azure AD settings");
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)azureADSettings);
    }
}

