/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security.auth;

import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.DkuLoginEventService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMLoginEventService
implements DkuLoginEventService {
    private final AuditTrailService auditTrailService;

    @Autowired
    public FMLoginEventService(AuditTrailService auditTrailService) {
        this.auditTrailService = auditTrailService;
    }

    public void onLoginError(String dkuUserLoginCandidate) {
        this.auditTrailService.generic("login-failure").with("login", dkuUserLoginCandidate).emit();
    }

    public void onPasswordBasedLoginSuccess(HttpServletRequest req, DkuUser dkuUser) {
        this.onLoginSuccess(dkuUser);
    }

    public void onSSOLoginSuccess(DkuUser dkuUser) {
        this.onLoginSuccess(dkuUser);
    }

    public void onNoLoginLoginSuccess(DkuUser dkuUser) {
        this.auditTrailService.generic("login-success").with("login", dkuUser.getLogin()).emit();
    }

    public void onLogout(AuthCtx user) {
    }

    private void onLoginSuccess(DkuUser dkuUser) {
        this.auditTrailService.generic("login-success").with("login", dkuUser.getLogin()).emit();
    }
}

