/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.snapshots;

import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.published.DataVolumeSnapshotDTO;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SnapshotsCRUDService {
    @Autowired
    private DatabaseAccessService dbService;

    public List<DataVolumeSnapshotDTO> list(String tenantId, String logicalInstanceId) {
        ArrayList<DataVolumeSnapshotDTO> result = new ArrayList<DataVolumeSnapshotDTO>();
        LogicalInstance li = this.dbService.getSingleResult(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant.id = ?1 AND li.id = ?2", tenantId, logicalInstanceId);
        if (li == null) {
            throw new Error("unknown instance");
        }
        List<DataVolumeSnapshot> in = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1", li);
        for (DataVolumeSnapshot dvs : in) {
            result.add(SnapshotsCRUDService.convertToDTO(dvs));
        }
        return result;
    }

    public DataVolumeSnapshotDTO get(String tenantId, String logicalInstanceId, String snapshotId) {
        LogicalInstance li = this.dbService.getSingleResult(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant.id = ?1 AND li.id = ?2", tenantId, logicalInstanceId);
        if (li == null) {
            throw new Error("unknown instance");
        }
        DataVolumeSnapshot dvs = this.dbService.getSingleResult(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1 ABD dvs.id=?2", li, snapshotId);
        return SnapshotsCRUDService.convertToDTO(dvs);
    }

    public static DataVolumeSnapshotDTO convertToDTO(DataVolumeSnapshot dvs) {
        DataVolumeSnapshotDTO dto = new DataVolumeSnapshotDTO();
        dto.id = dvs.getId();
        dto.logicalInstanceId = dvs.getLogicalInstance().getId();
        dto.awsSnapshotId = dvs.getAwsSnapshotId();
        dto.azureSnapshotId = dvs.getAzureSnapshotId();
        dto.gcpSnapshotId = dvs.getGcpSnapshotId();
        dto.creationDate = dvs.getCreationDate();
        dto.snapshotType = dvs.getSnapshotType();
        dto.description = dvs.getDescription();
        return dto;
    }
}

