/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.fm.cloud.CloudNetworkServiceInterface;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CloudSimulatorNetworkService
implements CloudNetworkServiceInterface {
    private final Cloud cloud;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudAccountsService cloudAccountsService;

    public CloudSimulatorNetworkService(Cloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public boolean needsPeering(String tenantId, VirtualNetwork vn) {
        throw new NotImplementedException("needPeering is not implemented");
    }

    @Override
    public Optional<String> getPeeringId(String tenantId, VirtualNetwork vn) {
        throw new NotImplementedException("getPeeringId is not implemented");
    }

    @Override
    public VirtualNetwork createManagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) {
        throw new NotImplementedException("createManagedVirtualNetwork is not implemented");
    }

    @Override
    public VirtualNetwork createUnmanagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) {
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        assert (tenant != null);
        CloudAccount account = input.accountId != null ? this.cloudAccountsService.getAccountMandatory(tenant, input.accountId) : tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        Object id = input.forcedID != null ? input.forcedID : "vn-" + SecretKeyGenerator.generate((int)12);
        String awsSecurityGroups = "";
        if (this.cloud == Cloud.AWS) {
            if (input.awsAutoCreateSecurityGroups) {
                awsSecurityGroups = "securityGroup1,securityGroup2";
            }
        } else if (input.azureAutoUpdateSecurityGroups) {
            // empty if block
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            VirtualNetwork newVN = new VirtualNetwork();
            newVN.setId((String)id);
            newVN.setMode(input.mode);
            newVN.setLabel(input.label);
            newVN.setTenant(tenant);
            if (StringUtils.isNotEmpty((String)input.accountId)) {
                newVN.setCloudAccount(account);
            }
            if (this.cloud == Cloud.AWS) {
                newVN.setAwsVpcId(input.awsVpcId);
                newVN.setAwsSubnetId(input.awsSubnetId);
                newVN.setAwsSecondSubnetId(input.awsSecondSubnetId);
                newVN.setAwsAvailabilityZone("eu-west1");
                newVN.setAwsSecurityGroups(awsSecurityGroups);
            } else if (this.cloud == Cloud.AZURE) {
                newVN.setAzureVnId(input.azureVnId);
                newVN.setAzureSubnet(input.azureSubnetId);
                newVN.setAzureSecondSubnet(input.azureSecondSubnetId);
                newVN.setAzureRgName("fake-resource-group");
            }
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
            VirtualNetwork virtualNetwork = newVN;
            return virtualNetwork;
        }
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetworkSecurityGroups(VirtualNetwork vn) {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetwork(VirtualNetwork vn, boolean deletePeering) {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public VirtualNetworkMetadata getDefaultCreationValues(String tenanId) {
        VirtualNetworkMetadata result = new VirtualNetworkMetadata();
        if (this.cloud == Cloud.AWS) {
            result.awsVpcId = "vpc-fake-0001";
            result.awsSubnetId = "subnet-fake-0002";
        } else if (this.cloud == Cloud.AZURE) {
            result.azureVNId = "vn-fake-0001";
            result.azureSubnetName = "subnet-fake-0002";
        }
        return result;
    }
}

