/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DSSMetrics {
    static MetricRegistry registry = new MetricRegistry();

    public static MetricRegistry registry() {
        return registry;
    }

    public static void registerJVMMetrics() {
        DSSMetrics.recRegistryAll("jvm.threads.", (MetricSet)new ThreadStatesGaugeSet());
        DSSMetrics.recRegistryAll("jvm.memory.", (MetricSet)new MemoryUsageGaugeSet());
        DSSMetrics.recRegistryAll("jvm.gc.", (MetricSet)new GarbageCollectorMetricSet());
        DSSMetrics.recRegistryAll("jvm.classes.", (MetricSet)new ClassLoadingGaugeSet());
        DSSMetrics.recRegistryAll("jvm.attrs.", (MetricSet)new JvmAttributeGaugeSet());
    }

    public static void startJMXReporter() {
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)DSSMetrics.registry()).build();
        reporter.start();
    }

    public static void recRegistryAll(String prefix, MetricSet metricSet) {
        for (Map.Entry e : metricSet.getMetrics().entrySet()) {
            Metric metric = (Metric)e.getValue();
            if (metric instanceof MetricSet) {
                DSSMetrics.recRegistryAll(prefix + (String)e.getKey() + ".", (MetricSet)metric);
                continue;
            }
            registry.register(prefix + (String)e.getKey(), metric);
        }
    }

    public static void clearAllTimersAndMeters() {
        registry.removeMatching((metricName, metric) -> metric instanceof Timer || metric instanceof Meter);
    }

    public static TimeCtx timeCtx(String x) {
        return new RealTimeCtx(registry.timer(x).time());
    }

    public static TimeCtx timeCtx(Timer timer) {
        return new RealTimeCtx(timer.time());
    }

    public static TimeCtx timeCtxIf(boolean condition, String x) {
        if (condition) {
            return new RealTimeCtx(registry.timer(x).time());
        }
        return new FakeTimeCtx();
    }

    public static MTimeCtx mtimeCtx(String ... names) {
        ArrayList<Timer.Context> ctxs = new ArrayList<Timer.Context>();
        for (String name : names) {
            ctxs.add(registry.timer(name).time());
        }
        return new MTimeCtx(ctxs);
    }

    public static SettableLongGauge settableLongGauge(String key) {
        Object metric = (Metric)registry.getMetrics().get(key);
        if (metric == null) {
            metric = new SettableLongGauge();
            registry.register(key, metric);
        }
        return (SettableLongGauge)metric;
    }

    public static void setSettableLongGauge(String key, long value) {
        Metric metric = (Metric)registry.getMetrics().get(key);
        if (metric == null) {
            SettableLongGauge slg = new SettableLongGauge();
            slg.setValue(value);
            registry.register(key, (Metric)slg);
        } else {
            ((SettableLongGauge)metric).setValue(value);
        }
    }

    public static class RealTimeCtx
    extends TimeCtx {
        Timer.Context context;

        RealTimeCtx(Timer.Context context) {
            this.context = context;
        }

        @Override
        public void close() {
            this.context.close();
        }
    }

    public static class FakeTimeCtx
    extends TimeCtx {
        @Override
        public void close() {
        }
    }

    public static class MTimeCtx
    implements AutoCloseable {
        private final List<Timer.Context> contexts;

        MTimeCtx(List<Timer.Context> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void close() {
            for (Timer.Context context : this.contexts) {
                context.close();
            }
        }
    }

    public static class SettableLongGauge
    implements Gauge<Long> {
        private volatile long value = 0L;

        public void setValue(long value) {
            this.value = value;
        }

        public Long getValue() {
            return this.value;
        }
    }

    public static abstract class TimeCtx
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }
}

